<?php
// /partials/header_patient.php
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// --- ★ INICIO CORRECCIÓN BUG SUPLANTACIÓN v3 (Manejo de "bandera") ★ ---
$needs_avatar_fetch = false;

if (isset($_SESSION['admin_origen_id'])) {
    // 1. Estamos suplantando.
    // Debemos FORZAR la recarga del avatar,
    // ya que $_SESSION['user_avatar'] podría tener el avatar del admin.
    $needs_avatar_fetch = true;

} elseif (isset($_SESSION['user_id']) && !isset($_SESSION['user_avatar'])) {
    // 2. No estamos suplantando, pero el avatar no está en la sesión (login normal).
    // (Esta es la lógica de "auto-reparación" original).
    $needs_avatar_fetch = true;

    // 2b. (Añadido para el Paso 2) Limpiar la bandera si volvemos a ser nosotros mismos y el avatar falta
    if(isset($_SESSION['avatar_is_suplanted'])) {
        unset($_SESSION['avatar_is_suplanted']);
    }

} elseif (isset($_SESSION['user_id']) && isset($_SESSION['avatar_is_suplanted']) && $_SESSION['avatar_is_suplanted'] === true) {
    // 3. (Añadido para el Paso 2) CASO BUG: No estamos suplantando, el avatar EXISTE,
    // pero la bandera dice que es el avatar del SUPLANTADO.
    // ESTE CASO SE MANEJA EN header.php (admin), pero lo limpiamos aquí por si acaso.
     if(isset($_SESSION['avatar_is_suplanted'])) {
        unset($_SESSION['avatar_is_suplanted']);
    }
}


// Esta lógica depende de que $db (de db.php) haya sido incluido por
// el script principal (ej. patient_dashboard.php).
// Comprobamos 'isset($db)' para seguridad.
if ($needs_avatar_fetch && isset($db) && isset($_SESSION['user_id'])) {
    try {
        $stmt_avatar = $db->prepare("SELECT avatar FROM cuentas WHERE id = ?");
        $stmt_avatar->execute([$_SESSION['user_id']]);
        $avatar_path = $stmt_avatar->fetchColumn();
        // Sobrescribir siempre la sesión con el avatar del usuario (suplantado o real)
        $_SESSION['user_avatar'] = $avatar_path ?: null;

        // --- ★ ESTA ES LA LÍNEA AÑADIDA (PASO 1) ★ ---
        // Si estamos suplantando, marcamos la bandera.
        if (isset($_SESSION['admin_origen_id'])) {
            $_SESSION['avatar_is_suplanted'] = true;
        }
        // --- ★ FIN LÍNEA AÑADIDA ★ ---

    } catch (Exception $e) {
        error_log("Error al forzar recarga de avatar en header_patient: " . $e->getMessage());
        $_SESSION['user_avatar'] = null; // Prevenir re-intentos
    }
}
// --- ★ FIN CORRECCIÓN BUG SUPLANTACIÓN v3 ★ ---


// --- INICIO DE LA NUEVA LÓGICA PARA EL CONTADOR DE MENSAJES ---
$total_unread_messages = 0;
// Nos aseguramos de que la sesión y la BBDD ($db) estén disponibles
// ($db es inicializado por el script que incluye este header, como patient_dashboard.php o chat_patient.php)
// ===== INICIO MODIFICACIÓN (Ocultar Chat durante suplantación) =====
if (isset($_SESSION['user_id']) && $_SESSION['user_rol'] === 'paciente' && isset($db) && !isset($_SESSION['admin_origen_id'])) {
// ===== FIN MODIFICACIÓN =====
    try {
        $patient_id_for_header = $_SESSION['user_id'];
        // *** CORRECCIÓN AQUÍ: Cambiado COUNT(*) por COUNT(DISTINCT from_id) ***
        $stmt_unread = $db->prepare("
            SELECT COUNT(DISTINCT from_id)
            FROM chat_messages
            WHERE to_id = :patient_id AND status != 'read'
        ");
        $stmt_unread->execute([':patient_id' => $patient_id_for_header]);
        $total_unread_messages = (int)$stmt_unread->fetchColumn();
        // Asegurarse de que es un número (devuelve 0 si no hay filas)
        $total_unread_messages = $total_unread_messages ?: 0;
    } catch (Exception $e) {
        // Si hay un error, no mostramos nada, pero lo registramos
        error_log("Error al calcular mensajes no leídos en header_patient.php: " . $e->getMessage());
        $total_unread_messages = 0;
    }
}
// --- FIN DE LA NUEVA LÓGICA ---

// --- NUEVO: Comprobar si hay tratamientos activos para mostrar el enlace de mensajes ---
$has_active_treatment = false;
// Usamos la misma condición que para el contador de mensajes
if (isset($patient_id_for_header) && isset($db)) {
    try {
        $stmt_active_check = $db->prepare("SELECT 1 FROM tratamientos WHERE paciente_id = :patient_id AND status = 'En curs' LIMIT 1");
        $stmt_active_check->execute([':patient_id' => $patient_id_for_header]);
        // fetchColumn() devuelve false si no hay filas, lo convertimos a booleano
        if ($stmt_active_check->fetchColumn()) {
            $has_active_treatment = true;
        }
    } catch (Exception $e) {
        error_log("Error comprobando tratamientos activos en header_patient.php: " . $e->getMessage());
        // En caso de error, mantenemos $has_active_treatment como false
        $has_active_treatment = false;
    }
}
// --- FIN NUEVO ---

?>
<!DOCTYPE html>
<html lang="ca">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= $page_title ?? 'AVANT ONLINE' ?></title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css">
    <link rel="stylesheet" href="style.css">
    <link rel="stylesheet" href="https://npmcdn.com/flatpickr/dist/plugins/weekSelect/weekSelect.css">
    <link rel="stylesheet" href="patient_dashboard.css?v=1.0">

    <style>
            /* --- ESTILOS PARA AVATAR (AÑADIDOS) --- */
            .user-avatar-icon {
                width: 50px;
                height: 50px;
                object-fit: cover;
                border-radius: 50%;
                border: 2px solid #ffffff; /* Borde blanco */
                box-shadow: 0 1px 3px rgba(0,0,0,0.15); /* Sombra sutil */
            }
            .user-avatar-placeholder {
                width: 50px;
                height: 50px;
                border-radius: 50%;
                background-color: #e9ecef;
                color: #6c757d;
                display: flex;
                align-items: center;
                justify-content: center;
                font-size: 1.8rem; /* Tamaño del icono interior */
                border: 2px solid #ffffff;
                box-shadow: 0 1px 3px rgba(0,0,0,0.15);
            }
            /* --- FIN ESTILOS AVATAR --- */

            /* Estilos para el modal de feedback de estrellas */
            .star-rating {
                font-size: 2rem;
                color: #d3d3d3;
                cursor: pointer;
            }
            .star-rating .bi-star-fill {
                color: #ffc107;
            }

            /* [NUEVO] Estilos para el modal de ejercicio y thumbnails */
            .modal-video, .modal-image {
                max-width: 100%;
                height: auto;
                max-height: 70vh; /* Evita que el video sea demasiado alto en pantallas grandes */
                border-radius: 0.25rem;
            }
            .no-media-placeholder-modal {
                display: flex;
                flex-direction: column;
                justify-content: center;
                align-items: center;
                color: #adb5bd;
                min-height: 300px;
                background-color: #212529;
                border-radius: .25rem;
            }
            .no-media-placeholder-modal i {
                font-size: 4rem;
            }
            /* [NUEVO] Para prevenir la descarga */
            .noselect {
                -webkit-user-select: none; /* Safari */
                -ms-user-select: none; /* IE 10+ */
                user-select: none; /* Standard syntax */
            }

            .exercise-thumbnail {
                width: 120px;
                height: 68px;
                object-fit: cover;
                border-radius: .375rem;
                background-color: #e9ecef;
            }
            .no-media-placeholder {
                display: flex;
                align-items: center;
                justify-content: center;
                font-size: 2rem;
                color: #6c757d;
            }
            /* ESTILO AÑADIDO: Para aumentar el tamaño de "Hola, User" */
            .user-greeting {
                font-size: 1.15rem; /* Aumenta el tamaño de la fuente */
                font-weight: 500; /* Pone el texto en negrita */
            }

            /* ===== INICIO MODIFICACIÓN (Estilo del badge RESTAURADO) ===== */
            /* Estilo para el badge de mensajes no leídos */
            #unread-messages-badge {
                top: 7px;
                right: -11px;
                font-size: 0.7em;
                width: 1.8em;
                height: 1.8em;
                padding: 0;
                display: flex;
                align-items: center;
                justify-content: center;
                line-height: 1;
            }
            /* ===== FIN MODIFICACIÓN ===== */

            /* --- ★ INICIO MODIFICACIÓN: ESTILOS PARA SUPLANTACIÓN (CORREGIDOS) ★ --- */
            <?php if (isset($_SESSION['admin_origen_id'])): ?>
            body {
                /* * CORRECCIÓN:
                 * 72px (header principal de style.css) + 50px (barra suplantación) = 122px
                 * Usamos !important para asegurar que sobreescribe el padding-top de style.css
                */
                padding-top: 122px !important;
            }
            .impersonation-bar {
                background-color: #ffc107; /* Amarillo advertencia */
                color: #000;
                padding: 0.75rem 1rem;
                text-align: center;
                font-weight: bold;
                position: fixed;
                top: 0;
                left: 0;
                width: 100%;
                z-index: 1031; /* Justo encima del header (header tiene 1030) */
                height: 50px; /* Altura fija para la barra */
            }
            .impersonation-bar a {
                color: #000;
                font-weight: bold;
                text-decoration: underline;
            }
            .impersonation-bar a:hover {
                color: #333;
            }
            /* Ajustes de layout cuando la barra está activa */
            header.navbar {
                top: 50px; /* Mover el header debajo de la nueva barra (altura de la barra 50px) */
            }

            <?php endif; ?>
            /* --- ★ FIN MODIFICACIÓN --- */

        </style>

        <style>
            /*
             * 1. Asegura que el contenedor del dropdown sea 'relative'.
             * Esto es necesario para que el menú (que será 'absolute') se
             * posicione correctamente debajo de él.
            */
            header.navbar .dropdown {
                position: relative !important;
            }

            /*
             * 2. Forzar que el menú sea 'absolute' en pantallas móviles.
             * (Bootstrap lo pone 'static' por defecto en vistas colapsadas,
             * lo que causa que "empuje" la barra).
             * 991.98px es el breakpoint 'lg' de Bootstrap (navbar-expand-lg).
            */
            @media (max-width: 991.98px) {
                header.navbar .dropdown-menu {
                    position: absolute !important;
                }
            }
        </style>

</head>
<body <?= isset($_SESSION['admin_origen_id']) ? 'data-impersonating="true"' : '' ?>>

<?php if (isset($_SESSION['admin_origen_id'])): ?>
    <div class="impersonation-bar">
        <i class="bi bi-exclamation-triangle-fill"></i>
        Estàs suplantant a
        <strong><?= htmlspecialchars($_SESSION['user_nombre']) ?> <?= htmlspecialchars($_SESSION['user_apellido'] ?? '') ?></strong>.

        <i class="bi bi-info-circle"
           style="cursor: help;"
           data-bs-toggle="tooltip"
           data-bs-placement="bottom"
           data-bs-html="true"
           title="<b>Mode de Suplantació:</b><br><br>
           <b>POTS:</b><br>
                  Pots veure els tractaments i l'historial del pacient.<br>
                  <br><b class='text-danger'>NO POTS:</b><br>
                  - Accedir al seu Xat (privacitat).<br>
                  - Modificar el seu perfil.<br>
                  - Enviar feedback d'exercicis.">
        </i>
        <a href="stop_impersonating.php" class="ms-3"><< Tornar</a>
    </div>
<?php endif; ?>
<header class="navbar navbar-expand-lg fixed-top">
    <div class="container">

        <a class="navbar-brand fw-bold me-auto" href="patient_dashboard.php">
            <i class="bi bi-heart-pulse-fill me-2" style="color: #77b9af;"></i>Avant Online
        </a>

        <?php if (isset($_SESSION['user_id'])): ?>

        <div class="navbar-nav ms-auto d-flex flex-row align-items-center">

             <ul class="navbar-nav">
                 <?php // ===== INICIO MODIFICACIÓN (Ocultar Chat durante suplantación) ===== ?>
                 <?php if ($has_active_treatment && !isset($_SESSION['admin_origen_id'])): ?>
                 <?php // ===== FIN MODIFICACIÓN ===== ?>
                 <li class="nav-item">
                     <a class="nav-link position-relative me-3" href="chat_patient.php" title="Xat">
                         <i class="bi bi-chat-dots-fill fs-5"></i>
                         <span class="d-none d-lg-inline ms-1">Xat</span>
                         <span id="unread-messages-badge" class="position-absolute badge rounded-pill bg-danger"
                               style="<?= ($total_unread_messages > 0) ? '' : 'display: none;' ?>">
                             <span id="unread-messages-count"><?= $total_unread_messages > 9 ? '9+' : ($total_unread_messages > 0 ? $total_unread_messages : '') ?></span>
                             <span class="visually-hidden">missatges sense llegir</span>
                         </span>
                     </a>
                 </li>
                 <?php endif; ?>
             </ul>

            <div class="nav-item dropdown">

                <a class="nav-link" href="#" role="button" data-bs-toggle="dropdown" aria-expanded="false" title="Menú d'usuari">
                    <i class="bi bi-list fs-2"></i> </a>

                <ul class="dropdown-menu dropdown-menu-end">

                    <?php // ===== INICIO MODIFICACIÓN (Convertir cabecera en enlace a Perfil) ===== ?>
                    <?php if (!isset($_SESSION['admin_origen_id'])): // Si NO estamos suplantando, es un enlace ?>
                    <li>
                        <a class="dropdown-item d-flex align-items-center px-3 pt-2 pb-1"
                           href="#"
                           data-bs-toggle="modal"
                           data-bs-target="#profileModal"
                           title="Dades Personals:"
                           style="cursor: pointer;">

                            <?php if (isset($_SESSION['user_avatar']) && !empty($_SESSION['user_avatar'])): ?>
                                <img src="<?= htmlspecialchars($_SESSION['user_avatar']) ?>" alt="Avatar" class="user-avatar-icon me-2" id="header-avatar-icon" style="width:40px; height:40px;">
                            <?php else: ?>
                                <div class="user-avatar-placeholder me-2" id="header-avatar-icon" style="width:40px; height:40px; font-size: 1.5rem;">
                                    <i class="bi bi-person-circle"></i>
                                </div>
                            <?php endif; ?>
                            <span class="user-greeting">Hola, <?= htmlspecialchars($_SESSION['user_nombre']) ?></span>
                        </a>
                    </li>

                    <?php else: // Si ESTAMOS suplantando, es solo texto (sin enlace) ?>
                    <li>
                        <div class="d-flex align-items-center px-3 pt-2 pb-1">
                            <?php if (isset($_SESSION['user_avatar']) && !empty($_SESSION['user_avatar'])): ?>
                                <img src="<?= htmlspecialchars($_SESSION['user_avatar']) ?>" alt="Avatar" class="user-avatar-icon me-2" id="header-avatar-icon" style="width:40px; height:40px;">
                            <?php else: ?>
                                <div class="user-avatar-placeholder me-2" id="header-avatar-icon" style="width:40px; height:40px; font-size: 1.5rem;">
                                    <i class="bi bi-person-circle"></i>
                                </div>
                            <?php endif; ?>
                            <span class="user-greeting">Hola, <?= htmlspecialchars($_SESSION['user_nombre']) ?></span>
                        </div>
                    </li>
                    <?php endif; ?>
                    <?php // ===== FIN MODIFICACIÓN ===== ?>

                    <li><hr class="dropdown-divider mt-1"></li>

                    <?php // ===== ELIMINADO: "El meu perfil" y su divisor (movido a la cabecera) ===== ?>

                    <li>
                        <a class="dropdown-item" id="history-menu-link" href="#" data-bs-toggle="modal" data-bs-target="#historyModal">
                            <i class="bi bi-clock-history me-2"></i>Historial de Tractaments
                        </a>
                    </li>
                    <li>
                        <a class="dropdown-item" id="report-menu-link" href="reports/patient_report.php" target="_blank">
                            <i class="bi bi-printer me-2"></i>Generar Informe
                        </a>
                    </li>
                    <li><hr class="dropdown-divider"></li>
                    <li>
                        <a class="dropdown-item" href="help/help_pacientes.html" target="_blank">
                            <i class="bi bi-life-preserver me-2"></i>Ajuda
                        </a>
                    </li>

                    <?php if (!isset($_SESSION['admin_origen_id'])): ?>
                    <li><hr class="dropdown-divider"></li>
                    <li>
                        <a class="dropdown-item" href="logout.php" id="logout-link">
                            <i class="bi bi-box-arrow-right me-2"></i>Tancar sessió
                        </a>
                    </li>
                    <?php endif; ?>
                </ul>
            </div>
        </div>
        <?php endif; ?>
    </div>
</header>

</body>
</html>
