<?php
// /db.php - Configuración de Conexión a la Base de Datos MySQL/MariaDB (PDO)

// =========================================================================
// !!! ATENCIÓN: MODIFICA ESTAS CONSTANTES CON TUS CREDENCIALES REALES !!!
// =========================================================================

// Configuración de la base de datos MySQL/MariaDB (Para XAMPP en entorno local)
define('DB_HOST', 'localhost'); // 99% de las veces es 'localhost'
define('DB_USER', 'francesc_avant_online_mysql');      // 99% de las veces es 'root' en Xampp/MAMP
define('DB_PASS', 'Iescopa1+');          // ¡IMPORTANTE! Si en Xampp no definió contraseña, DEBE estar vacío (sin comillas)
define('DB_NAME', 'francesc_avant_online_mysql'); // Debe coincidir EXACTAMENTE con el nombre de la DB

// Variable obsoleta de SQLite (mantenida por si alguna función antigua la usa)
$db_path = DB_NAME;

try {
    // Establecer la conexión usando PDO para MySQL
    $dsn = 'mysql:host=' . DB_HOST . ';dbname=' . DB_NAME . ';charset=utf8mb4';
    $db = new PDO($dsn, DB_USER, DB_PASS);

    // Configurar el modo de error para que PDO lance excepciones en caso de fallo (CRÍTICO)
    $db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // Establecer el modo de fetch por defecto para que devuelva arrays asociativos
    $db->setAttribute(PDO::ATTR_DEFAULT_FETCH_MODE, PDO::FETCH_ASSOC);

} catch (PDOException $e) {
    // En caso de error de conexión, registrarlo y mostrar un mensaje crítico
    error_log("Error de conexión a la base de datos MySQL: " . $e->getMessage());
    die("<h1>Error crítico de conexión a la base de datos. Por favor, verifica las credenciales en db.php.</h1>");
}

// Nota: Ahora la variable global $db contiene el objeto PDO conectado a MySQL.
// Todas las consultas SQL en la aplicación se ejecutarán contra esta nueva base de datos.


// =========================================================================
// ★★★ INICIO: FUNCIÓN DE AUDITORÍA GLOBAL ★★★
// =========================================================================

/**
 * Registra una acción en el log de auditoría.
 * Se define aquí porque db.php se incluye globalmente y la función necesita la $db.
 *
 * Esta función está diseñada para manejar las diferentes formas en que es llamada en la app:
 * 1. log_audit_action('ACCION', $actor_id)
 * 2. log_audit_action('ACCION', $actor_id, $target_object_id, $details)
 *
 * @param string $action         La acción realizada (ej. 'LOGIN_SUCCESS')
 * @param int $actor_user_id     ID del usuario que realiza la acción (o null para 'Sistema')
 * @param int|null $target_object_id ID del objeto afectado (ej. ID de usuario nuevo, ID de tratamiento)
 * @param string|null $details      Detalles extra (ej. nombre de archivo, rol)
 */
function log_audit_action($action, $actor_user_id, $target_object_id = null, $details = null) {

    // Usar la conexión $db global definida en este mismo archivo.
    global $db;

    // Evitar error si la $db no está lista (aunque no debería pasar)
    if (!$db) {
        error_log("Error de auditoría: la conexión \$db no está disponible para la acción '$action'.");
        return;
    }

    try {
        // 1. Obtener el nombre de usuario del actor
        $actor_username = "Sistema"; // Por defecto
        if ($actor_user_id) {
            // Primero, intentar obtenerlo de la sesión si ya existe (más rápido)
            if (isset($_SESSION['user_nombre']) && $_SESSION['user_id'] == $actor_user_id) {
                $actor_username = trim($_SESSION['user_nombre'] . ' ' . ($_SESSION['user_apellido'] ?? ''));
            } else {
                // Si no, consultarlo (ej. en login, la sesión aún no está completa)
                $stmt_user = $db->prepare("SELECT nombre, apellido FROM cuentas WHERE id = ?");
                $stmt_user->execute([$actor_user_id]);
                $user = $stmt_user->fetch();
                if ($user) {
                    $actor_username = trim($user['nombre'] . ' ' . $user['apellido']);
                } else {
                    $actor_username = "Usuari ID:$actor_user_id";
                }
            }
        }

        // 2. Añadir detalles al nombre de usuario (basado en el formato de tus logs)
        if (!empty($details)) {
            $actor_username .= " ($details)";
        }

        // 3. Obtener la IP del cliente
        $ip_address = $_SERVER['REMOTE_ADDR'] ?? 'Desconegut';

        // 4. Determinar el target_user_id
        // Basado en tu log de 'USER_REGISTERED', parece que target_user_id se rellena
        // con el ID del actor, y target_object_id con el ID del nuevo usuario.
        $final_target_user_id = null;
        if ($action === 'USER_REGISTERED' || $action === 'IMPERSONATE_START' || $action === 'IMPERSONATE_STOP') {
             // En estos casos, el log muestra que target_user_id es el actor
             $final_target_user_id = $actor_user_id;
        }
        // Nota: Para otras acciones, será NULL, lo cual es correcto.

        // 5. Preparar y ejecutar la inserción
        $sql = "INSERT INTO log_auditoria
                    (actor_user_id, actor_username, action, target_user_id, target_object_id, ip_address, timestamp)
                VALUES
                    (:actor_id, :username, :action, :target_user, :target_obj, :ip, NOW())";

        $stmt = $db->prepare($sql);
        $stmt->execute([
            ':actor_id' => $actor_user_id,
            ':username' => $actor_username,
            ':action' => $action,
            ':target_user' => $final_target_user_id,
            ':target_obj' => $target_object_id, // Este es el $param3
            ':ip' => $ip_address
        ]);

    } catch (Exception $e) {
        // Si el log falla, no detener la aplicación, solo registrar el error del log.
        error_log("Error crítico al ejecutar log_audit_action ('$action'): " . $e->getMessage());
    }
}

// =========================================================================
// ★★★ FIN: FUNCIÓN DE AUDITORÍA GLOBAL ★★★
// =========================================================================


// =========================================================================
// ★★★ INICIO: NUEVAS FUNCIONES DE CONFIGURACIÓN DE EMAIL ★★★
// =========================================================================

/**
 * Obtiene todas las configuraciones de email para el modal de Admin.
 *
 * @return array
 */

 function get_all_email_settings() {
     global $db;
     // La consulta corregida (sin is_critical)
     $stmt = $db->query("SELECT setting_name, description, is_enabled FROM email_settings");
     return $stmt->fetchAll(PDO::FETCH_ASSOC);
 }

// =========================================================================
// ★★★ FIN: NUEVAS FUNCIONES DE CONFIGURACIÓN DE EMAIL ★★★
// =========================================================================
?>
