<!DOCTYPE html>
<html lang="ca">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Política de Cookies - AVANT ONLINE</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
    <link rel="stylesheet" href="../style.css"> <?php // Apunta a la fulla d'estil principal ?>
    <style>
        body { background-color: #f8f9fa; }
        .legal-header {
            background-color: var(--custom-brand-purple, #684987);
            color: white;
            padding: 2rem 0;
        }
        .card-body h3 {
            color: var(--custom-brand-purple, #684987);
            margin-top: 1.5rem;
            margin-bottom: 1rem;
            border-bottom: 2px solid #e9ecef;
            padding-bottom: 0.5rem;
        }
    </style>
</head>
<body>

    <header class="legal-header text-center">
        <div class="container">
            <h1 class="h2 fw-bold"><i class="bi bi-cookie me-2"></i>Política de Cookies</h1>
            <p class="lead mb-0">Com utilitzem les cookies a la nostra plataforma.</p>
        </div>
    </header>

    <main class="container py-5">
        <div class="row justify-content-center">
            <div class="col-lg-10">
                <div class="card shadow-sm border-0">
                    <div class="card-body p-4 p-md-5">

                        <h3>1. Què és una Cookie?</h3>
                        <p>Una cookie és un petit fitxer de text que un lloc web emmagatzema al navegador de l'usuari. Les cookies faciliten l'ús i la navegació per una pàgina web i són essencials per al funcionament d'Internet, aportant innombrables avantatges en la prestació de serveis interactius.</p>

                        <h3>2. Tipus de Cookies que Utilitzem</h3>
                        <p>AVANT ONLINE utilitza un nombre molt limitat de cookies, centrades exclusivament a garantir el funcionament de la plataforma:</p>

                        <h5 class="fw-bold mt-4">Cookies Tècniques o Essencials</h5>
                        <p>Aquestes cookies són estrictament necessàries per al funcionament de la plataforma. No requereixen el consentiment de l'usuari.</p>
                        <ul>
                            <li>
                                <strong>Cookie de Sessió (PHPSESSID):</strong> Aquesta és la cookie principal que utilitzem. S'encarrega de mantenir la teva sessió iniciada mentre navegues per AVANT ONLINE. Sense ella, hauries d'iniciar sessió a cada pàgina que visitis. S'elimina automàticament quan tanques el navegador.
                            </li>
                        </ul>

                        <h5 class="fw-bold mt-4">Cookies Analítiques</h5>
                        <p>Actualment, AVANT ONLINE <strong>no utilitza</strong> cookies d'anàlisi pròpies o de tercers (com Google Analytics) per rastrejar l'activitat dels usuaris amb finalitats estadístiques.</p>

                        <h5 class="fw-bold mt-4">Cookies de Tercers (Contingut Incrustat)</h5>
                        <p>La plataforma permet als Professionals incloure vídeos d'exercicis allotjats en serveis de tercers, com ara <strong>YouTube</strong>.</p>
                        <p>En visualitzar aquests vídeos, aquests serveis externs poden instal·lar les seves pròpies cookies analítiques o de publicitat. AVANT ONLINE no té cap control sobre aquestes cookies ni accés a les dades que recullen. Et recomanem consultar les polítiques de privacitat i cookies d'aquestes plataformes.</p>

                        <h3>3. Com Gestionar i Desactivar les Cookies</h3>
                        <p>Pots permetre, bloquejar o eliminar les cookies instal·lades al teu equip mitjançant la configuració de les opcions del navegador instal·lat al teu ordinador.</p>

                        <div class="alert alert-danger">
                            <strong>Atenció:</strong> Si bloqueges la nostra cookie de sessió (PHPSESSID), la plataforma <strong>deixarà de funcionar</strong> correctament, ja que no podràs mantenir la sessió iniciada.
                        </div>

                        <p class="mt-3">A continuació, t'oferim enllaços on trobaràs informació sobre com configurar les teves preferències als principals navegadors:</p>
                        <ul>
                            <li><a href="https://support.google.com/chrome/answer/95647?hl=es" target="_blank" rel="noopener noreferrer">Google Chrome</a></li>
                            <li><a href="https://support.mozilla.org/es/kb/habilitar-y-deshabilitar-cookies-sitios-web-rastrear-preferencias" target="_blank" rel="noopener noreferrer">Mozilla Firefox</a></li>
                            <li><a href="https://support.microsoft.com/es-es/microsoft-edge/eliminar-las-cookies-en-microsoft-edge-63947406-40ac-c3b8-57b9-2a946a29ae09" target="_blank" rel="noopener noreferrer">Microsoft Edge</a></li>
                            <li><a href="https://support.apple.com/es-es/guide/safari/sfri11471/mac" target="_blank" rel="noopener noreferrer">Safari (Mac)</a></li>
                        </ul>

                        <h3>4. Canvis en la Política de Cookies</h3>
                        <p>Podem actualitzar la nostra Política de Cookies en el futur. Et notificarem de qualsevol canvi substancial a través de la plataforma o per correu electrònic.</p>

                        <hr class="my-5">
                        <div class="text-center">
                            <a href="../index.php" class="btn btn-outline-primary mt-3">
                                <i class="bi bi-arrow-left me-2"></i>Tornar a l'inici
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </main>

    <footer class="text-center py-4 mt-5">
        <span class="text-muted">&copy; <?= date('Y') ?> AVANT ONLINE. Tots els drets reservats.</span>
    </footer>

</body>
</html>
