<?php
// /reports/fisio_report.php

// --- 1. GESTIÓN DE SESIÓN Y DEPENDENCIAS ---
session_start();
// PERMISO: Permitir a fisios y superadmins ver este informe
if (!isset($_SESSION['user_id']) || !in_array($_SESSION['user_rol'], ['fisio', 'superadmin'])) {
    header('Location: ../index.php'); // Salir de la carpeta /reports/
    exit;
}
require '../db.php'; // Salir de la carpeta /reports/ para encontrar db.php
$page_title = "Informe de Pacients";

// *** ¡INICIO DE LA MODIFICACIÓN! ***
// 1. Capturar la página de retorno (ej: 'users.php')
// Usamos basename() por seguridad, para evitar que nos pasen rutas raras
$return_page = basename($_GET['return_to'] ?? 'dashboard.php');

// 2. Construir la URL de retorno subiendo un nivel (../)
$return_to = '../' . htmlspecialchars($return_page);
// *** ¡FIN DE LA MODIFICACIÓN! ***


// --- 2. RECOPILACIÓN DE DATOS ---
$stmt_pacientes = $db->prepare(
    "SELECT id, nombre, apellido, email, telefono, rol, fecha_creacion
     FROM cuentas
     WHERE rol = 'paciente'
     ORDER BY apellido, nombre"
);
$stmt_pacientes->execute();
$pacientes = $stmt_pacientes->fetchAll(PDO::FETCH_ASSOC);


// Función simple para formatear fechas
function formatDate($dateStr) {
    if (empty($dateStr)) return 'N/A';
    try {
        return (new DateTime($dateStr))->format('d/m/Y');
    } catch (Exception $e) {
        return 'Data invàlida';
    }
}
?>
<!DOCTYPE html>
<html lang="ca">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= $page_title ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
    <style>
        :root {
            --bs-body-font-family: "Segoe UI", "Helvetica Neue", Arial, sans-serif;
        }
        body {
            background-color: #e9ecef;
            -webkit-print-color-adjust: exact !important;
            color-adjust: exact !important;
        }
        .report-container {
            max-width: 900px;
            margin: 20px auto;
            padding: 40px;
            background-color: #ffffff;
            border: 1px solid #dee2e6;
            box-shadow: 0 0.125rem 0.25rem rgba(0, 0, 0, .075);
        }
        .report-header {
            text-align: center;
            border-bottom: 2px solid #000;
            padding-bottom: 15px;
            margin-bottom: 30px;
        }
        .report-header h1 { font-weight: 300; margin-bottom: 0; }
        .report-header h4 { font-weight: 700; color: #31a3a3; }
        .section-title {
            font-weight: 600;
            border-bottom: 1px solid #dee2e6;
            padding-bottom: 8px;
            margin-top: 25px;
            margin-bottom: 15px;
            color: #31a3a3;
        }
        .user-table {
            font-size: 0.9rem;
        }
        .user-table th {
            background-color: #f8f9fa;
        }
        /* ELIMINADO: .print-button-container */

        @media print {
            body { background-color: #ffffff; margin: 0; font-size: 10pt; }
            .no-print { display: none !important; }
            .report-container {
                width: 100%;
                max-width: 100%;
                margin: 0;
                padding: 10mm;
                border: none;
                box-shadow: none;
            }
            .user-table th { background-color: #f8f9fa !important; }
            .user-table { font-size: 9pt; }
            a { text-decoration: none; color: #000 !important; }
        }
    </style>
</head>
<body>

    <div class="report-container" id="report-content">

        <div class="d-flex justify-content-end mb-4 no-print">
            <a href="<?= $return_to ?>" class="btn btn-outline-secondary">
                <i class="bi bi-arrow-left me-2"></i>Tornar
            </a>
            <button id="print-btn" class="btn btn-primary ms-2">
                <i class="bi bi-printer me-2"></i>Imprimir
            </button>
        </div>
        <header class="report-header">
            <h4>AVANT ONLINE</h4>
            <h1>Informe de Pacients</h1>
            <p class="text-muted mb-0">Generat el: <?= (new DateTime())->format('d/m/Y H:i') ?></p>
        </header>

        <main>
            <section id="patient-list">
                <h3 class="section-title">Pacients Registrats</h3>
                <?php if (empty($pacientes)): ?>
                    <p class="text-muted">No s'han trobat pacients registrats.</p>
                <?php else: ?>
                    <table class="table table-sm table-bordered table-striped user-table">
                        <thead class="table-light">
                             <tr>
                                <th>ID</th>
                                <th>Nom Complet</th>
                                <th>Email</th>
                                <th>Telèfon</th>
                                <th>Registrat des de</th>
                            </tr>
                        </thead>
                        <tbody>
                        <?php foreach ($pacientes as $pacient): ?>
                            <tr>
                                <td><?= $pacient['id'] ?></td>
                                <td><?= htmlspecialchars($pacient['apellido'] . ', ' . $pacient['nombre']) ?></td>
                                <td><?= htmlspecialchars($pacient['email']) ?></td>
                                <td><?= htmlspecialchars($pacient['telefono'] ?? 'N/A') ?></td>
                                <td><?= formatDate($pacient['fecha_creacion']) ?></td>
                            </tr>
                        <?php endforeach; ?>
                        </tbody>
                    </table>
                <?php endif; ?>
            </section>

        </main>
    </div>

    <script>
        document.getElementById('print-btn').addEventListener('click', function() {
            window.print();
        });
    </script>
</body>
</html>
