<?php
// /protocols.php

// --- 1. GESTIÓN DE SESIÓN Y DEPENDENCIAS ---
session_start();
if (!isset($_SESSION['user_id'])) { header('Location: index.php'); exit; }
if ($_SESSION['user_rol'] === 'paciente') { header('Location: patient_dashboard.php'); exit; }

require_once 'db.php';
$user_rol = $_SESSION['user_rol'];
$user_id = $_SESSION['user_id'];
if (!defined('PROTOCOLS_PER_PAGE')) {
    define('PROTOCOLS_PER_PAGE', $_SESSION['records_per_page'] ?? 8);
}

// --- OBTENER PREFERENCIA DE FILTRO Y VISTA DEL USUARIO ---
$filtro_defecto = 0;
$user_view_prefs_json = '{}'; // Por defecto, un JSON vacío
if (in_array($user_rol, ['superadmin', 'fisio'])) {
    // Leemos ambas columnas de preferencias
    $stmt_prefs = $db->prepare("SELECT filtro_personal_defecto, vista_defecto FROM cuentas WHERE id = ?");
    $stmt_prefs->execute([$user_id]);
    if ($user_prefs = $stmt_prefs->fetch(PDO::FETCH_ASSOC)) {
        $filtro_defecto = $user_prefs['filtro_personal_defecto'];
        // Aseguramos que pasamos un JSON válido a JS, incluso si es null en la BD
        $user_view_prefs_json = $user_prefs['vista_defecto'] ?? '{}';
    }
}

// --- 2. GESTOR DE PETICIONS AJAX ---
if (isset($_REQUEST['ajax'])) {
    header('Content-Type: application/json');
    $action = $_REQUEST['action'] ?? 'read';

    try {
        switch ($action) {

          case 'read_protocols':
                          $page = (int)($_GET['page'] ?? 1);
                          $search = $_GET['search'] ?? '';
                          // ★★★ AÑADIR ESTA LÍNEA ★★★
                          $categoryId = $_GET['categoryId'] ?? '';
                          // ★★★ FIN ★★★

                          // --- ★ CORRECCIÓN 2 (Botones) ---
                          // 1. Quitar 'exercise_count' de las ordenaciones válidas
                          $valid_sorts = ['id', 'title', 'creator_surname', 'created_at'];
                          $sort = in_array($_GET['sort'] ?? '', $valid_sorts) ? $_GET['sort'] : 'created_at';
                          // --- ★ FIN CORRECCIÓN 2 ---

                          $order = ($_GET['order'] ?? 'DESC') === 'ASC' ? 'ASC' : 'DESC';
                          $creatorId = $_GET['creatorId'] ?? '';
                          $filterMine = ($_GET['filterMine'] ?? 'false') === 'true';

                          $params = [':search' => '%' . $search . '%'];
                          // Asumiendo que creator_fisio_id existe en tratamientos
                          $whereClause = "WHERE t.is_protocol = 1 AND (t.title LIKE :search OR t.anamnesis LIKE :search OR t.diagnostico LIKE :search)";

                          // ★★★ AÑADIR ESTE BLOQUE ★★★
                          if (!empty($categoryId)) {
                              $whereClause .= " AND EXISTS (
                                  SELECT 1 FROM tratamiento_ejercicios te
                                  JOIN ejercicios e ON te.ejercicio_id = e.id
                                  WHERE te.tratamiento_id = t.id AND e.id_categoria = :category_id
                              )";
                              $params[':category_id'] = $categoryId;
                          }
                          // ★★★ FIN ★★★

                          if ($filterMine && in_array($user_rol, ['superadmin', 'fisio'])) {
                              // **MODIFICADO**: Ahora 'filterMine' incluye ser creador O colaborador
                              $whereClause .= " AND (
                                  t.creator_fisio_id = :user_id
                                  OR EXISTS (
                                      SELECT 1 FROM tratamiento_fisios_asignados tfa
                                      WHERE tfa.tratamiento_id = t.id AND tfa.fisio_id = :user_id
                                  )
                              )";
                              $params[':user_id'] = $user_id;
                          } elseif (!empty($creatorId)) {
                              $whereClause .= " AND t.creator_fisio_id = :creator_id";
                              $params[':creator_id'] = $creatorId;
                          }

                          if (in_array($user_rol, ['superadmin', 'fisio'])) {
                              $whereClause .= " AND NOT EXISTS (SELECT 1 FROM archivado_personal ap WHERE ap.item_id = t.id AND ap.item_type = 'protocol' AND ap.fisio_id = :current_fisio_id)";
                              $params[':current_fisio_id'] = $user_id;
                          }

                          $totalQuery = "SELECT COUNT(t.id) FROM tratamientos t $whereClause";
                          $totalStmt = $db->prepare($totalQuery);
                          $totalStmt->execute($params);
                          $totalRecords = $totalStmt->fetchColumn();
                          $totalPages = ceil($totalRecords / PROTOCOLS_PER_PAGE);

                          $offset = ($page - 1) * PROTOCOLS_PER_PAGE;

                          $exerciseCountSubquery = "(SELECT COUNT(te.id) FROM tratamiento_ejercicios te WHERE te.tratamiento_id = t.id)";

                          // --- ★ CORRECCIÓN 2 (Botones) ---
                          // 3. Quitar 'exercise_count' del 'match'
                          $orderByColumn = match ($sort) {
                              'title' => 'LOWER(t.title)',
                              'creator_surname' => 'LOWER(c.apellido)',
                              'id' => 't.id',
                              'created_at' => 't.created_at',
                              default => 't.created_at',
                          };
                          // --- ★ FIN CORRECCIÓN 2 ---


                          // --- ★★★ INICIO CORRECCIÓN MYSQL ★★★ ---
                          // Se usa CONCAT() en lugar de ||
                          // Se usa SEPARATOR ', ' dentro de GROUP_CONCAT
                          $dataQuery = "
                              SELECT
                                  t.id, t.title, t.creator_fisio_id, t.created_at, -- <-- ★ TAREA 1: Añadido t.created_at
                                  c.nombre as creator_name, c.apellido as creator_surname,
                                  $exerciseCountSubquery as exercise_count,
                                  (SELECT v.filename FROM tratamiento_ejercicios te JOIN ejercicios e ON te.ejercicio_id = e.id LEFT JOIN videos v ON e.id_video = v.id WHERE te.tratamiento_id = t.id ORDER BY te.id LIMIT 1) as first_video_filename,
                                  (SELECT i.filename FROM tratamiento_ejercicios te JOIN ejercicios e ON te.ejercicio_id = e.id LEFT JOIN images i ON e.id_image = i.id WHERE te.tratamiento_id = t.id ORDER BY te.id LIMIT 1) as first_image_filename,
                                  (SELECT GROUP_CONCAT(tfa.fisio_id)
                                   FROM tratamiento_fisios_asignados tfa
                                   WHERE tfa.tratamiento_id = t.id
                                  ) as collaborator_ids,
                                  (SELECT GROUP_CONCAT(CONCAT(colab.nombre, ' ', colab.apellido) SEPARATOR ', ')
                                   FROM tratamiento_fisios_asignados tfa
                                   JOIN cuentas colab ON tfa.fisio_id = colab.id
                                   WHERE tfa.tratamiento_id = t.id AND tfa.fisio_id != t.creator_fisio_id
                                  ) as collaborators
                              FROM tratamientos t
                              LEFT JOIN cuentas c ON t.creator_fisio_id = c.id /* LEFT JOIN es más seguro si creator_fisio_id pudiera ser NULL */
                              $whereClause
                              ORDER BY $orderByColumn $order
                              LIMIT :limit OFFSET :offset";
                          // --- ★★★ FIN CORRECCIÓN MYSQL ★★★ ---

                          $dataStmt = $db->prepare($dataQuery);
                          foreach ($params as $key => &$val) $dataStmt->bindParam($key, $val);
                          $dataStmt->bindValue(':limit', PROTOCOLS_PER_PAGE, PDO::PARAM_INT);
                          $dataStmt->bindValue(':offset', $offset, PDO::PARAM_INT);
                          $dataStmt->execute();
                          $protocols = $dataStmt->fetchAll(PDO::FETCH_ASSOC);

                          // Add default creator if missing (due to LEFT JOIN or NULL creator_fisio_id)
                          foreach($protocols as &$p) {
                              if (empty($p['creator_name'])) {
                                  $p['creator_name'] = 'Sistema';
                                  $p['creator_surname'] = '';
                              }
                              if ($p['collaborator_ids'] === null) {
                                 $p['collaborator_ids'] = ''; // Asegurar string vacío
                              }
                              // **NUEVO**: Asegurar que collaborators sea string vacío si es NULL
                              if ($p['collaborators'] === null) {
                                 $p['collaborators'] = '';
                              }
                          }

                          echo json_encode(['status' => 'success', 'protocols' => $protocols, 'pagination' => ['currentPage' => $page, 'totalPages' => $totalPages, 'currentSort' => $sort, 'currentOrder' => $order]]);
                          break;

            case 'check_protocol_usage':
                 $id = (int)$_GET['id'];
                 $stmt = $db->prepare("SELECT c.nombre, c.apellido FROM tratamientos t JOIN cuentas c ON t.paciente_id = c.id WHERE t.protocolo_origen_id = :id AND t.is_protocol = 0 AND t.status IN ('En curs', 'Programat')");
                 $stmt->execute([':id' => $id]);
                 $usage = $stmt->fetchAll(PDO::FETCH_ASSOC);
                 $usage_list = array_map(function($u) { return "Tractament de " . $u['nombre'] . " " . $u['apellido']; }, $usage);
                 echo json_encode(['is_usable_for_action' => (count($usage) === 0), 'usage' => $usage_list]);
                 break;

                 case 'personal_archive':
                                 if (!in_array($user_rol, ['superadmin', 'fisio'])) { throw new Exception('Accés denegat.'); }
                                 // --- CORRECCIÓN MYSQL ---
                                 $stmt = $db->prepare("INSERT IGNORE INTO archivado_personal (fisio_id, item_id, item_type) VALUES (?, ?, 'protocol')");
                                 // --- FIN CORRECCIÓN ---
                                 $stmt->execute([$user_id, (int)$_POST['id']]);
                                 echo json_encode(['status' => 'success', 'message' => 'Protocol arxivat correctament a la teua vista.']);
                                 break;

            case 'get_protocol_details':
                $id = (int)$_GET['id'];
                 // **MODIFICADO**: Añadido 't.creator_fisio_id' y t.created_at
                $protocolStmt = $db->prepare("
                    SELECT t.id, t.title, t.anamnesis, t.diagnostico, t.creator_fisio_id, t.created_at, c.nombre as creator_name, c.apellido as creator_surname
                    FROM tratamientos t
                    LEFT JOIN cuentas c ON t.creator_fisio_id = c.id /* LEFT JOIN */
                    WHERE t.id = ? AND t.is_protocol = 1
                ");
                $protocolStmt->execute([$id]);
                $protocol = $protocolStmt->fetch(PDO::FETCH_ASSOC);
                if (!$protocol) { throw new Exception("Protocol no trobat."); }
                // Default creator if null
                if (empty($protocol['creator_name'])) {
                    $protocol['creator_name'] = 'Sistema';
                    $protocol['creator_surname'] = '';
                }

                // **NUEVO**: Obtener fisios colaboradores
                $stmtFisios = $db->prepare("SELECT fisio_id FROM tratamiento_fisios_asignados WHERE tratamiento_id = ?");
                $stmtFisios->execute([$id]);
                $protocol['assigned_fisios'] = $stmtFisios->fetchAll(PDO::FETCH_COLUMN);
                // --- Fin nuevo ---

                $exercisesStmt = $db->prepare("
                    SELECT e.*, v.filename as video_filename, i.filename as image_filename, te.frecuencia, te.series, te.repetitions, te.rest_time, te.notes as pauta_notes
                    FROM tratamiento_ejercicios te
                    JOIN ejercicios e ON te.ejercicio_id = e.id
                    LEFT JOIN videos v ON e.id_video = v.id
                    LEFT JOIN images i ON e.id_image = i.id
                    WHERE te.tratamiento_id = ? ORDER BY te.id");
                $exercisesStmt->execute([$id]);
                $protocol['assigned_exercises'] = $exercisesStmt->fetchAll(PDO::FETCH_ASSOC); // Changed to FETCH_ASSOC
                echo json_encode(['status' => 'success', 'protocol' => $protocol]);
                break;

            case 'get_fisios_and_pacientes':
                 $fisiosStmt = $db->query("SELECT id, nombre, apellido FROM cuentas WHERE rol IN ('fisio', 'superadmin') AND is_archived = 0 ORDER BY apellido, nombre");
                 $pacientesStmt = $db->query("SELECT id, nombre, apellido FROM cuentas WHERE rol = 'paciente' AND is_archived = 0 ORDER BY apellido, nombre");
                 echo json_encode(['status' => 'success', 'fisios' => $fisiosStmt->fetchAll(PDO::FETCH_ASSOC), 'pacientes' => $pacientesStmt->fetchAll(PDO::FETCH_ASSOC)]); // Added FETCH_ASSOC
                 break;

            // --- INICIO MODIFICACIÓN: Lógica de 'assign_to_patient' eliminada ---
            /*
            case 'assign_to_patient':
                // ... tota la lògica anterior ha sigut eliminada ...
                break;
            */
            // --- FIN MODIFICACIÓN ---

            // **INICIO MODIFICACIÓN**: Lógica 'create' y 'update' unificada para colaboradores
            case 'create_protocol':
            case 'update_protocol':
                 $db->beginTransaction();
                $assignedExercises = json_decode($_POST['assigned_exercises'], true) ?? [];

                if (empty($_POST['title'])) { throw new Exception('El títol del protocol és obligatori.'); }
                if (empty($assignedExercises)) {
                    throw new Exception('És obligatori seleccionar almenys un exercici per al protocol.');
                }

                $assignedFisios = $_POST['assigned_fisios'] ?? []; // Obtener colaboradores del POST

                 // Asegúrate que creator_fisio_id existe
                if ($action === 'create_protocol') {
                  $stmt = $db->prepare("INSERT INTO tratamientos (creator_fisio_id, is_protocol, title, anamnesis, diagnostico, created_at) VALUES (?, 1, ?, ?, ?, NOW())");
                  $stmt->execute([$user_id, $_POST['title'], $_POST['anamnesis'], $_POST['diagnostico']]);
                    $protocolId = $db->lastInsertId();
                    if (!$protocolId) { $db->rollBack(); throw new Exception("Error al crear el nuevo protocolo."); }

                    // **NUEVO**: Insertar colaboradores (incluyendo al creador)
                    if (!in_array($user_id, $assignedFisios)) { $assignedFisios[] = $user_id; }
                    $fisioStmt = $db->prepare("INSERT INTO tratamiento_fisios_asignados (tratamiento_id, fisio_id) VALUES (?, ?)");
                    foreach($assignedFisios as $fisioId) { if(!empty($fisioId)) { $fisioStmt->execute([$protocolId, $fisioId]); } }
                    // --- Fin nuevo ---

                } else { // update_protocol
                    $protocolId = (int)$_POST['id'];

                    // **NUEVO**: Comprobación de permisos (Creador, Colaborador o Superadmin)
                    if ($user_rol === 'fisio') {
                        $permStmt = $db->prepare("
                            SELECT 1 FROM tratamientos t
                            LEFT JOIN tratamiento_fisios_asignados tfa ON t.id = tfa.tratamiento_id
                            WHERE t.id = ? AND t.is_protocol = 1 AND (t.creator_fisio_id = ? OR tfa.fisio_id = ?)
                            LIMIT 1
                        ");
                        $permStmt->execute([$protocolId, $user_id, $user_id]);
                        if (!$permStmt->fetch()) {
                            $db->rollBack();
                            throw new Exception("No tens permís per a editar aquest protocol.");
                        }
                    }
                    // --- Fin comprobación ---

                    $query = "UPDATE tratamientos SET title=?, anamnesis=?, diagnostico=? WHERE id=? AND is_protocol=1";
                    $params = [$_POST['title'], $_POST['anamnesis'], $_POST['diagnostico'], $protocolId];
                    $stmt = $db->prepare($query);
                    $stmt->execute($params);

                    // **NUEVO**: Actualizar colaboradores (Solo si es Creador o Superadmin)
                    $creatorStmt = $db->prepare("SELECT creator_fisio_id FROM tratamientos WHERE id = ?");
                    $creatorStmt->execute([$protocolId]);
                    $creator_id = $creatorStmt->fetchColumn();

                    if ($user_rol === 'superadmin' || $user_id == $creator_id) {
                        $db->prepare("DELETE FROM tratamiento_fisios_asignados WHERE tratamiento_id = ?")->execute([$protocolId]);

                        // Asegurarse de que el creador original sigue asignado
                        if ($creator_id && !in_array($creator_id, $assignedFisios)) {
                            $assignedFisios[] = $creator_id;
                        }

                        $fisioStmt = $db->prepare("INSERT INTO tratamiento_fisios_asignados (tratamiento_id, fisio_id) VALUES (?, ?)");
                        foreach(array_unique($assignedFisios) as $fisioId) { // Usar array_unique
                            if(!empty($fisioId)) $fisioStmt->execute([$protocolId, $fisioId]);
                        }
                    }
                    // --- Fin nuevo ---
                }

                // Lógica de ejercicios (sin cambios)
                $db->prepare("DELETE FROM tratamiento_ejercicios WHERE tratamiento_id = ?")->execute([$protocolId]);

                $exerStmt = $db->prepare("INSERT INTO tratamiento_ejercicios (tratamiento_id, ejercicio_id, frecuencia, series, repetitions, rest_time, notes) VALUES (?, ?, ?, ?, ?, ?, ?)");
                foreach($assignedExercises as $ex) {
                    if (!isset($ex['id'], $ex['frecuencia'], $ex['series'], $ex['repetitions'], $ex['rest_time'], $ex['notes'])) {
                         $db->rollBack();
                         throw new Exception('Dades d\'exercici invàlides rebudes.');
                     }
                    $exerStmt->execute([$protocolId, $ex['id'], $ex['frecuencia'], $ex['series'], $ex['repetitions'], $ex['rest_time'], $ex['notes']]);
                }

                $db->commit();
                // --- MODIFICACIÓN 1 (FLASH) ---
                echo json_encode(['status' => 'success', 'message' => 'Protocol guardat correctament.', 'saved_protocol_id' => $protocolId]);
                break;
            // **FIN MODIFICACIÓN**

            case 'clone_protocol':
                $originalProtocolId = (int)$_POST['original_protocol_id'];
                $newTitle = trim($_POST['title']);
                 if (empty($newTitle)) { throw new Exception('El nou títol no pot estar buit.'); }

                $db->beginTransaction();

                // --- ★ TAREA 3 (Clonación Lógica) ---
                // 1. Pedimos la fecha de creación original
                $stmtOrig = $db->prepare("SELECT *, created_at as original_created_at FROM tratamientos WHERE id = ? AND is_protocol = 1");
                $stmtOrig->execute([$originalProtocolId]);
                $originalProtocol = $stmtOrig->fetch(PDO::FETCH_ASSOC); // Added FETCH_ASSOC

                if (!$originalProtocol) {
                    throw new Exception("El protocol original no existeix.");
                }

                 // 2. Añadimos 'created_at' al INSERT y usamos DATE_ADD
                 $stmtNew = $db->prepare("
                    INSERT INTO tratamientos (creator_fisio_id, is_protocol, title, anamnesis, diagnostico, created_at)
                    VALUES (?, 1, ?, ?, ?, DATE_ADD(?, INTERVAL 1 SECOND))
                ");
                 $stmtNew->execute([
                    $user_id,
                    $newTitle,
                    $originalProtocol['anamnesis'],
                    $originalProtocol['diagnostico'],
                    $originalProtocol['original_created_at'] // <-- 3. Pasamos la fecha original
                ]);
                $newProtocolId = $db->lastInsertId();
                 if (!$newProtocolId) { $db->rollBack(); throw new Exception("Error al clonar el protocolo."); }
                 // --- ★ FIN TAREA 3 ---

                // **MODIFICADO**: Clonar también los colaboradores
                // 1. Obtener colaboradores originales
                $stmtColabOrig = $db->prepare("SELECT fisio_id FROM tratamiento_fisios_asignados WHERE tratamiento_id = ?");
                $stmtColabOrig->execute([$originalProtocolId]);
                $originalColabIds = $stmtColabOrig->fetchAll(PDO::FETCH_COLUMN);

                // 2. Asignar al nuevo protocolo (asegurando que el nuevo creador esté)
                if (!in_array($user_id, $originalColabIds)) {
                    $originalColabIds[] = $user_id;
                }
                $stmtColabNew = $db->prepare("INSERT INTO tratamiento_fisios_asignados (tratamiento_id, fisio_id) VALUES (?, ?)");
                foreach (array_unique($originalColabIds) as $fisioId) {
                    if(!empty($fisioId)) $stmtColabNew->execute([$newProtocolId, $fisioId]);
                }
                // --- Fin modificación ---

                $stmtExerOrig = $db->prepare("SELECT * FROM tratamiento_ejercicios WHERE tratamiento_id = ? ORDER BY id");
                $stmtExerOrig->execute([$originalProtocolId]);
                $originalExercises = $stmtExerOrig->fetchAll(PDO::FETCH_ASSOC); // Added FETCH_ASSOC

                if (!empty($originalExercises)) {
                    $stmtExerNew = $db->prepare("INSERT INTO tratamiento_ejercicios (tratamiento_id, ejercicio_id, frecuencia, series, repetitions, rest_time, notes) VALUES (?, ?, ?, ?, ?, ?, ?)");
                    foreach ($originalExercises as $ex) {
                        $stmtExerNew->execute([$newProtocolId, $ex['ejercicio_id'], $ex['frecuencia'], $ex['series'], $ex['repetitions'], $ex['rest_time'], $ex['notes']]);
                    }
                }

                $db->commit();
                // --- MODIFICACIÓN 2 (FLASH) ---
                echo json_encode(['status' => 'success', 'message' => 'Protocol clonat correctament.', 'new_protocol_id' => $newProtocolId]);
                break;

                case 'delete_protocol':
                                $id = (int)$_POST['id'];

                                // ¡AQUÍ LA MODIFICACIÓN!
                                // Solo comprobamos el uso SI NO ERES superadmin.
                                if ($user_rol !== 'superadmin') {
                                    // Check usage using the correct column
                                    $stmtUsageCheck = $db->prepare("SELECT COUNT(id) FROM tratamientos WHERE protocolo_origen_id = :id AND status IN ('En curs', 'Programat')");
                                    $stmtUsageCheck->execute([':id' => $id]);
                                     if ($stmtUsageCheck->fetchColumn() > 0) {
                                         throw new Exception("El protocol està en ús en un tractament actiu o programat i no es pot eliminar.");
                                     }
                                }
                                // FIN DE LA MODIFICACIÓN

                                // El resto de tu lógica de permisos (comprobar si es creador) está bien
                                $query = "DELETE FROM tratamientos WHERE id = ? AND is_protocol = 1";
                                $params = [$id];

                                if ($user_rol === 'fisio') {
                                    // Comprobar si es creador
                                    $stmtCheckCreator = $db->prepare("SELECT 1 FROM tratamientos WHERE id = ? AND creator_fisio_id = ?");
                                    $stmtCheckCreator->execute([$id, $user_id]);
                                    if (!$stmtCheckCreator->fetch()) {
                                         throw new Exception('No tens permís per a eliminar este protocol (només el creador o superadmin poden).');
                                    }
                                    $query .= " AND creator_fisio_id = ?";
                                    $params[] = $user_id;
                                }

                                $stmt = $db->prepare($query);
                                $stmt->execute($params);

                                // Comprobación de si se borró algo
                                if ($stmt->rowCount() === 0) {
                                    if ($user_rol === 'fisio') {
                                        // Si eres fisio y no borró nada, o no existía o no tenías permiso (aunque ya lo comprobamos)
                                        throw new Exception('No s\'ha trobat el protocol o no tens permís.');
                                    } else {
                                        // Si eres superadmin y no borró nada, es que no existía
                                         throw new Exception('No s\'ha trobat el protocol per a eliminar.');
                                    }
                                }

                                // Borrar dependencias (esto está bien como estaba)
                                $db->prepare("DELETE FROM tratamiento_ejercicios WHERE tratamiento_id = ?")->execute([$id]);
                                $db->prepare("DELETE FROM tratamiento_fisios_asignados WHERE tratamiento_id = ?")->execute([$id]);

                                echo json_encode(['status' => 'success', 'message' => 'Protocol eliminat.']);
                                break;
        }
    } catch (Exception $e) {
        if (isset($db) && $db->inTransaction()) $db->rollBack();
        http_response_code(400);
        // Provide more detailed error in log for debugging
        error_log("Error en protocols_ajax.php: " . $e->getMessage() . "\nTrace: " . $e->getTraceAsString());
        // Return generic message to user
        echo json_encode(['status' => 'error', 'message' => $e->getMessage()]); // **MODIFICADO**: Devolver el mensaje de error real
    }
    exit;
}

$page_title = "Biblioteca de Protocols";
include 'partials/header.php';
?>

<style>
    .sortable-header {
        cursor: pointer;
        user-select: none;
    }
    .sortable-header .bi-arrow-down-up {
        opacity: 0.4;
    }
    .protocol-exercise-library-thumb { width: 60px; height: 34px; object-fit: cover; border-radius: 0.25rem; }
    .view-ex-thumb { width: 100px; height: 60px; object-fit: cover; border-radius: 0.25rem; background-color: #343a40; }
    .list-thumbnail {
        width: 120px;
        height: 67px;
        object-fit: cover;
        border-radius: 0.25rem;
        background-color: #e9ecef;
    }
    .no-media-placeholder { background-color: #e9ecef; color: #6c757d; display: flex; flex-direction: column; align-items: center; justify-content: center; }
    .list-thumbnail.no-media-placeholder { background-color: #e9ecef; }
    .drag-handle { cursor: grab; }
    .dropdown-item i.bi { margin-right: 0.5rem; }
    .dropdown .btn.dropdown-toggle:hover {
        color: #FFF !important;
    }

    /* --- INICIO DE LA CORRECCIÓN Z-INDEX --- */
    .protocol-card:hover {
        position: relative;
        z-index: 10;
    }
    /* --- FIN DE LA CORRECCIÓN Z-INDEX --- */

    /* --- ★ CORRECCIÓN 2 (Z-Index Dropdown) --- */
    /* Añadido para que el dropdown "salga" del contenedor .table-responsive */
    td .dropdown, .card-footer .dropdown {
        position: static;
    }
    /* --- ★ FIN CORRECCIÓN 2 --- */


    /* **NUEVO**: Estilo para items deshabilitados del dropdown */
    .dropdown-item.disabled, .dropdown-item:disabled {
        color: #adb5bd;
        pointer-events: none;
        background-color: transparent;
    }
    /* **NUEVO**: Estilo para celda de colaboradores (copiado de treatments.php) */
    .table td.wrap-text {
        white-space: normal;
        word-wrap: break-word;
        max-width: 150px; /* Adjust as needed */
        font-size: 0.85rem; /* Slightly smaller font for collaborators */
        line-height: 1.3;
    }

    /* ★★★ INICIO DE LA MODIFICACIÓN PARA MÓVIL ★★★ */
    @media (max-width: 767.98px) {
        /* Ocultamos los botones de cambiar vista (Grid/List) en móvil */
        .toggle-view-btn {
            display: none !important;
        }
    }
    /* ★★★ FIN DE LA MODIFICACIÓN PARA MÓVIL ★★★ */
</style>


<main class="main-content container mt-4" style="max-width: 1420px;">
    <!-- ★★★ MODIFICACIÓN: Añadida clase 'protocols-header-bar' para CSS móvil ★★★ -->
    <div class="d-flex justify-content-between align-items-center mb-3 protocols-header-bar">
        <h4><i class="bi bi-clipboard2-pulse me-2"></i> Biblioteca de Protocols</h4>
        <button class="btn btn-primary" id="addProtocolBtn"><i class="bi bi-plus-circle-fill me-2"></i> Nou Protocol</button>
    </div>

    <div class="card shadow-sm">
        <div class="card-body">

            <!-- ★★★ INICIO: Bloque de Controles Responsive (Móvil) ★★★ -->
            <div class="row g-2 mb-4">

                <!-- Columna 1 (Móvil): Switch y Dropdowns -->
                <div class="col-12 col-lg-6">
                    <div class="d-flex align-items-center h-100 flex-wrap gap-2">
                        <?php if (in_array($user_rol, ['superadmin', 'fisio'])): ?>
                        <div class="form-check form-switch text-nowrap">
                            <input class="form-check-input" type="checkbox" role="switch" id="filterMyProtocols">
                            <label class="form-check-label" for="filterMyProtocols">Només els meus</label>
                        </div>
                        <?php endif; ?>

                        <div class="flex-grow-1 mobile-filter-flex-grow" style="min-width: 180px; max-width: 220px;">
                            <select id="categoryFilter" class="form-select">
                                <option value="">Totes les Categories</option>
                            </select>
                        </div>

                        <div class="flex-grow-1 mobile-filter-flex-grow" style="min-width: 180px; max-width: 220px;">
                             <select id="creatorFilter" class="form-select"></select>
                        </div>
                    </div>
                </div>

                <!-- Columna 2 (Móvil): Buscador y Botones -->
                <div class="col-12 col-lg-6">
                    <div class="d-flex align-items-center justify-content-start justify-content-lg-end flex-wrap gap-2">

                        <div class="input-group mobile-filter-full-width" style="max-width: 300px; position: relative;">
                            <span class="input-group-text"><i class="bi bi-search"></i></span>
                            <input type="text" id="protocolSearchInput" class="form-control" placeholder="Cercar per títol, patologia...">
                             <button class="clear-search-btn" type="button" id="clearProtocolSearchBtn"><i class="bi bi-x"></i></button>
                        </div>

                        <div class="btn-group mobile-filter-btn-group" role="group">
                            <button type="button" class="btn btn-outline-secondary toggle-view-btn active" id="gridViewBtn" title="Vista en Quadrícula"><i class="bi bi-grid-fill"></i></button>
                            <button type="button" class="btn btn-outline-secondary toggle-view-btn" id="listViewBtn" title="Vista en Llista"><i class="bi bi-list"></i></button>
                        </div>

                        <div class="btn-group mobile-filter-btn-group" id="sort-buttons-group">
                            <button class="btn btn-outline-secondary sort-btn" data-sort="created_at" data-order="DESC" title="Ordenar per Data de Creació">
                                <i class="bi bi-calendar3"></i>
                            </button>
                            <button class="btn btn-outline-secondary sort-btn" data-sort="title" data-order="ASC" title="Ordenar per Títol">
                                <i class="bi bi-sort-alpha-down"></i>
                            </button>
                        </div>
                    </div>
                </div>
            </div>
            <!-- ★★★ FIN: Bloque de Controles Responsive ★★★ -->


            <div id="protocol-library-container" class="row g-4"></div>
            <div id="pagination-container" class="mt-4"></div>
        </div>
    </div>
</main>

<div class="modal fade" id="protocolModal" tabindex="-1">
    <div class="modal-dialog modal-xl">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="protocolModalLabel">Nou Protocol</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <form id="protocolForm">
                    <input type="hidden" name="id">
                    <div class="card card-body shadow-sm mb-3">
                        <div class="row">
                            <div class="col-md-5 mb-3">
                                <label class="form-label">Títol del Protocol <span class="text-danger">*</span></label>
                                <input type="text" name="title" class="form-control" required>
                            </div>
                            <div class="col-md-7 mb-3">
                                <label class="form-label">Fisios Col·laboradors</label>
                                <select name="assigned_fisios[]" id="protocol_assigned_fisios_select" multiple></select>
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">Guia d'Anamnesi / Punts Clau</label>
                                <textarea name="anamnesis" class="form-control" rows="2" placeholder="Preguntar per: tipus de dolor, historial previ..."></textarea>
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">Diagnòstic Típic / Indicacions</label>
                                <textarea name="diagnostico" class="form-control" rows="2" placeholder="Indicat per a lumbàlgia mecànica inespecífica..."></textarea>
                            </div>
                        </div>
                        </div>

                    <div class="row">
                        <div class="col-md-5">
                            <div class="card h-100 shadow-sm">
                                <div class="card-header">
                                    <h6><i class="bi bi-person-arms-up me-2"></i>Biblioteca d'Exercicis</h6>
                                </div>
                                <div class="card-body p-2">
                                    <div class="px-2 mb-2">
                                        <div class="form-check form-switch mb-2">
                                            <input class="form-check-input" type="checkbox" role="switch" id="filterMyExercisesModalProtocol">
                                            <label class="form-check-label" for="filterMyExercisesModalProtocol">Només els meus</label>
                                        </div>
                                    </div>

                                    <div class="px-2 mb-2">
                                        <div class="input-group input-group-sm" style="position: relative;">
                                            <input type="text" id="modalExerciseSearch" class="form-control" placeholder="Cercar per títol...">
                                            <button class="clear-search-btn" type="button" id="clearModalSearchBtnProtocol" style="display: none;"><i class="bi bi-x"></i></button>
                                        </div>
                                    </div>

                                    <div id="exercise-library-visual-container" class="list-group list-group-flush protocol-exercise-library border-top"></div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-7">
                            <div class="card h-100 shadow-sm d-flex flex-column">
                                 <div class="card-header bg-primary text-white flex-shrink-0">
                                    <h6><i class="bi bi-clipboard2-check-fill me-2"></i>Exercicis del Protocol</h6>
                                </div>
                                <div id="assigned-exercises-visual-container" class="card-body p-2 flex-grow-1" style="overflow-y: auto;">
                                    <div class="assigned-placeholder-protocol d-flex align-items-center justify-content-center h-100">
                                        <div class="text-center text-muted">
                                            <i class="bi bi-card-list fs-1"></i>
                                            <p class="mt-2">Fes clic al botó '+' en un exercici per afegir-lo al protocol.</p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <input type="hidden" name="assigned_exercises" id="assignedExercisesInput">
                    <div class="modal-footer mt-3">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel·lar</button>
                        <button type="submit" class="btn btn-primary">Guardar Protocol</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="viewProtocolModal" tabindex="-1">
    <div class="modal-dialog modal-lg modal-dialog-scrollable">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="viewProtocolModalLabel"></h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body" id="viewProtocolModalBody"></div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Tancar</button>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="assignProtocolModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="assignProtocolModalLabel">Assignar Protocol</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <form id="assignProtocolForm">
                    <input type="hidden" name="protocol_id">
                    <p>Es crearà un nou tractament actiu basat en el protocol <strong id="assignProtocolName"></strong>.</p>
                    <div class="mb-3">
                        <label for="pacienteSelect" class="form-label">Selecciona el Pacient</label>
                        <select id="pacienteSelect" name="paciente_id" class="form-select" required></select>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                        <button type="submit" class="btn btn-primary">Confirmar i Crear Tractament</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="cloneProtocolModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header"><h5 class="modal-title" id="cloneProtocolModalLabel">Clonar Protocol</h5><button type="button" class="btn-close" data-bs-dismiss="modal"></button></div>
            <div class="modal-body">
                <form id="cloneProtocolForm">
                    <input type="hidden" name="original_protocol_id">
                    <p>Es crearà una còpia d'aquest protocol. Per favor, confirma el nou títol.</p>
                    <div class="mb-3"><label class="form-label">Nou Títol del Protocol</label><input type="text" name="title" class="form-control" required></div>
                    <div class="modal-footer"><button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel·lar</button><button type="submit" class="btn btn-primary"><i class="bi bi-copy"></i> Confirmar Clonació</button></div>
                </form>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="manageModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header"><h5 class="modal-title" id="manageModalLabel"></h5><button type="button" class="btn-close" data-bs-dismiss="modal"></button></div>
            <div class="modal-body" id="manageModalBody"></div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel·lar</button>
                <button type="button" class="btn btn-warning" id="archiveBtn">Arxivar</button>
                <button type="button" class="btn btn-danger" id="deleteBtn">Eliminar</button>
            </div>
        </div>
    </div>
</div>


<?php include 'partials/footer.php'; ?>

<script>
    const USER_VIEW_PREFERENCES = <?php echo $user_view_prefs_json; ?>;
</script>

<script>
$(document).ready(function() {
    const CURRENT_USER_ID = <?= $user_id ?>;
    const IS_SUPERADMIN = '<?= $user_rol ?>' === 'superadmin';
    const FILTER_MINE_DEFAULT = <?= $filtro_defecto ?> == 1;

    function isMobileView() {
        return window.innerWidth < 767.98;
    }

    // --- Modal Initialization ---
    let protocolModal, viewProtocolModal, assignProtocolModal, cloneProtocolModal, manageModal;
    try {
        const protocolModalEl = document.getElementById('protocolModal');
        const viewProtocolModalEl = document.getElementById('viewProtocolModal');
        const assignProtocolModalEl = document.getElementById('assignProtocolModal');
        const cloneProtocolModalEl = document.getElementById('cloneProtocolModal');
        const manageModalEl = document.getElementById('manageModal');

        protocolModal = protocolModalEl ? new bootstrap.Modal(protocolModalEl) : null;
        viewProtocolModal = viewProtocolModalEl ? new bootstrap.Modal(viewProtocolModalEl) : null;
        assignProtocolModal = assignProtocolModalEl ? new bootstrap.Modal(assignProtocolModalEl) : null;
        cloneProtocolModal = cloneProtocolModalEl ? new bootstrap.Modal(cloneProtocolModalEl) : null;
        manageModal = manageModalEl ? new bootstrap.Modal(manageModalEl) : null;
    } catch (e) {
        console.error("Error initializing Bootstrap Modals:", e);
        showToast("Error inicialitzant components de la pàgina.", "danger");
    }

    let itemToManage = { id: null, name: '' };
    // **MODIFICADO**: Añadido 'allFisios'
    let allPacientes = [], allCategories = [], allTags = [], allFisios = [];

    // --- MODIFICACIÓN JS: Eliminadas variables de TomSelect ---
    let protocolFisioTomSelect;

    // **** MODIFICAT: El viewMode ara llegeix la preferència de l'usuari ****
    const initialProtocolView = USER_VIEW_PREFERENCES['protocols'] || 'grid'; // Clau per a protocols

    // --- ★ TAREA 2 (Default Sort) ---
    // Cambiamos 'id' por 'created_at' como orden por defecto
let appState = {
    currentPage: 1,
    searchQuery: '',
    sortBy: 'created_at',
    sortOrder: 'DESC',
    creatorId: '',
    filterMine: FILTER_MINE_DEFAULT,
    viewMode: isMobileView() ? 'grid' : initialProtocolView, // <-- MODIFICADO AQUÍ: Forzar 'grid' en móvil
    categoryId: ''
};
    // --- ★ FIN TAREA 2 ---

    // --- INICIO MODIFICACIÓN: Leer filtro de URL ---
    const urlParams_pro = new URLSearchParams(window.location.search);
    if (urlParams_pro.get('filter') === 'mine') {
        appState.filterMine = true;
    }
    // --- FIN MODIFICACIÓN ---

    const assignedExercisesContainer = document.getElementById('assigned-exercises-visual-container');
    if (assignedExercisesContainer && typeof Sortable !== 'undefined') {
        new Sortable(assignedExercisesContainer, {
            animation: 150,
            handle: '.drag-handle',
            ghostClass: 'bg-light'
        });
    } else if (!assignedExercisesContainer) {
         console.warn("Element '#assigned-exercises-visual-container' not found for Sortable.");
     } else {
         console.warn("Sortable library not found.");
     }

    // **NUEVO**: Inicializar TomSelect para colaboradores del protocolo
    const fisioSelectEl = document.getElementById('protocol_assigned_fisios_select');
    if (fisioSelectEl && typeof TomSelect !== 'undefined') {
        protocolFisioTomSelect = new TomSelect(fisioSelectEl, { plugins: ['remove_button'], placeholder: 'Afig col·laboradors...' });
    } else {
         console.warn("Element '#protocol_assigned_fisios_select' or TomSelect library not found.");
     }


    // --- Helper Functions ---
    // ====================================================================
    // --- INICIO MODIFICACIÓN: Función 'escapeHtml' eliminada ---
    // (La función estaba aquí)
    // --- FIN MODIFICACIÓN ---
    // ====================================================================

    function getInitialSortIcon(currentSort, currentOrder, columnName) {
        if (currentSort === columnName) {
            return currentOrder === 'ASC' ? '<i class="bi bi-caret-up-fill ms-2"></i>' : '<i class="bi bi-caret-down-fill ms-2"></i>';
        }
        return '<i class="bi bi-arrow-down-up ms-2 text-muted opacity-50"></i>';
    }

    // --- ★ TAREA 4 (Spinner Suave) ---
    function fetchProtocols() {
        // ATENUAMOS la lista, no la borramos
        $('#protocol-library-container').css('opacity', 0.5);

        const params = {
            ajax: true, action: 'read_protocols',
            page: appState.currentPage, search: appState.searchQuery,
            sort: appState.sortBy, order: appState.sortOrder,
            creatorId: appState.creatorId, filterMine: appState.filterMine,
            categoryId: appState.categoryId // <-- ★★★ AÑADIR ESTA LÍNEA ★★★
        };

        return $.getJSON('protocols.php', params)
        .done(response => {
            $('#protocol-library-container').css('opacity', 1); // RESTAURAMOS
            if (response.status === 'success') {
                renderProtocols(response.protocols, response.pagination.currentSort, response.pagination.currentOrder);
                renderPagination(response.pagination);
                updateSortButtons(response.pagination.currentSort, response.pagination.currentOrder);
            } else {
                 $('#protocol-library-container').html('<div class="col-12"><div class="alert alert-warning text-center">No s\'han trobat protocols: ' + (response.message || 'Error') + '</div></div>');
            }
        }).fail((jqXHR, textStatus, errorThrown) => {
            console.error("AJAX Error fetching protocols: ", textStatus, errorThrown, jqXHR.responseText);
            $('#protocol-library-container').css('opacity', 1).html('<div class="col-12"><div class="alert alert-danger text-center">Error en carregar els protocols. Comprova la consola per detalls.</div></div>');
        });
    }
    // --- ★ FIN TAREA 4 ---

    function fetchDependencies() {
        $.when(
            $.getJSON('protocols.php', { ajax: true, action: 'get_fisios_and_pacientes' }),
            $.getJSON('exercises.php', { ajax: true, action: 'get_form_dependencies' })
        ).done(function(fisioPacienteRes, exerciseDepsRes) {
            if (fisioPacienteRes[0].status === 'success') {
                // **MODIFICADO**: Guardar 'allFisios'
                allFisios = fisioPacienteRes[0].fisios;
                allPacientes = fisioPacienteRes[0].pacientes;

                // Poblar filtro de creador
                const creatorSelect = $('#creatorFilter');
                creatorSelect.html('<option value="">Tots els Fisios</option>');
                allFisios.forEach(f => { creatorSelect.append(new Option(`${f.apellido}, ${f.nombre}`, f.id)); });

                // **NUEVO**: Poblar TomSelect de colaboradores en el modal
                if(protocolFisioTomSelect) {
                    protocolFisioTomSelect.clearOptions();
                    // --- INICIO CORRECCIÓN 2: Filtrar fisio actual ---
                    const filteredFisios = allFisios.filter(f => f.id != CURRENT_USER_ID);
                    protocolFisioTomSelect.addOptions(filteredFisios.map(f => ({value: f.id, text: `${f.apellido}, ${f.nombre}`})));
                    // --- FIN CORRECCIÓN 2 ---
                }

            } else {
                 console.error("Failed to load fisios/pacientes:", fisioPacienteRes[0].message);
                 showToast("Error carregant llistes d'usuaris.", "danger");
             }

            if (exerciseDepsRes[0].status === 'success') {
                 allCategories = exerciseDepsRes[0].categories;
                 allTags = exerciseDepsRes[0].tags;

                 // --- MODIFICACIÓN JS: Eliminada la llamada a initializeModalFilters() ---
                 // initializeModalFilters();

                 // ★★★ AÑADIR ESTE BLOQUE PARA POBLAR EL FILTRO ★★★
                 const mainCategoryFilter = $('#categoryFilter');
                 mainCategoryFilter.html('<option value="">Totes les Categories</option>');
                 // Filtrar y ordenar padres
                 const parents = allCategories.filter(c => !c.parent_id);
                 parents.sort((a, b) => a.name.localeCompare(b.name));

                 parents.forEach(p => {
                    mainCategoryFilter.append(new Option(p.name, p.id)); // Añadir padre
                    // Encontrar y ordenar hijos
                    const children = allCategories.filter(c => c.parent_id == p.id);
                    children.sort((a, b) => a.name.localeCompare(b.name));
                    children.forEach(c => {
                        mainCategoryFilter.append(new Option(`↳ ${c.name}`, c.id)); // Añadir hijo
                    });
                 });
                 // ★★★ FIN ★★★

             } else {
                 console.error("Failed to load categories/tags:", exerciseDepsRes[0].message);
                 showToast("Error carregant categories/etiquetes.", "danger");
             }
        }).fail(function(jqXHR, textStatus, errorThrown) {
             console.error("Error fetching dependencies:", textStatus, errorThrown);
             showToast("Error crític al carregar filtres i usuaris.", "danger");
         });
    }


    // --- UI Rendering ---
    // --- ★ TAREA 2 (Honest UI) ---
    function updateSortButtons(currentSort, currentOrder) {
        $('#sort-buttons-group .sort-btn').removeClass('active');
        // Solo ilumina si estamos en Grid Y hay un botón que coincide
        if (appState.viewMode === 'grid') {
             // --- ★ CORRECCIÓN 1 (Botones) ---
             // Cambiamos 'id' por 'created_at' para que el botón de calendario se ilumine
             const buttonSort = currentSort === 'id' ? 'created_at' : currentSort;
             const targetButton = $(`#sort-buttons-group .sort-btn[data-sort="${buttonSort}"]`);
             // --- ★ FIN CORRECCIÓN 1 ---

             if (targetButton.length > 0) {
                 targetButton.addClass('active');
             }
        }
        // Si estamos en 'list' o no hay match (ej. 'created_at'), no se activa nada
    }
    // --- ★ FIN TAREA 2 ---

    // **INICIO MODIFICACIÓN**: Mostrar colaboradores en Grid y List
    function renderProtocols(protocols, currentSort, currentOrder) {
        const container = $('#protocol-library-container').empty();
        if (!protocols || protocols.length === 0) { // Added null check
            container.html('<div class="col-12"><div class="alert alert-secondary text-center">No s\'han trobat protocols que coincideixin amb els filtres.</div></div>');
            return;
        }
         if (appState.viewMode === 'grid') {
            container.removeClass('table-responsive').addClass('row g-4');
            protocols.forEach(p => {
                let thumbnailHtml = '';
                if (p.first_video_filename) {
                    if (p.first_video_filename.startsWith('http')) {
                        const ytMatch = p.first_video_filename.match(/youtube\.com\/embed\/([a-zA-Z0-9\-_]+)/);
                        thumbnailHtml = `<img src="${ytMatch ? `https://img.youtube.com/vi/${ytMatch[1]}/mqdefault.jpg` : 'https://placehold.co/120x67/e9ecef/6c757d?text=URL'}" alt="Miniatura">`;
                    } else {
                        thumbnailHtml = `<video src="videos/${p.first_video_filename}#t=0.5" preload="metadata"></video>`;
                    }
                } else if (p.first_image_filename) {
                    thumbnailHtml = `<img src="images/${p.first_image_filename}" alt="Miniatura">`;
                } else {
                    thumbnailHtml = `<div class="w-100 h-100 no-media-placeholder d-flex align-items-center justify-content-center">
                                        <div class="text-center">
                                            <i class="bi bi-camera-video-off fs-1"></i>
                                            <p class="mb-0 mt-2 small">Sense medis associats</p>
                                        </div>
                                    </div>`;
                }
                const imageContainer = `<div class="card-img-top ratio ratio-16x9 view-protocol-btn bg-dark" data-id="${p.id}" style="cursor:pointer;">${thumbnailHtml}</div>`; // Added bg-dark and cursor
                const buttonsHtml = renderActionButtons(p);

                // **NUEVO**: HTML para colaboradores en Grid
                const collaboratorsHtml_grid = p.collaborators ? `<p class="card-text small text-muted">Col·laboren: ${escapeHtml(p.collaborators)}</p>` : '';

                container.append(`<div class="col-md-6 col-lg-4 col-xl-3">
                    <div class="card h-100 shadow-sm protocol-card">
                        ${imageContainer}
                        <div class="card-body">
                            <h5 class="card-title">${escapeHtml(p.title || 'Sense Títol')}</h5>
                            <p class="card-text small text-muted">Creat per: ${escapeHtml(p.creator_name || 'N/A')} ${escapeHtml(p.creator_surname || '')}</p>
                            ${collaboratorsHtml_grid}
                        </div>
                        <div class="card-footer d-flex justify-content-between align-items-center">
                            <span class="badge bg-secondary">${p.exercise_count || 0} exercicis</span>
                            ${buttonsHtml}
                        </div>
                    </div>
                </div>`);
            });
        } else { // List View
            container.removeClass('row g-4').addClass('table-responsive');
            // --- ★ TAREA 1 (Nueva Columna) / CORRECCIÓN 2 (Botones) ---
            let tableHtml = `<table class="table table-hover align-middle protocol-list-view">
                <thead>
                    <tr>
                        <th style="width: 150px;">Miniatura</th>
                        <th class="sortable-header" data-sort="title">Títol del Protocol${getInitialSortIcon(currentSort, currentOrder, 'title')}</th>
                        <th class="sortable-header" data-sort="creator_surname" style="width: 15%;">Creat per${getInitialSortIcon(currentSort, currentOrder, 'creator_surname')}</th>
                        <th style="width: 20%;">Col·laboradors</th>
                        <th class="sortable-header" data-sort="created_at" style="width: 10%;">Data${getInitialSortIcon(currentSort, currentOrder, 'created_at')}</th>
                        <th class="text-center" style="width: 10%;">Nº Exercicis</th>
                        <th class="text-end" style="width: 10%;">Accions</th>
                    </tr>
                </thead>
                <tbody>`;
            // --- ★ FIN TAREAS ---
            protocols.forEach(p => {
                let thumbnailHtml;
                if (p.first_video_filename) {
                    const isEmbed = p.first_video_filename.startsWith('http');
                    const ytMatch = isEmbed ? p.first_video_filename.match(/youtube\.com\/embed\/([a-zA-Z0-9\-_]+)/) : null;
                    thumbnailHtml = isEmbed ? `<img src="${ytMatch ? `https://img.youtube.com/vi/${ytMatch[1]}/mqdefault.jpg` : 'https://placehold.co/120x67/e9ecef/6c757d?text=URL'}" class="list-thumbnail">` : `<video src="videos/${p.first_video_filename}#t=0.5" class="list-thumbnail"></video>`;
                } else if (p.first_image_filename) {
                    thumbnailHtml = `<img src="images/${p.first_image_filename}" class="list-thumbnail">`;
                } else {
                    thumbnailHtml = `<div class="list-thumbnail no-media-placeholder d-flex align-items-center justify-content-center">
                                        <div class="text-center">
                                            <i class="bi bi-camera-video-off fs-4"></i>
                                            <span class="d-block small" style="font-size: 0.65rem;">Sense medis</span>
                                        </div>
                                    </div>`;
                }
                const buttonsHtml = renderActionButtons(p);

                // **NUEVO**: Celda para colaboradores en List
                const collaboratorsCell = `<td class="small wrap-text">${escapeHtml(p.collaborators) || 'Cap'}</td>`;

                // --- ★ TAREA 1 (Nueva Columna) ---
                const createdDate = p.created_at ? new Date(p.created_at).toLocaleDateString('ca-ES', { day: '2-digit', month: '2-digit', year: 'numeric' }) : 'N/A';
                // --- ★ FIN TAREA 1 ---

                tableHtml += `
                    <tr>
                        <td>${thumbnailHtml}</td>
                        <td><strong>${escapeHtml(p.title || 'Sense Títol')}</strong></td>
                        <td>${escapeHtml(p.creator_name || 'N/A')} ${escapeHtml(p.creator_surname || '')}</td>
                        ${collaboratorsCell}
                        <td class="small text-nowrap">${createdDate}</td>
                        <td class="text-center"><span class="badge bg-secondary">${p.exercise_count || 0}</span></td>
                        <td class="text-end">${buttonsHtml}</td>
                    </tr>`;
            });
            container.html(tableHtml + '</tbody></table>');
        }
    }
    // **FIN MODIFICACIÓN**


    // **INICIO MODIFICACIÓN**: Lógica de deshabilitar botones
    function renderActionButtons(protocol) {
        // Lógica de permisos copiada de treatments.php
        const isCreator = protocol.creator_fisio_id == CURRENT_USER_ID;
        const collaboratorIdsArray = protocol.collaborator_ids ? protocol.collaborator_ids.split(',') : [];
        const isCollaborator = collaboratorIdsArray.includes(String(CURRENT_USER_ID));

        // canModify: Para Editar (Creador, Colaborador, Superadmin)
        const canModify = IS_SUPERADMIN || isCreator || isCollaborator;
        // canManage: Para Arxivar/Eliminar (Solo Creador o Superadmin)
        const canManage = IS_SUPERADMIN || isCreator;

        // Escape quotes in data attributes properly
        const titleAttr = protocol.title ? escapeHtml(protocol.title) : ''; // Usar escapeHtml aquí también
        const manage_data = `data-id="${protocol.id}" data-name="${titleAttr}" data-owner-id="${protocol.creator_fisio_id}"`;

        // Aplicar clase 'disabled' y atributos ARIA si no se tienen permisos
        let editButtonHtml = `<li><a class="dropdown-item edit-btn ${!canModify ? 'disabled' : ''}"
                                   href="#"
                                   data-id="${protocol.id}"
                                   ${!canModify ? 'aria-disabled="true" tabindex="-1"' : ''}>
                                   <i class="bi bi-pencil"></i> Editar
                                </a></li>`;

        let manageButtonHtml = `<li><a class="dropdown-item manage-btn ${!canManage ? 'disabled' : ''}"
                                     href="#"
                                     ${manage_data}
                                     ${!canManage ? 'aria-disabled="true" tabindex="-1"' : ''}>
                                     <i class="bi bi-shield-slash"></i> Arxivar / Eliminar
                                  </a></li>`;

        return `
            <div class="dropdown">
                <button class="btn btn-sm btn-outline-secondary dropdown-toggle" type="button" data-bs-toggle="dropdown" aria-expanded="false" title="Gestionar Protocol">
                    <i class="bi bi-gear-fill"></i>
                </button>
                <ul class="dropdown-menu dropdown-menu-end">
                    <li><a class="dropdown-item assign-btn" href="#" data-id="${protocol.id}" data-title="${titleAttr}"><i class="bi bi-send-plus text-success"></i> Assignar a Pacient</a></li>
                    <li><a class="dropdown-item view-protocol-btn" href="#" data-id="${protocol.id}"><i class="bi bi-eye"></i> Veure Detalls</a></li>
                    <li><hr class="dropdown-divider"></li>
                    ${editButtonHtml}
                    <li><a class="dropdown-item clone-btn" href="#" data-id="${protocol.id}" data-title="${titleAttr}"><i class="bi bi-copy"></i> Clonar</a></li>
                    <li><hr class="dropdown-divider"></li>
                    ${manageButtonHtml}
                </ul>
            </div>
        `;
    }
    // **FIN MODIFICACIÓN**

    function renderPagination(pagination) {
        const container = $('#pagination-container');
        container.empty();
        if (!pagination || pagination.totalPages <= 1) return; // Added null check
        let paginationHtml = `<nav><ul class="pagination justify-content-center">`;
        for (let i = 1; i <= pagination.totalPages; i++) {
            paginationHtml += `<li class="page-item ${i === pagination.currentPage ? 'active' : ''}"><a class="page-link" href="#" data-page="${i}">${i}</a></li>`;
        }
        container.html(paginationHtml + '</ul></nav>');
    }

    // --- MODIFICACIÓN JS: Eliminada la función initializeModalFilters() ---

    function loadVisualExerciseLibrary() {

        // --- MODIFICACIÓN JS: Eliminada la comprobación de filtros ---

        const params = {
            ajax: true,
            action: 'get_rich_exercise_library',
            search: $('#modalExerciseSearch').val(),
            // --- MODIFICACIÓN JS: Valores fijos ---
            category: [],
            tags: [],
            filterMine: $('#filterMyExercisesModalProtocol').is(':checked')
        };
        $('#exercise-library-visual-container').html('<div class="text-center p-5"><div class="spinner-border spinner-border-sm" role="status"><span class="visually-hidden">Loading...</span></div></div>');
        $.getJSON('exercises.php', params)
         .done(response => {
             if (response.status === 'success') {
                 renderVisualLibrary(response.exercises);
             } else {
                  console.error("Error loading library:", response.message);
                  $('#exercise-library-visual-container').html('<div class="text-center text-danger p-4">Error carregant exercicis.</div>');
             }
         }).fail((jqXHR, textStatus, errorThrown) => {
              console.error("AJAX Error loading library: ", textStatus, errorThrown, jqXHR.responseText);
              $('#exercise-library-visual-container').html('<div class="text-center text-danger p-4">Error de connexió carregant exercicis.</div>');
          });
    }

    function renderVisualLibrary(exercises) {
             const container = $('#exercise-library-visual-container').empty();

            if (!exercises || exercises.length === 0) {
                container.html('<div class="text-center text-muted p-4">No s\'han trobat exercicis.</div>');
                return;
            }

            exercises.forEach(ex => {
                let thumbnailHtml;

                if (ex.video_filename) {
                    const isEmbed = ex.video_filename.startsWith('http');

                    if (isEmbed) {
                        const ytMatch = ex.video_filename.match(/youtube\.com\/embed\/([a-zA-Z0-9\-_]+)/);

                        if (ytMatch) {
                            // Es YouTube -> Imagen (mqdefault)
                            thumbnailHtml = `<img src="https://img.youtube.com/vi/${ytMatch[1]}/mqdefault.jpg" class="protocol-exercise-library-thumb">`;
                        } else {
                            // ★ CORRECCIÓN: Es URL Externa (MP4) -> Video Tag
                            // Usamos la misma clase css 'protocol-exercise-library-thumb' para mantener el tamaño pequeño (60x34)
                            thumbnailHtml = `<video src="${ex.video_filename}#t=0.5" class="protocol-exercise-library-thumb" muted playsinline></video>`;
                        }
                    } else {
                        // Video Local -> Video Tag
                        thumbnailHtml = `<video src="videos/${ex.video_filename}#t=0.5" class="protocol-exercise-library-thumb" muted playsinline></video>`;
                    }
                } else if (ex.image_filename) {
                    thumbnailHtml = `<img src="images/${ex.image_filename}" class="protocol-exercise-library-thumb">`;
                } else {
                    thumbnailHtml = `<div class="protocol-exercise-library-thumb d-flex flex-column align-items-center justify-content-center bg-light border text-muted"><i class="bi bi-camera-video-off"></i><small style="font-size: 0.6em; line-height: 1; white-space: nowrap;">Sense medis</small></div>`;
                }

                const escapedExerciseData = JSON.stringify(ex).replace(/'/g, '&apos;');
                const alreadyAdded = $(`#assigned-exercises-visual-container .assigned-item-protocol[data-id="${ex.id}"]`).length > 0;

                const itemHtml = `
                    <div class="list-group-item d-flex justify-content-between align-items-center">
                        <div class="d-flex align-items-center">
                            ${thumbnailHtml}
                            <span class="ms-2 small">${escapeHtml(ex.title || 'Sense Títol')}</span>
                        </div>
                        <button type="button" class="btn btn-sm btn-outline-primary add-exercise-btn" ${alreadyAdded ? 'disabled' : ''} data-exercise-id="${ex.id}" data-exercise='${escapedExerciseData}'>
                            <i class="bi ${alreadyAdded ? 'bi-check-lg' : 'bi-plus-lg'}"></i>
                        </button>
                    </div>`;
                container.append(itemHtml);
            });
        }

    function createAssignedCard(exerciseData) {
         if (!exerciseData) return $(); // Return empty jQuery object if no data
        const noMediaBadge = (!exerciseData.video_filename && !exerciseData.image_filename)
            ? '<span class="badge bg-light text-dark fw-normal ms-2">Sense medis</span>'
            : '';
        const notesValue = exerciseData.pauta_notes || exerciseData.notes || '';
        const freqValue = exerciseData.frecuencia || 'Diari'; // Default frequency

        const seriesValue = exerciseData.series || '';
        const repsValue = exerciseData.repetitions || '';
        const restValue = exerciseData.rest_time || '';

        return $(`<div class="card card-body p-2 mb-2 assigned-item-protocol" data-id="${exerciseData.id}">
            <div class="d-flex justify-content-between align-items-center mb-2">
                <div class="d-flex align-items-center">
                    <i class="bi bi-grip-vertical drag-handle me-2" style="cursor: grab;"></i>
                    <strong class="text-primary">${escapeHtml(exerciseData.title || 'Exercici sense títol')}</strong>${noMediaBadge}
                </div>
                <button type="button" class="btn-close remove-assigned-btn"></button>
            </div>
            <div class="row gx-2">
                <div class="col-4">
                    <select class="form-select form-select-sm" data-field="frecuencia">
                        <option value="Diari" ${freqValue === 'Diari' ? 'selected' : ''}>Diari</option>
                        <option value="Altern" ${freqValue === 'Altern' ? 'selected' : ''}>Altern</option>
                        <option value="3xSetmana" ${freqValue === '3xSetmana' ? 'selected' : ''}>3xSetmana</option>
                        <option value="2xSetmana" ${freqValue === '2xSetmana' ? 'selected' : ''}>2xSetmana</option>
                    </select>
                </div>
                <div class="col"><div class="input-group input-group-sm"><span class="input-group-text"><i class="bi bi-arrow-repeat"></i></span><input type="text" class="form-control" placeholder="Sèries" value="${seriesValue}" data-field="series"></div></div>
                <div class="col"><div class="input-group input-group-sm"><span class="input-group-text"><i class="bi bi-stopwatch"></i></span><input type="text" class="form-control" placeholder="Reps" value="${repsValue}" data-field="repetitions"></div></div>
                <div class="col"><div class="input-group input-group-sm"><span class="input-group-text"><i class="bi bi-clock-history"></i></span><input type="text" class="form-control" placeholder="Descans" value="${restValue}" data-field="rest_time"></div></div>
            </div>
            <textarea class="form-control form-control-sm mt-2" data-field="notes" rows="1" placeholder="Notes per a aquest protocol...">${escapeHtml(notesValue)}</textarea>
        </div>`);
    }


    function checkAssignedPlaceholder() {
        const container = $('#assigned-exercises-visual-container');
        const placeholder = container.find('.assigned-placeholder-protocol');
        if (container.children('.assigned-item-protocol').length > 0) {
            placeholder.remove();
        } else if (placeholder.length === 0) {
            const placeholderHtml = `<div class="assigned-placeholder-protocol d-flex align-items-center justify-content-center h-100"><div class="text-center text-muted"><i class="bi bi-card-list fs-1"></i><p class="mt-2">Fes clic al botó '+' en un exercici per afegir-lo al protocol.</p></div></div>`;
            container.html(placeholderHtml);
        }
    }

    // --- ★ CORRECCIÓN 1 (Z-Index JS) ---
    // ELIMINADO EL LISTENER 'show.bs.dropdown' QUE INTENTABA ARREGLAR ESTO.
    // NO ES NECESARIO Y NO ESTÁ EN EXERCISES.PHP
    // --- ★ FIN CORRECCIÓN 1 ---

    // --- Event Handlers ---
    function setupSearch(inputId, clearBtnId, state, fetchFunction) {
        let searchTimeout;
        const inputElement = $(inputId);
        const clearButton = $(clearBtnId);

        inputElement.on('keyup input', function() {
            const hasValue = $(this).val().length > 0;
            clearButton.toggle(hasValue);
            clearTimeout(searchTimeout);
            searchTimeout = setTimeout(() => {
                state.searchQuery = $(this).val();
                state.currentPage = 1;
                fetchFunction();
            }, 300);
        });
        clearButton.on('click', function() {
             inputElement.val('').trigger('input').focus(); // Use 'input' event
         });
    }

    setupSearch('#protocolSearchInput', '#clearProtocolSearchBtn', appState, fetchProtocols);

    $('#filterMyProtocols').on('change', function() {
        appState.filterMine = $(this).is(':checked');
        appState.currentPage = 1;
        $('#creatorFilter').prop('disabled', appState.filterMine).val('');
        appState.creatorId = '';
        fetchProtocols();
    });

    $('#creatorFilter').on('change', function() {
        appState.creatorId = $(this).val();
        appState.currentPage = 1;
        fetchProtocols();
    });

    // ★★★ AÑADIR ESTE HANDLER ★★★
    $('#categoryFilter').on('change', function() {
        appState.categoryId = $(this).val();
        appState.currentPage = 1;
        fetchProtocols();
    });
    // ★★★ FIN ★★★

    $(document).on('click', '.sort-btn, #protocol-library-container .sortable-header', function() {
        const newSort = $(this).data('sort');
        if (!newSort) return; // Evitar clics en headers sin data-sort

        // --- ★ CORRECCIÓN 2 (Botones) ---
        // Quitar 'exercise_count'
        const validSorts = ['id', 'title', 'creator_surname', 'created_at'];
        // --- ★ FIN CORRECCIÓN 2 ---
        if (!validSorts.includes(newSort)) return;


        let defaultOrder;

        if ($(this).hasClass('sort-btn')) {
            defaultOrder = $(this).data('order') || (['title', 'creator_surname'].includes(newSort) ? 'ASC' : 'DESC');
        } else { // Table header
            defaultOrder = (['title', 'creator_surname'].includes(newSort) ? 'ASC' : 'DESC');
        }

        if (appState.sortBy === newSort) {
            appState.sortOrder = appState.sortOrder === 'ASC' ? 'DESC' : 'ASC'; // Toggle order
        } else {
            appState.sortBy = newSort;
            appState.sortOrder = defaultOrder; // Apply default order for new column
        }
        appState.currentPage = 1;
        fetchProtocols();
    });

    // --- ★ TAREA 2 (Limpieza UI) ---
    $('.toggle-view-btn').on('click', function() {
        const newViewMode = $(this).attr('id') === 'gridViewBtn' ? 'grid' : 'list';
        if (appState.viewMode === newViewMode) return; // No fer res si ja està actiu

        appState.viewMode = newViewMode;
        $('.toggle-view-btn').removeClass('active');
        $(this).addClass('active');

        // --- ★ INICIO DE LA MODIFICACIÓN ★ ---
        if (newViewMode === 'list') {
            $('#sort-buttons-group').hide(); // Ocultar botones en Lista
        } else {
            $('#sort-buttons-group').show(); // Mostrar botones en Rejilla
        }
        // --- ★ FIN DE LA MODIFICACIÓN ★ ---

        // Guardar la preferència
        $.post('dashboard.php', {
            ajax: true,
            action: 'save_view_preference',
            page_name: 'protocols', // Clau per a protocols
            view_mode: newViewMode
        }, 'json')
        .done(res => {
            if(res.status === 'success') { console.log('Vista guardada: protocols -> ' + newViewMode); }
        })
        .fail(xhr => {
             console.error('Error guardant la preferència de vista.', xhr.responseText);
        });

        fetchProtocols(); // Recarregar la vista
     });
    // --- ★ FIN TAREA 2 ---

    // **INICIO MODIFICACIÓN**: Handler para 'Editar' (respetar 'disabled')
    $(document).on('click', '#addProtocolBtn, .edit-btn', function(e) {
         e.preventDefault();

         // **NUEVO**: Comprobar si está deshabilitado
         if ($(this).hasClass('edit-btn') && ($(this).is(':disabled') || $(this).hasClass('disabled'))) {
             return;
         }

         const id = $(this).data('id'); // Will be undefined for 'add' button
         const form = $('#protocolForm');
         form[0].reset();
         form.find('[name="id"]').val(id || ''); // Set hidden ID field
         $('#protocolModalLabel').text(id ? 'Editar Protocol' : 'Nou Protocol');

         // Reset assigned exercises container FIRST
        const placeholderHtml = `<div class="assigned-placeholder-protocol d-flex align-items-center justify-content-center h-100"><div class="text-center text-muted"><i class="bi bi-card-list fs-1"></i><p class="mt-2">Fes clic al botó '+' en un exercici per afegir-lo al protocol.</p></div></div>`;
        $('#assigned-exercises-visual-container').html(placeholderHtml);

         // **NUEVO**: Resetear select de colaboradores
         if(protocolFisioTomSelect) protocolFisioTomSelect.clear();

         // --- MODIFICACIÓN JS: Limpiar filtros y "X" ---
         $('#modalExerciseSearch').val('');
         $('#clearModalSearchBtnProtocol').hide();
         // --- Fin Modificación ---

         if (id) { // If editing, fetch details
             $.getJSON('protocols.php', { ajax: true, action: 'get_protocol_details', id: id })
             .done(response => {
                 if(response.status === 'success' && response.protocol) { // Added null check for protocol
                     const protocol = response.protocol;
                     form.find('[name="title"]').val(protocol.title || ''); // Add null checks
                     form.find('[name="anamnesis"]').val(protocol.anamnesis || '');
                     form.find('[name="diagnostico"]').val(protocol.diagnostico || '');

                     // **NUEVO**: Poblar y configurar select de colaboradores
                     if (protocolFisioTomSelect) {
                        protocolFisioTomSelect.setValue(protocol.assigned_fisios);
                        // Deshabilitar selector si el usuario NO es el creador o superadmin
                        const isCreatorOrAdmin = IS_SUPERADMIN || protocol.creator_fisio_id == CURRENT_USER_ID;
                        if (isCreatorOrAdmin) {
                            protocolFisioTomSelect.enable();
                        } else {
                            protocolFisioTomSelect.disable();
                        }
                     }
                     // --- Fin nuevo ---

                     if (protocol.assigned_exercises && protocol.assigned_exercises.length > 0) {
                         $('#assigned-exercises-visual-container').empty(); // Clear placeholder
                         protocol.assigned_exercises.forEach(ex => {
                             const card = createAssignedCard(ex);
                             card.find('[data-field="frecuencia"]').val(ex.frecuencia || 'Diari');
                             card.find('textarea[data-field="notes"]').val(ex.pauta_notes || '');
                             $('#assigned-exercises-visual-container').append(card);
                         });
                     } else {
                          checkAssignedPlaceholder(); // Ensure placeholder if no exercises
                      }
                     loadVisualExerciseLibrary(); // Load library after setting up assigned
                     if(protocolModal) protocolModal.show();
                 } else {
                     showToast(response.message || "Error: No s'han pogut carregar les dades del protocol.", "danger");
                 }
             }).fail(() => showToast("Error de connexió carregant detalls del protocol.", "danger"));
         } else { // If creating new
              if(protocolFisioTomSelect) protocolFisioTomSelect.enable(); // Asegurar que está habilitado al crear
              loadVisualExerciseLibrary(); // Load library immediately
              if(protocolModal) protocolModal.show(); // Show modal for new protocol
          }
     });
    // **FIN MODIFICACIÓN**

     $(document).on('click', '.view-protocol-btn', function(e) {
         e.preventDefault();
         const id = $(this).data('id');
         $('#viewProtocolModalBody').html('<div class="text-center p-5"><div class="spinner-border text-primary"></div></div>');
         if(viewProtocolModal) viewProtocolModal.show();

         $.getJSON('protocols.php', { ajax: true, action: 'get_protocol_details', id: id }, response => {
             if (response.status === 'success' && response.protocol) {
                 const p = response.protocol;
                 $('#viewProtocolModalLabel').text(escapeHtml(p.title || 'Detalls del Protocol'));
                 let creatorInfo = (p.creator_name || p.creator_surname) ? `${escapeHtml(p.creator_name)} ${escapeHtml(p.creator_surname)}` : 'Sistema';

                 // **NUEVO**: Mostrar colaboradores (si existen)
                 let collaboratorsHtml = '';
                 if (p.assigned_fisios && p.assigned_fisios.length > 0) {
                     // Necesitamos los nombres de los fisios. allFisios los tiene.
                     let colabNames = [];
                     p.assigned_fisios.forEach(fisioId => {
                         // No mostrar al creador en la lista de "colaboradores"
                         if (fisioId != p.creator_fisio_id) {
                            const fisio = allFisios.find(f => f.id == fisioId);
                            if (fisio) {
                                colabNames.push(`${escapeHtml(fisio.nombre)} ${escapeHtml(fisio.apellido)}`);
                            }
                         }
                     });
                     if (colabNames.length > 0) {
                        collaboratorsHtml = `<p><strong>Col·laboradors:</strong> ${colabNames.join(', ')}</p>`;
                     }
                 }
                 // --- Fin nuevo ---

                // --- ★ TAREA 1 (Nueva Columna) ---
                const createdDate = p.created_at ? new Date(p.created_at).toLocaleDateString('ca-ES') : 'N/A';
                // --- ★ FIN TAREA 1 ---

                 let contentHtml = `
                     <div class="mb-4">
                         <h5 class="mb-3">Informació General</h5>
                         <p><strong>Creat per:</strong> ${creatorInfo}</p>
                         <p><strong>Data de creació:</strong> ${createdDate}</p>
                         ${collaboratorsHtml}
                         <div class="row">
                            <div class="col-md-6">
                                <h6><i class="bi bi-file-text me-2"></i>Guia d'Anamnesi</h6>
                                <p class="text-muted ps-4">${escapeHtml(p.anamnesis) || 'No especificat'}</p>
                            </div>
                            <div class="col-md-6">
                                <h6><i class="bi bi-clipboard-check me-2"></i>Diagnòstic/Indicacions</h6>
                                <p class="text-muted ps-4">${escapeHtml(p.diagnostico) || 'No especificat'}</p>
                            </div>
                         </div>
                     </div>
                     <hr>
                     <h5 class="mb-3"><i class="bi bi-list-ol me-2"></i>Exercicis Incluosos (${p.assigned_exercises.length})</h5>
                     <div class="list-group list-group-flush">`;

                 if (p.assigned_exercises && p.assigned_exercises.length > 0) {
                     p.assigned_exercises.forEach(ex => {
                         let thumbnailHtml = '';
                         if(ex.video_filename) {
                             const isEmbed = ex.video_filename.startsWith('http');
                             const ytMatch = isEmbed ? ex.video_filename.match(/youtube\.com\/embed\/([a-zA-Z0-9\-_]+)/) : null;
                             thumbnailHtml = isEmbed ? `<img src="${ytMatch ? `https://img.youtube.com/vi/${ytMatch[1]}/mqdefault.jpg` : ''}" class="view-ex-thumb" alt="Miniatura Video">` : `<video src="videos/${ex.video_filename}#t=0.5" class="view-ex-thumb"></video>`;
                         } else if (ex.image_filename) {
                             thumbnailHtml = `<img src="images/${ex.image_filename}" class="view-ex-thumb" alt="Miniatura Imatge">`;
                         } else {
                              thumbnailHtml = `<div class="view-ex-thumb d-flex align-items-center justify-content-center bg-light border"><i class="bi bi-camera-video-off fs-4 text-muted"></i></div>`;
                         }
                         contentHtml += `
                            <div class="list-group-item px-0">
                                <div class="d-flex w-100">
                                    <div class="flex-shrink-0 me-3" style="width:100px;">${thumbnailHtml}</div>
                                    <div class="flex-grow-1">
                                        <h6 class="mb-1">${escapeHtml(ex.title || 'Exercici sense títol')}</h6>
                                        <p class="mb-1 small"><strong>Pauta:</strong> ${escapeHtml(ex.frecuencia) || 'Diari'} | ${escapeHtml(ex.series)} sèries | ${escapeHtml(ex.repetitions)} reps | ${escapeHtml(ex.rest_time)} descans</p>
                                        ${ex.pauta_notes ? `<p class="mb-0 small text-muted fst-italic"><strong>Notes específiques:</strong> ${escapeHtml(ex.pauta_notes)}</p>` : ''}
                                    </div>
                                </div>
                            </div>`;
                     });
                 } else {
                     contentHtml += '<p class="text-muted">Aquest protocol no té exercicis assignats.</p>';
                 }
                 contentHtml += '</div>'; // Close list-group
                 $('#viewProtocolModalBody').html(contentHtml);
             } else {
                  $('#viewProtocolModalBody').html('<div class="alert alert-danger">No s\'ha pogut carregar la informació del protocol.</div>');
             }
         }).fail(() => {
              $('#viewProtocolModalBody').html('<div class="alert alert-danger">Error de connexió en carregar els detalls del protocol.</div>');
         });
     });

    // **INICIO MODIFICACIÓN**: Handler para 'Gestionar' (respetar 'disabled')
     $(document).on('click', '.manage-btn', function(e) {
        e.preventDefault();

        // **NUEVO**: Comprobar si está deshabilitado
        if ($(this).is(':disabled') || $(this).hasClass('disabled')) {
            return;
        }

        const id = $(this).data('id');
        const name = $(this).data('name'); // Get name correctly
        const ownerId = $(this).data('owner-id');
        itemToManage = { id: id, name: name, ownerId: ownerId }; // Use fetched values

        // **MODIFICADO**: La lógica de permisos ahora se basa en 'canManage'
        // 'canManage' (IS_SUPERADMIN || isCreator) ya se comprobó al renderizar el botón,
        // pero volvemos a definir la lógica aquí para el botón de eliminar.
        const isCreator = itemToManage.ownerId == CURRENT_USER_ID;
        const canDelete = IS_SUPERADMIN || isCreator; // Solo creador o admin pueden eliminar

        $.getJSON('protocols.php', { ajax: true, action: 'check_protocol_usage', id: itemToManage.id })
        .done(response => {
            const isInUse = !response.is_usable_for_action;
            const modalTitle = $('#manageModalLabel');
            const modalBody = $('#manageModalBody').empty();
            const archiveBtn = $('#archiveBtn').off('click').hide();
            const deleteBtn = $('#deleteBtn').off('click').hide();

            modalTitle.text(`Gestionar: ${itemToManage.name}`);

            if (isInUse) {
                let usageHtml = `<div class="alert alert-warning mb-3"><i class="bi bi-exclamation-triangle-fill me-2"></i><strong>Protocol en Ús</strong><br>Aquest protocol s'està utilitzant en els següents tractaments actius o programats:</div><ul class="list-group list-group-flush small">`;
                 if (response.usage && response.usage.length > 0) {
                     response.usage.forEach(item => { usageHtml += `<li class="list-group-item">${item}</li>`; });
                 } else {
                      usageHtml += '<li class="list-group-item">No s\'ha pogut determinar l\'ús específic.</li>';
                 }
                usageHtml += '</ul><hr>';
                modalBody.append(usageHtml);
            }

            // El botón de archivar siempre está disponible para fisios/superadmin
            modalBody.append(`<p>Pots arxivar aquest protocol per a ocultar-lo de la teua vista personal sense afectar a altres usuaris.</p>`);
            archiveBtn.text('Arxivar per a mi').show().on('click', handlePersonalArchive);

            // Mostrar botón de eliminar solo si 'canDelete' es true
            if (canDelete) {
                if (IS_SUPERADMIN) {
                    modalBody.append('<hr><p>Com a administrador, pots eliminar aquest protocol permanentment.</p>');
                } else { // Es creador
                     modalBody.append('<hr><p>Com que ets el creador, pots eliminar aquest protocol.</p>');
                }

                deleteBtn.show().on('click', handleDelete);

                if (isInUse) {
                    if (IS_SUPERADMIN) {
                        deleteBtn.text('Forçar Eliminació').addClass('btn-danger').removeClass('btn-outline-danger').prop('disabled', false);
                    } else { // Es creador pero está en uso
                        deleteBtn.text('Eliminar (No permés en ús)').prop('disabled', true).attr('title', 'No es pot eliminar porque està en ús');
                    }
                } else {
                    deleteBtn.text('Eliminar Permanentment').prop('disabled', false);
                }
            }

            if(manageModal) manageModal.show();
        })
        .fail(() => showToast("Error al comprovar l'ús del protocol.", "danger"));
    });
    // **FIN MODIFICACIÓN**

     function handlePersonalArchive() {
        $.post('protocols.php', { ajax: true, action: 'personal_archive', id: itemToManage.id }, 'json')
        .done(res => { showToast(res.message, 'success'); if(manageModal) manageModal.hide(); fetchProtocols(); })
        .fail(xhr => showToast(xhr.responseJSON?.message || 'Error', 'danger'));
    }

    // --- ★ TAREA 5 (Flash de Borrado) ---
    function handleDelete() {
                if (prompt(`Per a confirmar l'eliminació permanent de "${itemToManage.name}", escriu ELIMINAR ací baix:`) === 'ELIMINAR') {

                    const idToDelete = itemToManage.id;
                    const $manageModal = (manageModal ? $(manageModal._element) : $('#manageModal'));

                    // 1. Encontrar el elemento ANTES de borrarlo
                    let elementToDelete;
                    if (appState.viewMode === 'grid') {
                        elementToDelete = $(`.protocol-card .view-protocol-btn[data-id="${idToDelete}"]`).closest('.protocol-card');
                    } else {
                        elementToDelete = $(`tr .view-protocol-btn[data-id="${idToDelete}"]`).closest('tr');
                    }

                    // 2. Ocultar el modal inmediatamente
                    if(manageModal) manageModal.hide();

                    if (elementToDelete.length > 0) {
                        // 3. Aplicar la animación de borrado
                        elementToDelete.addClass('flash-delete');

                        // 4. Esperar a que termine la animación (1.5s)
                        setTimeout(() => {
                            // 5. Enviar la petición de borrado SOLO DESPUÉS de la animación
                            $.post('protocols.php', { ajax: true, action: 'delete_protocol', id: idToDelete }, 'json')
                            .done(res => {
                                showToast(res.message, 'success');
                                // 6. Recargar la lista (el elemento ya está invisible)
                                fetchProtocols();
                            })
                            .fail(xhr => {
                                showToast(xhr.responseJSON?.message || 'Error', 'danger');
                                // Si falla, quitamos la clase para que reaparezca
                                elementToDelete.removeClass('flash-delete');
                            });
                        }, 1500); // Debe coincidir con la duración de la animación CSS

                    } else {
                        // Fallback (si no se encontró el elemento, solo borrar y recargar)
                        $.post('protocols.php', { ajax: true, action: 'delete_protocol', id: idToDelete }, 'json')
                        .done(res => { showToast(res.message, 'success'); fetchProtocols(); })
                        // --- ★ AQUÍ ESTABA EL ERROR (JQuery.) - YA ESTÁ CORREGIDO ★ ---
                        .fail(xhr => showToast(xhr.responseJSON?.message || 'Error', 'danger'));
                    }
                } else {
                    showToast("L'acció d'eliminació ha sigut cancel·lada.", 'info');
                }
            }
    // --- ★ FIN TAREA 5 ---


     // --- Other handlers ---
    $(document).on('click', '.add-exercise-btn', function() {
        const btn = $(this);
        let exerciseData;
        try {
            const rawData = btn.attr('data-exercise').replace(/&apos;/g, "'");
            exerciseData = JSON.parse(rawData);
             if (!exerciseData || typeof exerciseData !== 'object' || !exerciseData.id) throw new Error("Invalid structure");
        } catch (e) {
            console.error("Error parsing exercise data on add:", e, btn.attr('data-exercise'));
            showToast("Error intern: No s'ha pogut afegir l'exercici (dades invàlides).", "danger");
            return;
        }
        if ($(`#assigned-exercises-visual-container .assigned-item-protocol[data-id="${exerciseData.id}"]`).length > 0) { return; }
        const card = createAssignedCard(exerciseData);
        $('#assigned-exercises-visual-container').append(card);
        checkAssignedPlaceholder();
        btn.prop('disabled', true).html('<i class="bi bi-check-lg"></i>');
    });

    $(document).on('click', '.remove-assigned-btn', function() {
        const card = $(this).closest('.assigned-item-protocol');
        const exerciseId = card.data('id');
        card.remove();
        checkAssignedPlaceholder();
        const addButton = $(`#exercise-library-visual-container .add-exercise-btn[data-exercise-id="${exerciseId}"]`);
        if (addButton.length > 0) {
            addButton.prop('disabled', false).html('<i class="bi bi-plus-lg"></i>');
        }
    });

    // --- ★ TAREA 4 (Flash Suave) ---
    $('#protocolForm').on('submit', function(e) {
        e.preventDefault();
        let assignedExercises = [];
        $('#assigned-exercises-visual-container .assigned-item-protocol').each(function() {
            assignedExercises.push({
                id: $(this).data('id'),
                frecuencia: $(this).find('[data-field="frecuencia"]').val() || 'Diari',
                series: $(this).find('[data-field="series"]').val() || '',
                repetitions: $(this).find('[data-field="repetitions"]').val() || '',
                rest_time: $(this).find('[data-field="rest_time"]').val() || '',
                notes: $(this).find('textarea[data-field="notes"]').val() || ''
            });
        });

        if (assignedExercises.length === 0) {
            showToast('Has de seleccionar almenys un exercici per al protocol.', 'danger');
            return;
        }

        $('#assignedExercisesInput').val(JSON.stringify(assignedExercises));
        const action = $(this).find('[name="id"]').val() ? 'update_protocol' : 'create_protocol';

        const formData = $(this).serialize();

        $.post('protocols.php', `ajax=true&action=${action}&${formData}`, 'json')
        .done(res => {
            if(res.status === 'success'){
                showToast(res.message, 'success');
                if(protocolModal) protocolModal.hide();

                const idToHighlight = res.saved_protocol_id; // <-- Capturamos el ID

                // Llamamos a fetchProtocols() y esperamos a que termine
                fetchProtocols().done(() => {
                    if (idToHighlight) {
                        let elementToFlash;
                        if (appState.viewMode === 'grid') {
                            elementToFlash = $(`.protocol-card .view-protocol-btn[data-id="${idToHighlight}"]`).closest('.protocol-card');
                        } else {
                            elementToFlash = $(`tr .view-protocol-btn[data-id="${idToHighlight}"]`).closest('tr');
                        }

                        if (typeof flashElement === 'function' && elementToFlash && elementToFlash.length > 0) {
                             setTimeout(() => { // Delay para fluidez
                                flashElement(elementToFlash);
                            }, 50);
                        }
                    }
                });
            } else {
                 showToast(res.message || 'Error desconegut al guardar.', 'danger');
             }
        }).fail(xhr => showToast(xhr.responseJSON?.message || 'Error de connexió al guardar.', 'danger'));
    });
    // --- ★ FIN TAREA 4 ---

    $(document).on('click', '.assign-btn', function(e) {
        e.preventDefault();
        const protocolId = $(this).data('id');
        const protocolName = $(this).data('title');
        $('#assignProtocolName').text(protocolName);
        $('#assignProtocolForm [name="protocol_id"]').val(protocolId);
        const pacienteSelect = $('#pacienteSelect');
        pacienteSelect.empty().append('<option value="" selected disabled>Selecciona un pacient...</option>'); // Improved placeholder
        if(allPacientes && allPacientes.length > 0) {
             allPacientes.forEach(p => {
                 pacienteSelect.append(new Option(`${p.apellido}, ${p.nombre}`, p.id));
             });
         } else {
              pacienteSelect.append('<option value="" disabled>No hi ha pacients disponibles</option>');
          }
        if(assignProtocolModal) assignProtocolModal.show();
    });

    // --- INICIO MODIFICACIÓN: Canviar 'assign' per a redirigir ---
    $('#assignProtocolForm').on('submit', function(e){
        e.preventDefault();
        const pacienteId = $('#pacienteSelect').val();
        const protocolId = $(this).find('[name="protocol_id"]').val();

        if (!pacienteId) {
            showToast('Has de seleccionar un pacient.', 'danger');
            return;
        }

        // Tancar el modal
        if(assignProtocolModal) assignProtocolModal.hide();

        // Redirigir a la fitxa del pacient amb instruccions
        const targetUrl = `fitxa_pacient.php?id=${pacienteId}&action=assign_protocol&protocol_id=${protocolId}`;
        window.location.href = targetUrl;
    });
    // --- FIN MODIFICACIÓN ---

    $(document).on('click', '.clone-btn', function(e) {
        e.preventDefault();
        $('#cloneProtocolForm input[name="original_protocol_id"]').val($(this).data('id'));
        $('#cloneProtocolForm input[name="title"]').val(`Còpia de: ${$(this).data('title')}`);
        if(cloneProtocolModal) cloneProtocolModal.show();
    });

    // --- ★ TAREA 3 y 4 (Clonación Lógica y Flash Suave) ---
    $('#cloneProtocolForm').on('submit', function(e) {
        e.preventDefault();
        $.post('protocols.php', `ajax=true&action=clone_protocol&${$(this).serialize()}`, response => {
            if (response.status === 'success') {
                showToast(response.message, 'success');
                if(cloneProtocolModal) cloneProtocolModal.hide();

                const idToHighlight = response.new_protocol_id; // <-- Capturamos el ID

                // No reseteamos la página, nos quedamos en la actual
                fetchProtocols().done(() => {
                    if (idToHighlight) {
                        let elementToFlash;
                        if (appState.viewMode === 'grid') {
                            elementToFlash = $(`.protocol-card .view-protocol-btn[data-id="${idToHighlight}"]`).closest('.protocol-card');
                        } else {
                            elementToFlash = $(`tr .view-protocol-btn[data-id="${idToHighlight}"]`).closest('tr');
                        }

                        if (typeof flashElement === 'function' && elementToFlash && elementToFlash.length > 0) {
                             setTimeout(() => { // Delay para fluidez
                                flashElement(elementToFlash);
                            }, 50);
                        }
                    }
                });
            } else {
                 showToast(response.message || 'Error desconegut en clonar.', 'danger');
             }
        }, 'json').fail(xhr => showToast(xhr.responseJSON?.message || 'Error de connexió en clonar.', 'danger'));
    });
    // --- ★ FIN TAREA 3 y 4 ---

    $(document).on('click', '.page-link', function(e) {
         e.preventDefault();
         const newPage = $(this).data('page');
         if (appState.currentPage != newPage) {
             appState.currentPage = newPage;
             fetchProtocols();
         }
     });

    // --- ======================================================= ---
    // --- ============ INICIO: MODIFICACIÓN JS HANDLERS ========== ---
    // --- ======================================================= ---

    // Reemplazar el handler antiguo por este bloque
    let searchTimeoutProtocol;
    $('#modalExerciseSearch').on('keyup input', function() {
        const hasValue = $(this).val().length > 0;
        $('#clearModalSearchBtnProtocol').toggle(hasValue); // Controla la "X"

        clearTimeout(searchTimeoutProtocol);
        searchTimeoutProtocol = setTimeout(loadVisualExerciseLibrary, 300);
    });

    $('#clearModalSearchBtnProtocol').on('click', function() {
        $('#modalExerciseSearch').val('').trigger('input').focus();
    });

    $('#filterMyExercisesModalProtocol').on('change', loadVisualExerciseLibrary);

    // --- ======================================================= ---
    // --- ============= FIN: MODIFICACIÓN JS HANDLERS =========== ---
    // --- ======================================================= ---


    // --- Initial Load ---
    if ($('#filterMyProtocols').length > 0) {
        $('#filterMyProtocols').prop('checked', appState.filterMine);
        if (appState.filterMine) {
            $('#creatorFilter').prop('disabled', true);
        }
    }

    // --- ★ TAREA 2 (Limpieza UI) ---
    // Aplicar el estado inicial de los botones de vista/ordenación
    $('.toggle-view-btn').removeClass('active');
    if (appState.viewMode === 'grid') {
        $('#gridViewBtn').addClass('active');
        $('#sort-buttons-group').show();
    } else {
        $('#listViewBtn').addClass('active');
        $('#sort-buttons-group').hide();
    }
    // --- ★ FIN TAREA 2 ---

    fetchDependencies(); // Load filters and other data first
    fetchProtocols(); // Load the protocols list
});
</script>

</body>
</html>
