<?php
// /partials/patient_widgets.php

// Este archivo espera recibir un array $widget_data con la información calculada.
// Ejemplo de $widget_data esperado:
// $widget_data = [
//     'total_recorded_days' => 5,
//     'total_recorded_exercises' => 12,
//     'avg_pain_last_week' => 2.5,
//     'avg_effort_last_week' => 3.1,
//     'streak_days' => 3,
//     'assigned_fisios_string' => "Ana García, Jordi Martí"
// ];

// Valores por defecto por si algo falla
$total_recorded_days = $widget_data['total_recorded_days'] ?? 0;
$total_recorded_exercises = $widget_data['total_recorded_exercises'] ?? 0;
$avg_pain_last_week = isset($widget_data['avg_pain_last_week']) ? number_format($widget_data['avg_pain_last_week'], 1) : 'N/A';
$avg_effort_last_week = isset($widget_data['avg_effort_last_week']) ? number_format($widget_data['avg_effort_last_week'], 1) : 'N/A';
$streak_days = $widget_data['streak_days'] ?? 0;
$assigned_fisios_string = $widget_data['assigned_fisios_string'] ?? 'No assignat';

?>

<div class="col-md-5">
    <div class="card h-100 shadow-sm">
        <div class="card-body">
            <h5 class="card-title mb-3"><i class="bi bi-graph-up text-primary me-2"></i>Resum de Progrés</h5>
            <div class="row text-center mb-2">
                <div class="col">
                    <div class="display-6 fw-bold"><?= $total_recorded_days ?></div>
                    <small class="text-muted">Dies Registrats</small>
                </div>
                <div class="col">
                    <div class="display-6 fw-bold"><?= $total_recorded_exercises ?></div>
                    <small class="text-muted">Exercicis Fets</small>
                </div>
            </div>
            <hr class="my-2">
            <div class="row small text-center">
                 <div class="col">
                     <small class="text-muted">Dolor (Mitjà últ. setmana)</small>
                     <div class="fs-5 fw-bold"><?= $avg_pain_last_week ?> <small>/ 5</small></div>
                 </div>
                 <div class="col">
                      <small class="text-muted">Esforç (Mitjà últ. setmana)</small>
                      <div class="fs-5 fw-bold"><?= $avg_effort_last_week ?> <small>/ 5</small></div>
                 </div>
            </div>
        </div>
    </div>
</div>

<div class="col-md-3">
    <div class="card h-100 shadow-sm text-center bg-light">
        <div class="card-body d-flex flex-column justify-content-center">
            <h5 class="card-title mb-2"><i class="bi bi-fire text-danger me-2"></i>Ratxa Actual</h5>
            <div class="display-4 fw-bolder text-danger"><?= $streak_days ?></div>
            <p class="mb-0 text-muted">di<?= $streak_days == 1 ? 'a' : 'es' ?> seguits registrant!</p>
            <?php if ($streak_days >= 3): ?>
                <small class="mt-2 fw-bold text-success">¡Molt bé, continua així! 💪</small>
            <?php elseif ($streak_days > 0): ?>
                 <small class="mt-2 text-muted">¡Bon començament!</small>
            <?php else: ?>
                 <small class="mt-2 text-muted">Registra hui per començar!</small>
            <?php endif; ?>
        </div>
    </div>
</div>

<div class="col-md-4">
    <div class="card h-100 shadow-sm">
        <div class="card-body">
            <h5 class="card-title mb-3"><i class="bi bi-person-check-fill text-info me-2"></i>El Teu Fisioterapeuta</h5>
            <p class="mb-2">Estàs sent atès/a per:</p>
            <p class="fw-bold fs-5"><?= htmlspecialchars($assigned_fisios_string) ?></p>
            </div>
    </div>
</div>
