<?php
// /partials/header.php

// --- GESTIÓN DE SESIÓN Y DEPENDENCIAS ---
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}
require_once 'db.php'; // Asegúrate de que $db está disponible globalmente aquí

// --- ★ INICIO CORRECCIÓN BUG SUPLANTACIÓN v3 (Manejo de "bandera") ★ ---
$needs_avatar_fetch = false;

if (isset($_SESSION['admin_origen_id'])) {
    // 1. Estamos suplantando (ej. Admin suplantando a Fisio).
    // Forzamos la recarga del avatar del suplantado.
    $needs_avatar_fetch = true;

} elseif (isset($_SESSION['user_id']) && !isset($_SESSION['admin_origen_id']) && isset($_SESSION['avatar_is_suplanted']) && $_SESSION['avatar_is_suplanted'] === true) {
    // 2. ★ AQUÍ SE CORRIGE EL BUG DE "VUELTA" ★
    // No estamos suplantando, PERO la bandera está activa.
    // Significa que ACABAMOS de volver de suplantar (stop_impersonating.php).
    // La sesión está "sucia" con el avatar del paciente.
    // Forzamos la recarga del avatar del admin (el usuario real).
    $needs_avatar_fetch = true;

} elseif (isset($_SESSION['user_id']) && !isset($_SESSION['user_avatar'])) {
    // 3. Login normal, pero el avatar no está en sesión (login o F5).
    // (Esta es la lógica de "auto-reparación" original).
    $needs_avatar_fetch = true;
}

// Si $needs_avatar_fetch es true (por cualquier motivo), ejecutamos la BBDD.
if ($needs_avatar_fetch && isset($db) && isset($_SESSION['user_id'])) {
    try {
        $stmt_avatar = $db->prepare("SELECT avatar FROM cuentas WHERE id = ?");
        $stmt_avatar->execute([$_SESSION['user_id']]);
        $avatar_path = $stmt_avatar->fetchColumn();

        // Sobrescribir la sesión con el avatar correcto (el del admin).
        $_SESSION['user_avatar'] = $avatar_path ?: null;

        // --- ★ ESTA ES LA LIMPIEZA (PASO 2) ★ ---
        // Si la bandera existía, la limpiamos porque ya hemos recargado nuestro avatar.
        if (isset($_SESSION['avatar_is_suplanted'])) {
            unset($_SESSION['avatar_is_suplanted']);
        }
        // --- ★ FIN LIMPIEZA ★ ---

    } catch (Exception $e) {
        error_log("Error al forzar recarga de avatar en header: " . $e->getMessage());
        $_SESSION['user_avatar'] = null; // Prevenir re-intentos
    }
}
// --- ★ FIN CORRECCIÓN BUG SUPLANTACIÓN v3 ★ ---


// --- Variables de sesión estándar ---
$user_id = $_SESSION['user_id'] ?? 0;
$user_rol = $_SESSION['user_rol'] ?? '';

// --- ★ INICIO: LÓGICA DE VISTA LECTURA (GLOBAL O SUPLANTACIÓN) ★ ---
// Esta variable controlará la visibilidad del Chat y Notificaciones
$is_impersonating = isset($_SESSION['admin_origen_id']);
$is_global_view = ($user_rol === 'superadmin' && ($_SESSION['dashboard_view'] ?? 'personal') === 'global');
$is_read_only_view = $is_impersonating || $is_global_view;
// --- ★ FIN: LÓGICA DE VISTA LECTURA ★ ---

$current_page = basename($_SERVER['PHP_SELF']);
$return_param = '?return_to=' . urlencode($current_page); // Usar urlencode por seguridad

// --- **** INICIO: MODIFICACIÓN LÓGICA 3 (RECOMPTE DE XAT) **** ---
$total_unread_messages = 0;
// ===== INICIO MODIFICACIÓN (Ocultar Chat durante suplantación Y VISTA GLOBAL) =====
// No calculamos los mensajes si estamos en modo solo-lectura
if (isset($user_id) && in_array($user_rol, ['superadmin', 'fisio']) && isset($db) && !$is_read_only_view) {
// ===== FIN MODIFICACIÓN =====
    try {
        // *** CORRECCIÓN AQUÍ: Contar solo de pacientes activos y vinculados ***
        $stmt_unread_header = $db->prepare("
            SELECT COUNT(DISTINCT cm.from_id)
            FROM chat_messages cm
            JOIN cuentas p ON cm.from_id = p.id
            JOIN tratamientos t ON t.paciente_id = p.id
            LEFT JOIN tratamiento_fisios_asignados tfa ON t.id = tfa.tratamiento_id
            WHERE
                cm.to_id = :user_id
                AND cm.status != 'read'
                AND p.rol = 'paciente'
                AND p.status = 'activo'
                AND t.status = 'En curs'
                AND (t.creator_fisio_id = :user_id OR tfa.fisio_id = :user_id)
                -- Se elimina: OR p.id_fisio_registrador = :user_id (Corrección Bug Chat)
        ");
        $stmt_unread_header->execute([':user_id' => $user_id]);
        $total_unread_messages = (int)$stmt_unread_header->fetchColumn();
        $total_unread_messages = $total_unread_messages ?: 0; // Asegurar que sea 0 si no hay
    } catch (Exception $e) {
        error_log("Error al calcular mensajes no leídos en header.php: " . $e->getMessage());
        $total_unread_messages = 0;
    }
}
// --- **** FIN: MODIFICACIÓN LÓGICA 3 (RECOMPTE DE XAT) **** ---

// --- Variables para la navegación y título (ACTUALIZADAS) ---
$nav_items = [
    // ***** INICIO CAMBIO MENU *****

    // ===== MODIFICACIÓN 4: "Inici" renombrado a "Panell" =====
    'dashboard.php' => ['label' => 'Panell', 'icon' => 'bi-grid-1x2-fill', 'roles' => ['superadmin', 'fisio']], // NUEVA LÍNEA

    'users.php' => ['label' => 'Usuaris', 'icon' => 'bi-people', 'roles' => ['superadmin', 'fisio']], // MODIFICADA (antes apuntaba a dashboard.php y se llamaba Inici)
    // ***** FIN CAMBIO MENU *****

    'gallery.php' => ['label' => 'Medis', 'icon' => 'bi-collection-play', 'roles' => ['superadmin', 'fisio']],
    'taxonomy.php' => ['label' => 'Categories', 'icon' => 'bi-tags', 'roles' => ['superadmin']],
    'exercises.php' => ['label' => 'Exercicis', 'icon' => 'bi-person-arms-up', 'roles' => ['superadmin', 'fisio']],
    'protocols.php' => ['label' => 'Protocols', 'icon' => 'bi-clipboard2-pulse', 'roles' => ['superadmin', 'fisio']],
    'treatments.php' => ['label' => 'Tractaments', 'icon' => 'bi-journal-medical', 'roles' => ['superadmin', 'fisio']],

    // ===== INICIO DE LA MODIFICACIÓN: Mover Arxiu y Anuncis a la barra principal (SIN SEPARADOR) =====
    'archive.php' => ['label' => 'Arxiu', 'icon' => 'bi-archive', 'roles' => ['superadmin', 'fisio']],
    'announcements.php' => ['label' => 'Anuncis', 'icon' => 'bi-megaphone', 'roles' => ['superadmin', 'fisio']],
    // ===== FIN DE LA MODIFICACIÓN =====

    'patient_dashboard.php' => ['label' => 'El Meu Tractament', 'icon' => 'bi-speedometer2', 'roles' => ['paciente']],
];
?>
<!DOCTYPE html>
<html lang="ca">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= isset($page_title) ? htmlspecialchars($page_title) . ' - ' : '' ?>AVANT ONLINE</title>
    <link rel="icon" href="logos/favicon.ico" type="image/png">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css">
    <link rel="stylesheet" href="style.css?v=1.3">
    <link href="https://cdn.jsdelivr.net/npm/tom-select@2.3.1/dist/css/tom-select.bootstrap5.css" rel="stylesheet">

    <script src="https://cdn.jsdelivr.net/npm/tom-select@2.3.1/dist/js/tom-select.complete.min.js"></script>

    <style>

    body {
    /* Espacio permanente para el header principal (fixed-top) */
    padding-top: 75px;
      padding-bottom: 15px;
}
        /* --- ESTILOS PARA AVATAR (AÑADIDOS) --- */
        .user-avatar-icon {
            width: 50px;
            height: 50px;
            object-fit: cover;
            border-radius: 50%;
            border: 2px solid #ffffff; /* Borde blanco */
            box-shadow: 0 1px 3px rgba(0,0,0,0.15); /* Sombra sutil */
        }
        .user-avatar-placeholder {
            width: 50px;
            height: 50px;
            border-radius: 50%;
            background-color: #e9ecef;
            color: #6c757d;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 1.8rem; /* Tamaño del icono interior */
            border: 2px solid #ffffff;
            box-shadow: 0 1px 3px rgba(0,0,0,0.15);
        }
        /* --- FIN ESTILOS AVATAR --- */

        /* --- ESTILOS PARA NOTIFICACIONES (Sección Offcanvas) --- */
        .offcanvas-header { background-color: var(--custom-brand-purple-pale); color: var(--bs-dark); border-bottom: 1px solid #dcd6e1; }
        .offcanvas-body { padding: 0; display: flex; flex-direction: column; overflow-y: hidden; }
        .offcanvas-title { font-weight: bold; }
        .offcanvas-notifications-list { list-style: none; padding: 0; margin: 0; flex-grow: 1; overflow-y: auto; }
        .offcanvas-notifications-list li { padding: 15px 20px; border-bottom: 1px solid #eee; transition: background-color 0.15s, opacity 0.15s; }
        .offcanvas-notifications-list li:hover { background-color: #f8f9fa; }
        .offcanvas-notifications-list .notification-message { font-weight: 500; display: block; }
        .offcanvas-notifications-list .notification-time { font-size: 0.8em; color: #6c757d; margin-top: 5px; }
        .offcanvas-footer { padding: 15px 20px; border-top: 1px solid #eee; text-align: center; flex-shrink: 0; }

        /* **NUEVO:** Estilo para resaltar alertas de dolor/esfuerzo */
        .notification-alert-item {
            background-color: #fdeeee; /* Un rojo muy pálido */
        }
        .notification-alert-item:hover {
            background-color: #fbdcdd; /* Un poco más oscuro al pasar el ratón */
        }
        .notification-read {
            opacity: 0.65;
            /* background-color: #f8f9fa; */ /* Opcional: fondo grisáceo */
        }
        .notification-read .notification-message {
            font-weight: 400; /* Texto más ligero para leídas */
        }
        .notification-read .mark-read-btn {
            display: none; /* Ocultar botón 'marcar leído' si ya está leído */
        }
        .notification-actions {
            display: flex;
            flex-direction: column;
            justify-content: center;
            align-items: center;
            margin-left: 10px;
        }
        .notification-actions .btn {
            padding: 2px 5px;
            font-size: 0.8rem;
            line-height: 1;
        }
        .notification-actions .btn + .btn {
            margin-top: 5px;
        }
        /* Estilos generales del header */
        /* --- ★ MODIFICACIÓN SUBMENÚ ★ --- */
        /* Apuntar al submenú que es dropend (abrir a la derecha) */
        .dropdown-menu .dropend .dropdown-menu {
            top: 0;
            left: 100%; /* Abrir a la derecha */
            right: auto;
            margin-left: -1px;
            margin-top: -1px;
        }
        /* Estilos para el toggle (sin cambios) */
        .dropdown-menu .dropend .dropdown-toggle { color: var(--bs-dark-rgb, #212529) !important; pointer-events: auto !important; opacity: 1 !important; cursor: pointer !important; }
        .dropdown-menu .dropend .dropdown-toggle:hover { color: var(--bs-dark-rgb, #212529) !important; background-color: #e9ecef; }

        .report-brand-header { color: #684A7A; font-weight: bold; font-size: 1.5rem; }
        .user-greeting { font-size: 1.15rem; font-weight: 500; }

        #unread-messages-badge {
          top: 10px;
          right: -12px;
          font-size: 0.7em;
          width: 1.8em;
          height: 1.8em;
          padding: 0;
          display: flex; align-items: center; justify-content: center; line-height: 1;
        }
        #notificationBellLink .badge {
          top: 10px;
          right: -12px;
          font-size: 0.73em;
          width: 1.8em;
          height: 1.8em;
          padding: 0;
          display: flex; align-items: center; justify-content: center; line-height: 1;
        }
        #notificationOffcanvas { top: 60px; height: calc(100vh - 60px); }

        /* --- ★ INICIO MODIFICACIÓN: ESTILOS PARA SUPLANTACIÓN ★ --- */
        <?php if (isset($_SESSION['admin_origen_id'])): ?>

        /* --- ★ INICIO: ESTILOS PARA SUPLANTACIÓN ★ --- */

                body[data-impersonating="true"] {
                    /* Espacio total: 60px (header base) + 50px (barra suplantación) = 110px */
                    padding-top: 105px !important; /* !important para sobreescribir la regla base de 60px */
                    padding-bottom: 25px; /* Mantenemos el padding-bottom para el "CANVI RÀPID" */
                }

                .impersonation-bar {
                    background-color: #ffc107; /* Amarillo advertencia */
                    color: #000;
                    padding: 0.75rem 1rem;
                    text-align: center;
                    font-weight: bold;
                    position: fixed;
                    top: 0;
                    left: 0;
                    width: 100%;
                    z-index: 1031; /* Justo encima del header (header tiene 1030) */
                    height: 50px; /* Altura fija para la barra */
                }
                .impersonation-bar a {
                    color: #000;
                    font-weight: bold;
                    text-decoration: underline;
                }
                .impersonation-bar a:hover {
                    color: #333;
                }

                /* Ajustes de layout cuando la barra está activa */
                body[data-impersonating="true"] header.navbar {
                    top: 40px; /* Mover el header debajo de la nueva barra */
                    height: 75px;
                }
                body[data-impersonating="true"] .offcanvas#notificationOffcanvas {
                     top: 110px; /* Ajustar offcanvas (50px barra + 60px header) */
                     height: calc(100vh - 110px);
                }

                /* Ocultar acciones de widgets durante suplantación Y VISTA GLOBAL */
                body[data-impersonating="true"] .accion-suplantacion-oculta,
                body[data-global-view="true"] .accion-suplantacion-oculta {
                    display: none !important;
                }

        <?php endif; ?>

        /* --- ★ INICIO: Ocultar acciones de widgets durante suplantación Y VISTA GLOBAL ★ --- */
        /* Esta regla ahora oculta acciones en AMBOS modos (Req 1) */
        body[data-impersonating="true"] .accion-suplantacion-oculta,
        body[data-global-view="true"] .accion-suplantacion-oculta {
            display: none !important;
        }
        /* --- ★ FIN ★ --- */

        /* --- ★ INICIO: MODIFICACIÓN VISTA MÓVIL ★ --- */
        @media (max-width: 991.98px) {
            /* Orden del menú colapsado */
            .navbar-collapse {
                display: flex;
                flex-direction: column;
            }
            /* 1. Avatar primero */
            .navbar-nav.mobile-avatar {
                order: 1;
                width: 100%;
                /* margin-bottom: 0.5rem; --- ELIMINADO --- */
            }
            /* 2. Navegación principal */
            .navbar-nav.me-auto {
                order: 2;
                width: 100%;
            }
            /* 3. Iconos de Admin/PC (ocultos) */
            .navbar-nav.desktop-nav {
                order: 3;
            }
            /* 4. Logout último */
            .navbar-nav.mobile-logout {
                order: 4;
                width: 100%;
                /* margin-top: 0.5rem;  --- ELIMINADO --- */
                /* padding-top: 0.5rem; --- ELIMINADO --- */
                /* border-top: 1px solid rgba(0,0,0,0.1); */ /* ★ MODIFICACIÓN 4: Eliminado para reducir espacio */
            }

            /* Estilos para los iconos de la barra superior móvil */
            .mobile-icons-bar .nav-link {
                padding-left: 0.5rem;
                padding-right: 0.5rem;
            }
            /* Ajuste de posición de badges en móvil */
            #notification-count-badge-mobile {
                top: 10px;
                right: 0px;
                font-size: 0.6em;
                width: 1.6em;
                height: 1.6em;
            }
            #unread-messages-badge-mobile {
                top: 10px;
                right: 0px;
                font-size: 0.6em;
                width: 1.6em;
                height: 1.6em;
            }
        }
        /* --- ★ FIN: MODIFICACIÓN VISTA MÓVIL ★ --- */

        /* --- FIX SUBMENÚ BOOTSTRAP 5 --- */
        .dropdown-menu .dropend {
            position: relative;
        }

        /* El menú hijo: Oculto por defecto y posicionado a la derecha */
        .dropdown-menu .dropend .dropdown-menu {
            display: none;
            position: absolute;
            top: 0;
            left: 100%;
            margin-top: -5px;
            margin-left: 0;
            border-radius: 0.375rem;
            box-shadow: 0 0.5rem 1rem rgba(0, 0, 0, 0.15);
        }

        /* CLASE MÁGICA: Cuando JS ponga esta clase, se fuerza a mostrar */
        .dropdown-menu .dropend .dropdown-menu.show-submenu {
            display: block !important; /* Important para forzar al navegador */
        }

    </style>
</head>
<?php // --- ★ MODIFICADO: Añadir data-global-view="true" si es vista global (Req 1) --- ?>
<body <?= $is_impersonating ? 'data-impersonating="true"' : '' ?> <?= $is_global_view ? 'data-global-view="true"' : '' ?>>

<?php if (isset($_SESSION['admin_origen_id'])): ?>
    <div class="impersonation-bar">
        <i class="bi bi-exclamation-triangle-fill"></i>
        Estàs suplantant a
        <strong><?= htmlspecialchars($_SESSION['user_nombre']) ?> <?= htmlspecialchars($_SESSION['user_apellido'] ?? '') ?></strong>.

        <i class="bi bi-info-circle"
           style="cursor: help;"
           data-bs-toggle="tooltip"
           data-bs-placement="bottom"
           data-bs-html="true"
           title="<b>Mode de Suplantació:</b><br><BR>
                  <b>POTS:</b><br>
                  - Veure el panell, informes i notificacions.<br>
                  - Realitzar accions sobre medis, exercicis, protocols i tractaments com ho fa el fisio suplantat.<br>
                  <br><b class='text-danger'>NO POTS:</b><br>
                  - Enviar o veure xats (privacitat).<br>
                  - Marcar notificacions com a llegides.<br>
                  - Descartar alertes o gestionar usuaris.">
        </i>
        <a href="stop_impersonating.php" class="ms-3"><< Tornar</a>
    </div>
<?php endif; ?>
<header class="navbar navbar-expand-lg fixed-top">
    <div class="container" style="max-width: 1420px;">

        <a class="navbar-brand fw-bold" href="
            <?php // ★ MODIFICACIÓN: El enlace del logo te lleva al dashboard correcto ★
                if ($user_rol === 'paciente') {
                    echo 'patient_dashboard.php';
                } else {
                    echo 'dashboard.php';
                }
            ?>
        ">
            <i class="bi bi-heart-pulse-fill me-2" style="color: #77b9af;"></i>Avant Online
        </a>

        <div class="d-lg-none d-flex align-items-center ms-auto mobile-icons-bar">
            <?php if (in_array($user_rol, ['superadmin', 'fisio'])): ?>
                <div class="nav-item">
                    <a class="nav-link position-relative" href="#"
                       id="notificationBellLinkMobile"
                       data-bs-toggle="offcanvas"
                       data-bs-target="#notificationOffcanvas"
                       aria-controls="notificationOffcanvas"
                       title="Notificacions"
                       data-bs-backdrop="false">
                        <i class="bi bi-bell fs-4"></i>
                        <span id="notification-count-badge-mobile" class="position-absolute translate-middle badge rounded-pill bg-warning text-dark" style="display: none;">
                            <span id="notification-count-mobile"></span>
                        </span>
                    </a>
                </div>
            <?php endif; ?>
            <?php if (in_array($user_rol, ['superadmin', 'fisio']) && !$is_read_only_view): ?>
                <a class="nav-link position-relative" href="chat_inbox.php" title="Xat">
                    <i class="bi bi-chat-dots fs-4"></i>
                    <span id="unread-messages-badge-mobile" class="position-absolute translate-middle badge rounded-pill bg-danger" style="display: <?= $total_unread_messages > 0 ? 'flex' : 'none' ?>;">
                        <span id="unread-messages-count-mobile"><?= $total_unread_messages > 9 ? '9+' : $total_unread_messages ?></span>
                    </span>
                </a>
            <?php endif; ?>
        </div>
        <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#mainNavbar">
            <span class="navbar-toggler-icon"></span>
        </button>

        <div class="collapse navbar-collapse" id="mainNavbar">

            <div class="navbar-nav d-lg-none mobile-avatar">
                <a class="nav-link" href="#" data-bs-toggle="modal" data-bs-target="#profileModal" title="Dades Personals">
                    <?php if (isset($_SESSION['user_avatar']) && !empty($_SESSION['user_avatar'])): ?>
                        <img src="<?= htmlspecialchars($_SESSION['user_avatar']) ?>" alt="Avatar" class="user-avatar-icon me-2" id="header-avatar-icon-mobile" style="width:32px; height:32px; border-width: 1px;">
                    <?php else: ?>
                        <i class="bi bi-person-circle fs-4 me-2"></i>
                    <?php endif; ?>
                    Hola, <?= htmlspecialchars($_SESSION['user_nombre']) ?>
                    </a>
            </div>

            <hr class="d-lg-none my-1" style="color: rgba(0,0,0,0.5);">

            <ul class="navbar-nav me-auto mb-2 mb-lg-0">
                 <?php foreach ($nav_items as $url => $item): ?>
                    <?php if (in_array($user_rol, $item['roles'])): ?>
                        <?php
                        // ★ INICIO MODIFICACIÓN 1: Ocultar 'Anuncis' en móvil
                        $li_class = ($url === 'announcements.php') ? ' d-none d-lg-block' : '';
                        ?>
                        <li class="nav-item<?= $li_class ?>">
                        <a class="nav-link <?= ($current_page == $url) ? 'active' : '' ?>" href="<?= $url ?>">
                                <i class="bi <?= $item['icon'] ?> me-1"></i><?= $item['label'] ?>
                            </a>
                        </li>
                    <?php endif; ?>
                <?php endforeach; ?>
            </ul>

            <div class="navbar-nav ms-auto d-none d-lg-flex flex-lg-row align-items-lg-center desktop-nav">

                <?php // --- Notificaciones (Desktop) --- ?>
                <?php if (in_array($user_rol, ['superadmin', 'fisio'])): ?>
                    <div class="nav-item me-lg-2">
                        <a class="nav-link position-relative" href="#"
                           id="notificationBellLink"
                           data-bs-toggle="offcanvas"
                           data-bs-target="#notificationOffcanvas"
                           aria-controls="notificationOffcanvas"
                           title="Notificacions"
                           data-bs-backdrop="false">
                            <i class="bi bi-bell fs-5"></i>
                            <span class="d-lg-inline">Notificacions</span>
                            <span id="notification-count-badge" class="position-absolute translate-middle badge rounded-pill bg-warning text-dark" style="display: none;">
                                <span id="notification-count"></span> <span class="visually-hidden">notificacions noves</span>
                            </span>
                        </a>
                    </div>
                <?php endif; ?>


                <?php // --- Chat (Desktop) --- ?>
                <?php if (in_array($user_rol, ['superadmin', 'fisio']) && !$is_read_only_view): ?>
                    <a class="nav-link position-relative me-lg-2" href="chat_inbox.php" title="Xat">
                        <i class="bi bi-chat-dots fs-5"></i>
                        <span class="d-lg-inline">Xat</span>
                        <span id="unread-messages-badge" class="position-absolute translate-middle badge rounded-pill bg-danger" style="display: <?= $total_unread_messages > 0 ? 'flex' : 'none' ?>;">
                            <span id="unread-messages-count"><?= $total_unread_messages > 9 ? '9+' : $total_unread_messages ?></span> <span class="visually-hidden">missatges sense llegir</span>
                        </span>
                    </a>
                <?php endif; ?>


                <?php // --- Menú Desplegable (Desktop) --- ?>
                <div class="nav-item dropdown">
                    <a class="nav-link" href="#" role="button" data-bs-toggle="dropdown" aria-expanded="false" title="Menú d'usuari">
                        <i class="bi bi-list fs-2"></i> </a>

                    <ul class="dropdown-menu dropdown-menu-end">
                        <li>
                            <a class="dropdown-item d-flex align-items-center px-3 pt-2 pb-1"
                               href="#"
                               data-bs-toggle="modal"
                               data-bs-target="#profileModal"
                               title="Dades Personals:"
                               style="cursor: pointer;">

                                <?php if (isset($_SESSION['user_avatar']) && !empty($_SESSION['user_avatar'])): ?>
                                    <img src="<?= htmlspecialchars($_SESSION['user_avatar']) ?>" alt="Avatar" class="user-avatar-icon me-2" id="header-avatar-icon" style="width:40px; height:40px;">
                                <?php else: ?>
                                    <div class="user-avatar-placeholder me-2" id="header-avatar-icon" style="width:40px; height:40px; font-size: 1.5rem;">
                                        <i class="bi bi-person-circle"></i>
                                    </div>
                                <?php endif; ?>
                                <span class="user-greeting">Hola, <?= htmlspecialchars($_SESSION['user_nombre']) ?></span>
                            </a>
                        </li>
                        <li><hr class="dropdown-divider mt-1"></li>

                        <?php if (in_array($user_rol, ['superadmin', 'fisio'])): ?>

                            <?php if ($user_rol === 'superadmin' && !isset($_SESSION['admin_origen_id'])): ?>
                                <li>
                                    <a class="dropdown-item" href="#" data-bs-toggle="modal" data-bs-target="#adminModal">
                                        <i class="bi bi-shield-lock me-2"></i>Administració
                                    </a>
                                </li>
                            <?php endif; ?>

                            <li class="dropend">
                              <a class="dropdown-item dropdown-toggle" href="#" id="submenu-trigger" role="button" aria-expanded="false">
                                  <i class="bi bi-file-earmark-bar-graph me-2"></i>Informes Estàndard
                              </a>
                                <ul class="dropdown-menu">
                                    <?php if ($user_rol === 'superadmin'): ?>
                                        <li><a class="dropdown-item" href="reports/dashboard_report.php<?= $return_param ?>">Informe General</a></li>
                                        <li><a class="dropdown-item" href="reports/gallery_report.php<?= $return_param ?>">Informe de Medis</a></li>
                                        <li><a class="dropdown-item" href="reports/taxonomy_report.php<?= $return_param ?>">Informe de Categories</a></li>
                                        <li><a class="dropdown-item" href="reports/exercises_report.php<?= $return_param ?>">Informe d'Exercicis</a></li>
                                        <li><a class="dropdown-item" href="reports/protocols_report.php<?= $return_param ?>">Informe de Protocols</a></li>
                                        <li><a class="dropdown-item" href="reports/treatments_report.php<?= $return_param ?>">Informe de Tractaments</a></li>
                                    <?php elseif ($user_rol === 'fisio'): ?>
                                        <li><a class="dropdown-item" href="reports/fisio_report.php<?= $return_param ?>">Informe de Pacients</a></li>
                                        <li><a class="dropdown-item" href="reports/gallery_report.php<?= $return_param ?>">Informe de Medis</a></li>
                                        <li><a class="dropdown-item" href="reports/exercises_report.php<?= $return_param ?>">Informe d'Exercicis</a></li>
                                        <li><a class="dropdown-item" href="reports/protocols_report.php<?= $return_param ?>">Informe de Protocols</a></li>
                                        <li><a class="dropdown-item" href="reports/treatments_report.php<?= $return_param ?>">Informe de Tractaments</a></li>
                                    <?php endif; ?>
                                </ul>
                            </li>
                            <li>
                                <a class="dropdown-item" href="reports/smart_report.php<?= $return_param ?>">
                                    <i class="bi bi-clipboard-data me-2"></i>Informe Intel·ligent
                                </a>
                            </li>

                        <?php endif; ?>
                        <li><hr class="dropdown-divider"></li>
                        <li>
                            <a class="dropdown-item" href="help/help_fisios_admin.html" target="_blank">
                                <i class="bi bi-life-preserver me-2"></i>Ajuda
                            </a>
                        </li>

                        <?php if (!isset($_SESSION['admin_origen_id'])): ?>
                        <li><hr class="dropdown-divider"></li>
                        <li><a class="dropdown-item" href="logout.php"><i class="bi bi-box-arrow-right me-2"></i>Tancar Sessió</a></li>
                        <?php endif; ?>

                    </ul>
                </div>
            </div>

            <div class="navbar-nav d-lg-none mobile-logout">
                <?php if (!isset($_SESSION['admin_origen_id'])): ?>
                <a class="nav-link" href="logout.php" title="Tancar Sessió">
                    <i class="bi bi-box-arrow-right fs-4 me-2"></i>
                    Tancar Sessió
                </a>
                <?php endif; ?>
            </div>
            </div>
    </div>
</header>

<?php // ===== INICIO DE LA MODIFICACIÓN: Modal de Confirmación movido de footer.php ===== ?>
<?php // Este modal es necesario para que la función showConfirmModal() del script de notificaciones funcione. ?>
<?php if (in_array($user_rol, ['superadmin', 'fisio'])): ?>
    <div class="modal fade" id="confirmationModal" tabindex="-1">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="confirmationModalLabel">Confirmar Acció</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body" id="confirmationModalBody">
                    <p>Estàs segur/a que vols realitzar aquesta acció?</p>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel·lar</button>
                    <button type="button" class="btn btn-primary" id="confirmActionButton">Confirmar</button>
                </div>
            </div>
        </div>
    </div>
<?php endif; ?>
<?php // ===== FIN DE LA MODIFICACIÓN ===== ?>


<?php // --- ★ INICIO: OCULTAR OFFCANVAS Y JS SI ES VISTA LECTURA ★ --- ?>
<?php // ★ MODIFICADO: Mostrar siempre para fisio/admin (Req 2) ?>
<?php if (in_array($user_rol, ['superadmin', 'fisio'])): ?>

<div class="offcanvas offcanvas-end" tabindex="-1" id="notificationOffcanvas" aria-labelledby="notificationOffcanvasLabel" data-bs-backdrop="false">
  <div class="offcanvas-header">
    <h5 class="offcanvas-title" id="notificationOffcanvasLabel">Centre de Notificacions</h5>
    <button type="button" class="btn-close text-reset" data-bs-dismiss="offcanvas" aria-label="Close" style="color: inherit;"></button>
  </div>
  <div class="offcanvas-body">

    <div class="p-3 border-bottom bg-light">
        <div class="btn-group w-100" role="group" aria-label="Filtres de notificacions">
            <button type="button" class="btn btn-sm btn-primary" id="notif-filter-unread">
                <i class="bi bi-eye-slash-fill me-1"></i> No Llegides
            </button>
            <button type="button" class="btn btn-sm btn-outline-secondary" id="notif-filter-read">
                <i class="bi bi-eye-fill me-1"></i> Llegides
            </button>
            <button type="button" class="btn btn-sm btn-outline-secondary" id="notif-filter-all">
                <i class="bi bi-archive-fill me-1"></i> Totes
            </button>
        </div>
    </div>

    <div class="d-flex justify-content-between align-items-center p-3 border-bottom">
        <h6 class="mb-0 text-muted small">
            <span id="offcanvas-unread-count-label">0</span> No Llegides
        </h6>
        <button type="button" class="btn btn-sm btn-outline-primary" id="offcanvasMainActionBtn" title="Marcar totes com a llegides">
            <i class="bi bi-check-all"></i> Marcar totes com a llegides
        </button>
    </div>

    <ul class="offcanvas-notifications-list" id="offcanvas-notification-list-container">
      <li class="text-center text-muted p-4" id="offcanvas-loading-message">Carregant notificacions...</li>
    </ul>

    <div class="offcanvas-footer">
        <p class="text-muted small mb-1">
            Les notificacions llegides s'eliminen automàticament als 30 dies.
        </p>
        <a href="#" class="text-muted small">Veure l'historial complet</a>
    </div>

  </div>
</div>
<script>
// Usamos DOMContentLoaded en lugar de $(document).ready() porque jQuery y Bootstrap JS se cargarán desde footer.php
// ¡¡¡CAMBIO DE VUELTA!!! El script DEBE ejecutarse DESPUÉS de que se cargue jQuery.
// Si jQuery se carga en el footer, este script debe ir en el footer o usar $(document).ready()
// Dado que este script está en header.php, volvemos a $(document).ready()
// y asumimos que el footer cargará jQuery antes de que esto sea necesario,
// PERO el script de notificaciones SÍ necesita DOMContentLoaded. Es un lío.

// SOLUCIÓN: El script de notificaciones debe esperar a que el DOM esté listo.
// El JS de Bootstrap (dropdowns) esperará al footer.
document.addEventListener('DOMContentLoaded', function() {

  // --- ★ FIX DEFINITIVO SUBMENÚ ★ ---
      const submenuTrigger = document.getElementById('submenu-trigger');

      if (submenuTrigger) {
          submenuTrigger.addEventListener('click', function(e) {
              // 1. Detener todo lo que Bootstrap intenta hacer
              e.preventDefault();
              e.stopPropagation();

              // 2. Buscar el menú hermano (el <ul> siguiente)
              const submenu = this.nextElementSibling;

              if (submenu) {
                  // 3. Alternar nuestra clase personalizada 'show-submenu'
                  // Usamos una clase propia para que Bootstrap no se confunda
                  if (submenu.classList.contains('show-submenu')) {
                      submenu.classList.remove('show-submenu');
                  } else {
                      submenu.classList.add('show-submenu');
                  }
              }
          });
      }

      // Cerrar el submenú si hacemos clic fuera (opcional pero recomendado)
      document.addEventListener('click', function(e) {
          // Si el clic NO fue dentro del submenú o en el trigger...
          if (!e.target.closest('.dropend')) {
              document.querySelectorAll('.show-submenu').forEach(el => el.classList.remove('show-submenu'));
          }
      });
      // --- ★ FIN FIX ★ ---

    // ===== INICIO MODIFICACIÓN (Detectar Suplantación Y VISTA GLOBAL) =====
    const isImpersonating = document.body.dataset.impersonating === 'true';
    const isGlobalView = document.body.dataset.globalView === 'true';
    const isReadOnlyView = isImpersonating || isGlobalView; // ★ Variable JS combinada
    // ===== FIN MODIFICACIÓN =====

    // --- INICIO: Helper para modal de confirmación ---
    // Reemplazo global para window.confirm()
    function showConfirmModal(message, confirmText = 'Confirmar', title = 'Confirmar Acció', confirmBtnClass = 'btn-primary', callbackOnConfirm) {
        // Usamos el modal de confirmationModal (definido en ESTE ARCHIVO, header.php)
        const confirmationModalEl = document.getElementById('confirmationModal');
        if (!confirmationModalEl) {
            console.error('Modal de confirmación no encontrado. La acción no se puede confirmar.');
            // NO ejecutar el callback si no se puede confirmar
            return;
        }

        // --- ★★★ INICIO DE LA MODIFICACIÓN (FIX MODAL) ★★★ ---
        // Necesitamos asegurarnos de que tenemos una instancia de Modal JS de Bootstrap
        // que SÍ está cargada (desde el footer)
        const confirmationModal = bootstrap.Modal.getOrCreateInstance(confirmationModalEl);
        // --- ★★★ FIN DE LA MODIFICACIÓN (FIX MODAL) ★★★ ---

        const modalTitle = confirmationModalEl.querySelector('.modal-title');
        const modalBody = confirmationModalEl.querySelector('.modal-body');
        const confirmBtn = confirmationModalEl.querySelector('#confirmActionButton');


        if(modalTitle) modalTitle.textContent = title;
        if(modalBody) modalBody.innerHTML = `<p>${message}</p>`; // Asignar el mensaje
        if(confirmBtn) {
            confirmBtn.textContent = confirmText;
            // Resetear clases y añadir la nueva
            confirmBtn.className = 'btn';
            confirmBtn.classList.add(confirmBtnClass.replace('btn ', '')); // Asegurar que solo es la clase
            confirmBtn.id = 'confirmActionButton'; // Asegurar que el ID persiste
        }

        // Clonar el botón para limpiar listeners de clics anteriores
        const newConfirmBtn = confirmBtn.cloneNode(true);
        confirmBtn.parentNode.replaceChild(newConfirmBtn, confirmBtn);

        // Crear un controlador de clic de un solo uso
        const onConfirmClick = () => {
            callbackOnConfirm(); // Ejecutar la acción
            confirmationModal.hide(); // Ocultar el modal
        };

        // Añadir el listener
        newConfirmBtn.addEventListener('click', onConfirmClick, { once: true });

        // Mostrar el modal
        confirmationModal.show();
    }
    // --- FIN: Helper para modal de confirmación ---


    // --- JS UTILITIES (SIN CAMBIOS) ---
    function formatRelativeTime(dateString) {
        if (!dateString) return '';
        try {
            // Asumimos que la fecha viene en UTC, la convertimos a local para mostrar
            const dateUTC = new Date(dateString.replace(' ', 'T') + 'Z'); // Añadir Z para indicar UTC
            if (isNaN(dateUTC)) return dateString;

            const now = new Date();
            const seconds = Math.round((now - dateUTC) / 1000);
            const minutes = Math.round(seconds / 60);
            const hours = Math.round(minutes / 60);
            const days = Math.round(hours / 24);

            if (seconds < 60) return `fa menys d'1 min`;
            if (minutes === 1) return `fa 1 min`;
            if (minutes < 60) return `fa ${minutes} min`;
            if (hours === 1) return `fa 1 h`;
            if (hours < 24) return `fa ${hours} h`;
            if (days === 1) return `ahir`;
            if (days < 7) return `fa ${days} dies`;
            // Si es más antiguo, mostrar fecha local simple
            return dateUTC.toLocaleDateString('ca-ES', { day: 'numeric', month: 'short' });

        } catch(e) {
            return dateString; // Fallback
        }
    }

    function getNotificationIcon(tipoEvento) {
        switch(tipoEvento) {
            case 'ALERTA_DOLOR': return 'bi bi-exclamation-octagon-fill text-danger';
            case 'ALERTA_ESFUERZO': return 'bi bi-exclamation-triangle-fill text-warning';
            case 'NUEVO_COMENTARIO': return 'bi bi-chat-dots-fill text-info';
            case 'FIN_TRATAMIENTO_PROX': return 'bi bi-calendar-x-fill text-warning';
            case 'NUEVA_ASIGNACION_TRAT': return 'bi bi-person-badge-fill text-success';
            default: return 'bi bi-info-circle-fill text-secondary';
        }
    }
    // --- END JS UTILITIES ---

    const currentUserRol = '<?= $user_rol ?? '' ?>';
    if (currentUserRol !== 'superadmin' && currentUserRol !== 'fisio') {
        return; // Salir si no es rol adecuado (la lógica de notif no es necesaria)
    }

    let currentFilter = 'unread'; // 'unread', 'read', 'all'

    // --- ★★★ INICIO MODIFICACIÓN (Selectores Múltiples) ★★★ ---
    // Selectores de elementos
    const notificationCountBadge = document.getElementById('notification-count-badge');
    const notificationCountSpan = document.getElementById('notification-count');
    const notificationCountBadgeMobile = document.getElementById('notification-count-badge-mobile'); // NUEVO
    const notificationCountSpanMobile = document.getElementById('notification-count-mobile'); // NUEVO

    const offcanvasContainer = document.getElementById('notificationOffcanvas');
    const offcanvasListContainer = document.getElementById('offcanvas-notification-list-container');
    const offcanvasUnreadCountLabel = document.getElementById('offcanvas-unread-count-label');
    const offcanvasMainActionBtn = document.getElementById('offcanvasMainActionBtn'); // MODIFICADO
    const filterBtnUnread = document.getElementById('notif-filter-unread');
    const filterBtnRead = document.getElementById('notif-filter-read'); // NUEVO
    const filterBtnAll = document.getElementById('notif-filter-all');
    // --- ★★★ FIN MODIFICACIÓN (Selectores Múltiples) ★★★ ---

    /**
     * MODIFICADO: Busca notificaciones según el filtro (3 estados)
     */
    function fetchNotifications(filter = currentFilter) {
        currentFilter = filter; // Actualizar estado global

        // Actualizar estado activo de botones de filtro
        if (filterBtnUnread && filterBtnRead && filterBtnAll) {
            // Reset all to secondary
            filterBtnUnread.classList.replace('btn-primary', 'btn-outline-secondary');
            filterBtnRead.classList.replace('btn-primary', 'btn-outline-secondary');
            filterBtnAll.classList.replace('btn-primary', 'btn-outline-secondary');

            // Set active one to primary
            if (filter === 'unread') {
                filterBtnUnread.classList.replace('btn-outline-secondary', 'btn-primary');
            } else if (filter === 'read') {
                filterBtnRead.classList.replace('btn-outline-secondary', 'btn-primary');
            } else {
                filterBtnAll.classList.replace('btn-outline-secondary', 'btn-primary');
            }
        }

        // Llamar a la nueva acción de la API
        fetch(`notifications_ajax.php?action=get_notifications&filter=${filter}`)
            .then(response => {
                if (!response.ok) { throw new Error(`HTTP error! status: ${response.status}`); }
                return response.json();
             })
            .then(data => {
                if (data.status === 'success') {
                    // data.count es SIEMPRE el recuento de no leídas
                    // data.notifications es la lista filtrada
                    updateNotificationUI(data.notifications, data.count);
                } else {
                    console.error('Error fetching notifications (API):', data.message);
                    if(offcanvasListContainer) offcanvasListContainer.innerHTML = '<li class="text-danger p-4">Error al carregar.</li>';
                    // --- ★★★ INICIO MODIFICACIÓN (Ocultar Badges) ★★★ ---
                    if(notificationCountBadge) notificationCountBadge.style.display = 'none';
                    if(notificationCountBadgeMobile) notificationCountBadgeMobile.style.display = 'none'; // NUEVO
                    // --- ★★★ FIN MODIFICACIÓN (Ocultar Badges) ★★★ ---
                }
            })
            .catch(error => {
                console.error('Error fetching notifications (Network/JS):', error);
                 if(offcanvasListContainer) offcanvasListContainer.innerHTML = '<li class="text-danger p-4">Error de connexió.</li>';
                 // --- ★★★ INICIO MODIFICACIÓN (Ocultar Badges) ★★★ ---
                 if(notificationCountBadge) notificationCountBadge.style.display = 'none';
                 if(notificationCountBadgeMobile) notificationCountBadgeMobile.style.display = 'none'; // NUEVO
                 // --- ★★★ FIN MODIFICACIÓN (Ocultar Badges) ★★★ ---
            });
    }

    /**
     * MODIFICADO: Renderiza la lista y actualiza el botón de acción
     */
    function updateNotificationUI(notifications, unreadCount) {
        // --- ★★★ INICIO MODIFICACIÓN (Selectores Múltiples) ★★★ ---
        if (!offcanvasListContainer || !offcanvasUnreadCountLabel || !offcanvasMainActionBtn) return;

        // 1. Actualizar badge global (siempre con no leídas)
        const unreadDisplay = unreadCount > 9 ? '9+' : unreadCount;
        const displayStyle = unreadCount > 0 ? 'flex' : 'none';

        if (notificationCountBadge && notificationCountSpan) {
            notificationCountSpan.textContent = unreadDisplay;
            notificationCountBadge.style.display = displayStyle;
        }
        if (notificationCountBadgeMobile && notificationCountSpanMobile) { // NUEVO
            notificationCountSpanMobile.textContent = unreadDisplay;
            notificationCountBadgeMobile.style.display = displayStyle;
        }
        // --- ★★★ FIN MODIFICACIÓN (Selectores Múltiples) ★★★ ---

        // 2. Actualizar contador en offcanvas (siempre con no leídas)
        offcanvasUnreadCountLabel.textContent = unreadCount;

        // 3. MODIFICADO: Actualizar botón de acción principal según el filtro
        switch (currentFilter) {
            case 'unread':
                offcanvasMainActionBtn.innerHTML = '<i class="bi bi-check-all"></i> Marcar totes com a llegides';
                offcanvasMainActionBtn.title = 'Marcar totes com a llegides';
                offcanvasMainActionBtn.className = 'btn btn-sm btn-outline-primary';
                offcanvasMainActionBtn.disabled = (unreadCount === 0);
                break;
            case 'read':
                offcanvasMainActionBtn.innerHTML = '<i class="bi bi-trash"></i> Eliminar totes';
                offcanvasMainActionBtn.title = 'Eliminar totes les notificacions llegides';
                offcanvasMainActionBtn.className = 'btn btn-sm btn-outline-danger';
                // Deshabilitar si la lista de *leídas* está vacía
                offcanvasMainActionBtn.disabled = (notifications.length === 0);
                break;
            case 'all':
                // En 'Totes', la acción por defecto es marcar las no leídas
                offcanvasMainActionBtn.innerHTML = '<i class="bi bi-check-all"></i> Marcar totes com a llegides';
                offcanvasMainActionBtn.title = 'Marcar totes com a llegides';
                offcanvasMainActionBtn.className = 'btn btn-sm btn-outline-primary';
                offcanvasMainActionBtn.disabled = (unreadCount === 0);
                break;
        }

        // ===== INICIO MODIFICACIÓN (Ocultar botones si es vista solo-lectura) =====
        if (isReadOnlyView) {
            offcanvasMainActionBtn.style.display = 'none';
        }
        // ===== FIN MODIFICACIÓN =====

        // 4. Limpiar y renderizar lista
        offcanvasListContainer.innerHTML = '';

        if (notifications.length > 0) {
            notifications.forEach(notif => {
                let iconClass = getNotificationIcon(notif.tipo_evento);
                const li = document.createElement('li');
                const isRead = notif.leido_en !== null;

                // Añadir clases CSS condicionales
                if (isRead) {
                    li.classList.add('notification-read');
                }
                if (notif.tipo_evento === 'ALERTA_DOLOR' || notif.tipo_evento === 'ALERTA_ESFUERZO') {
                    li.classList.add('notification-alert-item');
                }

                // ===== INICIO MODIFICACIÓN (Ocultar botones si es vista solo-lectura) =====
                const buttonsHtml = isReadOnlyView ? '' : `
                    <div class="notification-actions">
                        <button type="button" class="btn btn-sm btn-outline-primary mark-read-btn" data-id="${notif.id}" title="Marcar com a llegit">
                            <i class="bi bi-check-lg"></i>
                        </button>
                        <button type="button" class="btn btn-sm btn-outline-danger delete-permanently-btn" data-id="${notif.id}" title="Eliminar permanentment">
                            <i class="bi bi-trash"></i>
                        </button>
                    </div>
                `;
                // ===== FIN MODIFICACIÓN =====

                li.innerHTML = `
                    <div class="d-flex align-items-start">
                        <i class="${iconClass} fs-5 me-3" style="padding-top: 5px;"></i>
                        <a href="${notif.url_destino || '#!'}" class="text-decoration-none text-dark flex-grow-1 notification-link" data-id="${notif.id}">
                            <span class="notification-message">${notif.mensaje}</span>
                            <span class="notification-time">${formatRelativeTime(notif.fecha_creacion)}</span>
                        </a>
                        ${buttonsHtml}
                    </div>
                `;

                // Listener para el enlace (marca como leído, no actualiza UI, permite navegar)
                li.querySelector('.notification-link').addEventListener('click', function(e) {
                    if (!isRead && !isReadOnlyView) { // <-- MODIFICADO
                        markNotificationAsRead(notif.id, false); // false = sin actualización optimista
                    }
                });

                // ===== INICIO MODIFICACIÓN (Solo añadir listeners si no es vista solo-lectura) =====
                if (!isReadOnlyView) {
                    // Listener para el botón "Marcar Leído"
                    const markReadBtn = li.querySelector('.mark-read-btn');
                    if (markReadBtn) {
                        markReadBtn.addEventListener('click', function(e) {
                            e.preventDefault(); e.stopPropagation();
                            markNotificationAsRead(notif.id, true); // true = con actualización optimista
                        });
                    }

                    // Listener para el botón "Eliminar Permanentemente"
                    const deleteBtn = li.querySelector('.delete-permanently-btn');
                    if (deleteBtn) {
                        deleteBtn.addEventListener('click', function(e) {
                            e.preventDefault(); e.stopPropagation();
                            permanentlyDeleteNotification(notif.id);
                        });
                    }
                }
                // ===== FIN MODIFICACIÓN =====

                offcanvasListContainer.appendChild(li);
            });
        } else {
            // Mensaje de lista vacía según el filtro
            if (currentFilter === 'unread') {
                 offcanvasListContainer.innerHTML = '<li class="text-center text-muted p-4">No hi ha notificacions sense llegir.</li>';
            } else if (currentFilter === 'read') {
                 offcanvasListContainer.innerHTML = '<li class="text-center text-muted p-4">No hi ha notificacions llegides.</li>';
            } else {
                 offcanvasListContainer.innerHTML = '<li class="text-center text-muted p-4">No es van trobar notificacions.</li>';
            }
        }
    }

    /** MODIFICADO: Marca una notificación como leída*/
    function markNotificationAsRead(notificationId, updateUIOptimistically = true) {
        // ===== INICIO MODIFICACIÓN (Bloqueo por vista solo-lectura) =====
        if (isReadOnlyView) return;
        // ===== FIN MODIFICACIÓN =====

        // --- INICIO DE LA MODIFICACIÓN (REEMPLAZO DE CONFIRM) ---
        // 1. Definir la lógica de lo que sucede al confirmar
        const proceed = () => {
            // --- 1. Actualización Optimista de la UI (si se solicita) ---
            if (updateUIOptimistically) {
                const element = document.querySelector(`.mark-read-btn[data-id="${notificationId}"]`)?.closest('li');
                let wasUnread = element && !element.classList.contains('notification-read');

                if (element) {
                    // En vista "No Llegides" o "Llegides", la eliminamos
                    if (currentFilter === 'unread' || currentFilter === 'read') {
                        element.remove();
                    } else {
                        // En vista "Totes", la atenuamos
                        element.classList.add('notification-read');
                    }
                }

                // Actualizar contadores SOLO SI estaba no leída
                if (wasUnread) {
                    updateUnreadCountsOptimistically(-1);
                }

                // Comprobar si la lista ha quedado vacía
                const listContainer = document.getElementById('offcanvas-notification-list-container');
                if (listContainer && listContainer.children.length === 0) {
                    if (currentFilter === 'unread') {
                        listContainer.innerHTML = '<li class="text-center text-muted p-4">No hi ha notificacions sense llegir.</li>';
                    } else if (currentFilter === 'read') {
                        listContainer.innerHTML = '<li class="text-center text-muted p-4">No hi ha notificacions llegides.</li>';
                    }
                }
            }

            // --- 2. Llamada al Servidor ---
            fetch('notifications_ajax.php?action=delete_notification', {
                method: 'POST',
                headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
                body: `id=${notificationId}`
            })
            .then(response => response.json())
            .then(data => {
                if (data.status === 'success') {
                    console.log(`Notificació ${notificationId} marcada com a llegida.`);
                } else {
                    console.error('Error marking as read (API):', data.message);
                    if (updateUIOptimistically && typeof showToast === 'function') showToast('Error en marcar com a llegit.', 'danger');
                    if (updateUIOptimistically) fetchNotifications(currentFilter); // Revertir
                }
            })
            .catch(error => {
                    console.error('Error marking as read (Network/JS):', error);
                    if (updateUIOptimistically && typeof showToast === 'function') showToast('Error de connexió. Restaurant...', 'danger');
                    if (updateUIOptimistically) fetchNotifications(currentFilter); // Revertir
            });
        };

        // 2. Mostrar el modal de confirmación personalizado
        showConfirmModal(
            "¿Segur que voleu marcar aquesta notificació com a llegida?",
            "Confirmar",
            "Confirmar Acció",
            "btn-primary",
            proceed // Pasar la función 'proceed' como callback
        );
        // --- FIN DE LA MODIFICACIÓN ---
    }


    /**
     * MODIFICADO: Elimina permanentemente una notificación
     */
    function permanentlyDeleteNotification(notificationId) {
        // ===== INICIO MODIFICACIÓN (Bloqueo por vista solo-lectura) =====
        if (isReadOnlyView) return;
        // ===== FIN MODIFICACIÓN =====

        // --- INICIO DE LA MODIFICACIÓN (REEMPLAZO DE CONFIRM) ---
        showConfirmModal(
            'Estàs segur/a que vols ELIMINAR PERMANENTMENT aquesta notificació? Aquesta acció no es pot desfer.',
            'Eliminar',
            'Confirmar Eliminació',
            'btn-danger',
            () => { // Callback
                // --- Lógica original (dentro del callback) ---
                const elementToRemove = document.querySelector(`.delete-permanently-btn[data-id="${notificationId}"]`)?.closest('li');
                let wasUnread = false;

                if (elementToRemove) {
                    if (!elementToRemove.classList.contains('notification-read')) {
                        wasUnread = true;
                    }
                    elementToRemove.remove();
                }

                if (wasUnread) {
                    updateUnreadCountsOptimistically(-1);
                }

                const listContainer = document.getElementById('offcanvas-notification-list-container');
                if (listContainer && listContainer.children.length === 0) {
                    if (currentFilter === 'unread') {
                        listContainer.innerHTML = '<li class="text-center text-muted p-4">No hi ha notificacions sense llegir.</li>';
                    } else if (currentFilter === 'read') {
                        listContainer.innerHTML = '<li class="text-center text-muted p-4">No hi ha notificacions llegides.</li>';
                    } else {
                        listContainer.innerHTML = '<li class="text-center text-muted p-4">No es van trobar notificacions.</li>';
                    }
                }

                fetch('notifications_ajax.php?action=permanently_delete_notification', {
                    method: 'POST',
                    headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
                    body: `id=${notificationId}`
                })
                .then(response => response.json())
                .then(data => {
                    if (data.status === 'success') {
                        console.log(`Notificació ${notificationId} eliminada permanentment.`);
                        if (typeof showToast === 'function') showToast('Notifició eliminada.', 'success');
                    } else {
                        console.error('Error deleting permanently (API):', data.message);
                        if (typeof showToast === 'function') showToast('Error en eliminar. Restaurant...', 'danger');
                        fetchNotifications(currentFilter); // Revertir
                    }
                })
                .catch(error => {
                    console.error('Error deleting permanently (Network/JS):', error);
                    if (typeof showToast === 'function') showToast('Error de connexió. Restaurant...', 'danger');
                    fetchNotifications(currentFilter); // Revertir
                });
                // --- Fin lógica original ---
            }
        );
        // --- FIN DE LA MODIFICACIÓN ---
    }


    /**
     * MODIFICADO: Nombre de función y confirmación
     * (Antes se llamaba deleteAllUnreadNotifications)
     */
    function markAllAsRead() {
        // ===== INICIO MODIFICACIÓN (Bloqueo por vista solo-lectura) =====
        if (isReadOnlyView) return;
        // ===== FIN MODIFICACIÓN =====

        if (!offcanvasUnreadCountLabel || offcanvasUnreadCountLabel.textContent === '0') return;

        // --- INICIO DE LA MODIFICACIÓN (REEMPLAZO DE CONFIRM) ---
        showConfirmModal(
            'Estàs segur/a que vols marcar TOTES les notificacions no llegides com a llegides?',
            'Confirmar',
            'Confirmar Acció',
            'btn-primary',
            () => { // Callback
                // --- Lógica original (dentro del callback) ---
                fetch('notifications_ajax.php?action=delete_all_unread', { method: 'POST' })
                .then(response => response.json())
                .then(data => {
                    if (data.status === 'success') {
                        fetchNotifications(currentFilter); // Refrescar la vista actual
                        console.log(data.message);
                        if (typeof showToast === 'function') showToast('Totes les notificacions marcades com a llegides.', 'success');
                    } else {
                        console.error('Error marking all as read:', data.message);
                        if (typeof showToast === 'function') showToast('Error en marcar totes les notificacions.', 'danger');
                    }
                })
                .catch(error => {
                    console.error('Error marking all as read (Network/JS):', error);
                    if (typeof showToast === 'function') showToast('Error de connexió en marcar totes.', 'danger');
                });
                // --- Fin lógica original ---
            }
        );
        // --- FIN DE LA MODIFICACIÓN ---
    }

    /**
     * NUEVO: Elimina todas las notificacions LEÍDAS
     */
    function deleteAllRead() {
        // ===== INICIO MODIFICACIÓN (Bloqueo por vista solo-lectura) =====
        if (isReadOnlyView) return;
        // ===== FIN MODIFICACIÓN =====

        // --- INICIO DE LA MODIFICACIÓN (REEMPLAZO DE CONFIRM) ---
        showConfirmModal(
            'Estàs segur/a que vols ELIMINAR PERMANENTMENT totes les notificacions LLEGIDES? Aquesta acción no es pot desfer.',
            'Eliminar',
            'Confirmar Eliminació',
            'btn-danger',
            () => { // Callback
                 // --- Lógica original (dentro del callback) ---
                 fetch('notifications_ajax.php?action=delete_all_read', { method: 'POST' })
                    .then(response => response.json())
                    .then(data => {
                        if (data.status === 'success') {
                            fetchNotifications(currentFilter); // Refrescar la vista actual
                            console.log(data.message);
                            if (typeof showToast === 'function') showToast('Totes les notificacions llegides han sigut eliminades.', 'success');
                        } else {
                            console.error('Error deleting all read:', data.message);
                            if (typeof showToast === 'function') showToast('Error en eliminar totes les notificacions llegides.', 'danger');
                        }
                    })
                    .catch(error => {
                        console.error('Error deleting all read (Network/JS):', error);
                        if (typeof showToast === 'function') showToast('Error de connexió en eliminar totes les llegides.', 'danger');
                    });
                 // --- Fin lógica original ---
            }
         );
         // --- FIN DE LA MODIFICACIÓN ---
    }

    /**
     * MODIFICADO: Helper para actualizar contadores (Desktop y Móvil)
     */
    function updateUnreadCountsOptimistically(changeAmount) {
        // --- ★★★ INICIO MODIFICACIÓN (Selectores Múltiples) ★★★ ---
        if (!offcanvasUnreadCountLabel) return;

        let currentCount = parseInt(offcanvasUnreadCountLabel.textContent || '0', 10);
        if (currentCount > 0 || (currentCount === 0 && changeAmount > 0)) {
            const newCount = Math.max(0, currentCount + changeAmount);
            const newCountDisplay = newCount > 9 ? '9+' : newCount;
            const newDisplayStyle = newCount > 0 ? 'flex' : 'none';

            offcanvasUnreadCountLabel.textContent = newCount;

            if (notificationCountSpan && notificationCountBadge) {
                notificationCountSpan.textContent = newCountDisplay;
                notificationCountBadge.style.display = newDisplayStyle;
            }
            if (notificationCountSpanMobile && notificationCountBadgeMobile) { // NUEVO
                notificationCountSpanMobile.textContent = newCountDisplay;
                notificationCountBadgeMobile.style.display = newDisplayStyle;
            }

            if (newCount === 0) {
                if(currentFilter !== 'read') offcanvasMainActionBtn.disabled = true; // Deshabilitar si no estamos en 'read'
            } else {
                 if (currentFilter !== 'read') { // Habilitar si no estamos en 'read'
                    offcanvasMainActionBtn.disabled = false;
                 }
            }
        }
        // --- ★★★ FIN MODIFICACIÓN (Selectores Múltiples) ★★★ ---
    }

    // --- Event Listeners (MODIFICADOS) ---
    if(offcanvasContainer) {
        offcanvasContainer.addEventListener('show.bs.offcanvas', () => {
            if(offcanvasListContainer) offcanvasListContainer.innerHTML = '<li class="text-center text-muted p-4" id="offcanvas-loading-message">Carregant notificacions...</li>';
            fetchNotifications(currentFilter); // Cargar con el filtro actual
        });
    }

    // MODIFICADO: Listener para el botón de acción principal
    if (offcanvasMainActionBtn) {
        offcanvasMainActionBtn.addEventListener('click', function(e) {
            e.preventDefault();
            // ===== INICIO MODIFICACIÓN (Bloqueo por vista solo-lectura) =====
            if (isReadOnlyView) return;
            // ===== FIN MODIFICACIÓN =====

            if (currentFilter === 'read') {
                deleteAllRead(); // Nueva acción
            } else {
                // Filtro 'unread' o 'all'
                markAllAsRead(); // Antigua acción (nombre actualizado)
            }
        });
    }

    // Listeners para botones de filtro
    if (filterBtnUnread) {
        filterBtnUnread.addEventListener('click', () => {
            if (currentFilter !== 'unread') {
                fetchNotifications('unread');
            }
        });
    }
    // NUEVO
    if (filterBtnRead) {
        filterBtnRead.addEventListener('click', () => {
            if (currentFilter !== 'read') {
                fetchNotifications('read');
            }
        });
    }
    if (filterBtnAll) {
        filterBtnAll.addEventListener('click', () => {
            if (currentFilter !== 'all') {
                fetchNotifications('all');
            }
        });
    }

    // Carga inicial (cargará 'unread' por defecto)
    fetchNotifications();
    setInterval(fetchNotifications, 60000); // Recargar cada 60 segundos (mantendrá el filtro)

    // --- Asegúrate de inicializar los tooltips ---
    // (Bootstrap JS se cargará desde el footer, pero el DOM está listo)
    // Para que los tooltips funcionen, necesitan que jQuery y Bootstrap JS se hayan cargado.
    // Los inicializamos aquí, y si footer.php los carga, se re-inicializarán (lo cual está bien).
    // O mejor, esperamos a que jQuery esté listo si existe.
    if (typeof $ !== 'undefined') {
        const tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'))
        const tooltipList = tooltipTriggerList.map(function (tooltipTriggerEl) {
          return new bootstrap.Tooltip(tooltipTriggerEl)
        })
    } else {
        // Si jQuery no está (improbable), esperamos al evento load
        window.addEventListener('load', () => {
            const tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'))
            const tooltipList = tooltipTriggerList.map(function (tooltipTriggerEl) {
              return new bootstrap.Tooltip(tooltipTriggerEl)
            })
        });
    }


    // --- FIN: LÓGICA DE NOTIFICACIONES MODIFICADA ---

});
</script>

<?php endif; // ★ FIN: OCULTAR OFFCANVAS Y JS ★ ?>

</body>
</html>
