<?php
// /fitxa_pacient.php
// VERSIÓN REFACTORIZADA (v18 - Reactivación con Edición y Menú Completo)

// --- 1. GESTIÓ DE SESSIÓ I PERMISOS ---
session_start();
if (!isset($_SESSION['user_id'])) {
    header('Location: index.php');
    exit;
}
if ($_SESSION['user_rol'] === 'paciente') {
    header('Location: patient_dashboard.php');
    exit;
}

require_once 'db.php';
require_once 'logger.php';

// --- Variables globales para la página ---
$user_rol = $_SESSION['user_rol'];
$current_fisio_id = $_SESSION['user_id'];
$current_fisio_username = $_SESSION['user_nombre'] ?? 'Fisio/Admin';

$pacient_id = (int)($_GET['id'] ?? 0);
if ($pacient_id === 0) {
    header('Location: dashboard.php');
    exit;
}

// --- OBTENER DATOS DEL PACIENTE ---
$stmt = $db->prepare("SELECT id, nombre, apellido, email, telefono, fecha_creacion, is_archived, status FROM cuentas WHERE id = ? AND rol = 'paciente'");
$stmt->execute([$pacient_id]);
$pacient = $stmt->fetch();

if (!$pacient) {
    header('Location: dashboard.php?error=pacient_not_found');
    exit;
}

// --- LOG DE ACCESO ---
$log_action = "PATIENT_RECORD_VIEWED";
$log_actor_id = $current_fisio_id;
$log_actor_name = $current_fisio_username;
$log_target_user_id = $pacient_id;
$log_details = "Vio la ficha del paciente ID: $pacient_id (" . $pacient['nombre'] . " " . $pacient['apellido'] . ")";
registrar_log($db, $log_action, $log_actor_id, $log_actor_name, $log_details, $log_target_user_id, null);


// --- PERMISOS DE ACCESO ---
$is_assigning_protocol = (isset($_GET['action']) && $_GET['action'] === 'assign_protocol' && isset($_GET['protocol_id']));

if ($user_rol !== 'superadmin' && !$is_assigning_protocol) {
    $permStmt = $db->prepare(" SELECT 1 FROM cuentas p LEFT JOIN tratamientos t ON p.id = t.paciente_id LEFT JOIN tratamiento_fisios_asignados tfa ON t.id = tfa.tratamiento_id WHERE p.id = :pacient_id AND ( p.id_fisio_registrador = :current_fisio_id OR t.creator_fisio_id = :current_fisio_id OR tfa.fisio_id = :current_fisio_id ) LIMIT 1 ");
    $permStmt->execute([':pacient_id' => $pacient_id, ':current_fisio_id' => $current_fisio_id]);
    if (!$permStmt->fetch()) {
         header('Location: dashboard.php?error=access_denied');
         exit;
    }
}

$back_link = 'users.php';
if (isset($_SERVER['HTTP_REFERER'])) {
    $referer_path = parse_url($_SERVER['HTTP_REFERER'], PHP_URL_PATH);
    if (strpos($referer_path, 'treatments.php') !== false) { $back_link = 'treatments.php'; }
}

$page_title = "Fitxa de " . $pacient['nombre'] . " " . $pacient['apellido'];
include 'partials/header.php';

// --- ★ INICIO CORRECCIÓN: Definir $app_base_url para el JS (Necesario para set_manual_status) ---
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$domain_root = $protocol . $_SERVER['HTTP_HOST'];
$app_base_url = rtrim($domain_root . dirname($_SERVER['SCRIPT_NAME']), '/') . '/';
// --- ★ FIN CORRECCIÓN ---

?>

<style>
/* --- ESTILOS MODAL EVOLUCIÓN --- */
#evo-calendar-controls { display: flex; justify-content: space-between; align-items: center; padding-bottom: 1rem; border-bottom: 1px solid #dee2e6; margin-bottom: 1rem; }
#evo-day-carousel { display: flex; flex-wrap: nowrap; }
.day-card { cursor: pointer; background-color: #ffffff; border: 1px solid #dee2e6; min-width: 13%; flex-shrink: 0; transition: background-color 0.2s, color 0.2s, border-color 0.2s; position: relative; display: flex; flex-direction: column; justify-content: center; align-items: center; min-height: 90px; padding: 5px; overflow: hidden; border-radius: .375rem; }
.day-card.active { background-color: #0d6efd; color: white; border-color: #0d6efd; }
.day-card.active .day-name, .day-card.active .day-number { color: white; position: relative; z-index: 1; }
.day-name { font-size: 0.75rem; margin-bottom: 0; font-weight: 500; position: relative; z-index: 1; }
.day-number { font-size: 1.5rem; font-weight: bold; line-height: 1; position: relative; z-index: 1; }

.month-calendar { table-layout: fixed; width: 100%; }
.month-calendar .day-cell { cursor: pointer; position: relative; height: 70px; padding: 2px !important; vertical-align: middle; }
.month-calendar .day-cell > div { display: flex; flex-direction: column; justify-content: center; align-items: center; height: 100%; width: 100%; position: relative; border-radius: 0.25rem; transition: background-color 0.2s;}
.month-calendar .day-cell:hover:not(.is-empty) > div { background-color: #f0faff; }
.month-calendar .day-cell.active > div { background-color: #0d6efd; color: white; }
.month-calendar .day-cell.today > div { box-shadow: 0 0 0 2px #0d6efd inset; }
.month-calendar .day-cell .day-number-month { font-size: 1rem; position: relative; z-index: 1; }
.month-calendar .day-cell.active .day-number-month { color: white; font-weight: bold;}

.progress-ring { position: absolute; top: 50%; left: 50%; transform: translate(-50%, -50%); z-index: 0; }
.progress-ring__background, .progress-ring__circle { fill: none; }
.progress-ring__background { stroke: #e9ecef; }
.progress-ring__circle { stroke: #ffc107; stroke-linecap: round; transform-origin: 50% 50%; transform: rotate(-90deg); transition: stroke-dashoffset 0.3s; }
.progress-ring__circle--complete { stroke: #198754; }
.day-card .progress-ring { width: 75px; height: 75px; }
.day-card .progress-ring__background, .day-card .progress-ring__circle { stroke-width: 5; }
.month-calendar .day-cell .progress-ring { width: 45px; height: 45px; }
.month-calendar .day-cell .progress-ring__background, .month-calendar .day-cell .progress-ring__circle { stroke-width: 4; }
.day-card.active .progress-ring__background, .month-calendar .day-cell.active .progress-ring__background { stroke: rgba(255, 255, 255, 0.3); }
.day-card.active .progress-ring__circle, .month-calendar .day-cell.active .progress-ring__circle { stroke: white; }
.day-card.active .progress-ring__circle--complete, .month-calendar .day-cell.active .progress-ring__circle--complete { stroke: white; }
.day-card.is-empty, .month-calendar .day-cell.is-empty { background-color: #f8f9fa; cursor: default; color: #adb5bd; }
.day-card.is-empty:hover { background-color: #f8f9fa; }
.month-calendar .day-cell.is-empty > div { box-shadow: none; background-color: transparent;}
.month-calendar .day-cell.is-empty:hover > div { background-color: transparent; }

#evo-daily-title { background-color: #e9ecef; color: #495057; padding: 0.75rem 1.25rem; margin: -1rem -1.25rem 1rem -1.25rem; border-top-left-radius: .25rem; border-top-right-radius: .25rem; font-size: 1rem; font-weight: 500; }
#evo-daily-feedback-container .list-group-item { border-left: 3px solid transparent; padding-left: 1rem; transition: border-left-color 0.3s ease; }
#evo-daily-feedback-container .list-group-item.has-feedback { border-left-color: #198754; }
#evo-daily-feedback-container .list-group-item.no-feedback { border-left-color: #ced4da; }
.feedback-comment { white-space: normal; font-size: 0.8rem; }
.no-feedback { color: #6c757d; font-style: italic; }
.evo-today-btn { background-color: var(--bs-primary-bg-subtle); border-color: var(--bs-primary-bg-subtle); }

/* Ajustes de altura del modal */
#evolutionDetailModalBody { display: flex; flex-direction: column; }
#evolutionTabContent .tab-pane { height: auto !important; }
#evolutionTabContent .tab-pane:not(.show) { display: none !important; }
#chart-panel > div:first-child { position: relative; height: 300px; margin-bottom: 1rem; }
#evolutionChartCanvas { position: absolute; top: 0; left: 0; width: 100%; height: 100%; }
#evolutionChartComments { max-height: 150px; overflow-y: auto; }
#evo-week-carousel-container, #evo-month-calendar-wrapper, #evo-daily-feedback-container { height: auto; }

/* Estilos de miniaturas */
.list-thumbnail { width: 120px; height: 67px; object-fit: cover; border-radius: 0.25rem; background-color: #e9ecef; }
.protocol-modal-thumbnail { width: 60px; height: 34px; object-fit: cover; border-radius: 0.25rem; flex-shrink: 0; margin-right: 1rem; }
.protocol-modal-item { display: flex; align-items: center; padding-top: 0.75rem; padding-bottom: 0.75rem; }
.protocol-modal-info { flex-grow: 1; min-width: 0; }
.protocol-modal-title { font-weight: bold; margin-bottom: 0.1rem; white-space: nowrap; overflow: hidden; text-overflow: ellipsis; }
.protocol-modal-subtitle { font-size: 0.75rem; color: #6c757d; margin-bottom: 0; }

/* Correcciones estéticas */
#exercise-library-container .list-group-item .btn-outline-primary { color: var(--bs-primary); border-color: var(--bs-primary); }
#exercise-library-container .list-group-item .btn-outline-primary:hover { color: white; }
#chart-panel .chart-container { position: relative; height: 300px; margin-bottom: 1rem; }
#chart-panel .chart-alert { position: absolute; top: 50%; left: 50%; transform: translate(-50%, -50%); width: 90%; max-width: 400px; text-align: center; padding: 1rem; }

.btn-outline-secondary.dropdown-toggle:hover::after, .btn-outline-secondary.dropdown-toggle[aria-expanded="true"]::after { border-top-color: white; }
.btn-outline-secondary.dropdown-toggle:hover .bi-gear-fill, .btn-outline-secondary.dropdown-toggle[aria-expanded="true"] .bi-gear-fill { color: white; }

#historical-treatments-list .table-responsive { overflow: visible !important; }
#historical-treatments-list .table-responsive td:last-child { position: static !important; }

.view-ex-thumb { width: 100px; height: 60px; object-fit: cover; border-radius: 0.25rem; background-color: #343a40; }

@keyframes flash-red-border {
    0%   { box-shadow: 0 0 0 0px rgba(220, 53, 69, 0.7); }
    50%  { box-shadow: 0 0 0 5px rgba(220, 53, 69, 0.3); }
    100% { box-shadow: 0 0 0 0px rgba(220, 53, 69, 0); }
}
.flash-warning { animation: flash-red-border 1.5s 2; border: 1px solid #dc3545; }

/* Animación 'Flash Attention' para reactivación */
@keyframes flashAttention {
    0% { background-color: rgba(255, 193, 7, 0.5); }
    100% { background-color: transparent; }
}
.flash-attention {
    animation: flashAttention 3s ease-out;
}

/* --- FIX ALTURA BOTONES TRACTAMENTS --- */
.treatment-card .btn-group .btn, 
.treatment-card .view-evolution-btn {
    padding-top: 0.25rem !important;
    padding-bottom: 0.25rem !important;
    font-size: 0.875rem !important; /* Tamaño btn-sm */
    line-height: 1.5 !important;
    min-height: auto !important; /* Evitar estiramientos */
    display: inline-flex;
    align-items: center;
    justify-content: center;
}
/* Ajustar alineación del icono dentro del botón */
.treatment-card .btn i {
    line-height: 1;
    display: inline-block;
    vertical-align: middle;
}
</style>


<script>
    const PATIENT_EMAIL = "<?= htmlspecialchars($pacient['email'] ?? '', ENT_QUOTES | ENT_SUBSTITUTE, 'UTF-8') ?>";
    const PATIENT_PHONE = "<?= htmlspecialchars($pacient['telefono'] ?? 'N/A', ENT_QUOTES | ENT_SUBSTITUTE, 'UTF-8') ?>";
</script>

<main class="main-content container mt-4" style="max-width: 1420px;">
     <div class="row mb-3 align-items-center">
        <div class="col-lg">
            <div class="row align-items-center">
                <div class="col-md-auto me-md-5">
                    <h2 class="h5 text-muted mb-1">Fitxa de Pacient</h2>
                    <h4 class="mb-0">
                        <span style="color: IndianRed;">
                            <?= htmlspecialchars($pacient['nombre']) ?> <?= htmlspecialchars($pacient['apellido']) ?>
                        </span>
                         <?php if ($pacient['status'] === 'baja'): ?>
                            <span class="badge bg-secondary ms-2">Donat de Baixa</span>
                         <?php elseif ($pacient['is_archived']): ?>
                             <span class="badge bg-warning text-dark ms-2">Arxivat</span>
                         <?php endif; ?>
                    </h4>
                </div>
                <div class="col-md-auto">
                    <div class="small text-muted mt-2 mt-md-0">
                        <div class="mb-0"><i class="bi bi-envelope me-1"></i> <a href="mailto:<?= htmlspecialchars($pacient['email']) ?>" class="text-muted text-decoration-none" target="_blank"><?= htmlspecialchars($pacient['email']) ?></a></div>
                        <div class="mb-0"><i class="bi bi-phone me-1"></i> <?= htmlspecialchars($pacient['telefono'] ?? 'N/A') ?></div>
                        <div class="mb-0"><i class="bi bi-calendar-check me-1"></i> Data d'Alta: <?= (new DateTime($pacient['fecha_creacion']))->format('d/m/Y') ?></div>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="col-lg-auto mt-3 mt-lg-0">
            <div class="d-grid gap-2 d-lg-flex align-items-lg-center">
                
                <button class="btn btn-primary" id="addTreatmentBtn">
                    <i class="bi bi-plus-circle me-2"></i> Nou Tractament
                </button>
                
                <button class="btn btn-outline-primary" id="assignProtocolBtn">
                    <i class="bi bi-clipboard2-pulse me-2"></i> Assignar des de Protocol
                </button>

                <div class="vr d-none d-lg-block mx-2 text-muted"></div>
                <hr class="d-lg-none my-1 text-muted opacity-25">

                <?php if ($pacient['status'] === 'activo'): ?>
                <a href="#" id="impersonatePatientBtn" class="btn btn-outline-info" title="Suplantar Pacient">
                    <i class="bi bi-person-bounding-box me-1"></i> Suplantar
                </a>
                <?php endif; ?>

                <a href="<?= htmlspecialchars($back_link) ?>" class="btn btn-outline-secondary" title="Tornar al Llistat">
                    <i class="bi bi-arrow-left"></i> Tornar
                </a>
            </div>
        </div>
        </div>
    <hr class="mt-0 mb-4">

    <div class="card shadow-sm">
        <div class="card-body">
            <ul class="nav nav-tabs" id="treatmentTabs" role="tablist">
                <li class="nav-item" role="presentation"><button class="nav-link active" id="active-tab" data-bs-toggle="tab" data-bs-target="#active-panel" type="button">Tractaments Actius</button></li>
                <li class="nav-item" role="presentation"><button class="nav-link" id="history-tab" data-bs-toggle="tab" data-bs-target="#history-panel" type="button">Historial (Completats i Omesos)</button></li>
            </ul>
            <div class="tab-content py-3">
                <div class="tab-pane fade show active" id="active-panel" role="tabpanel">
                    <h4>Tractaments Actius i Programats</h4>
                    <div id="active-treatments-list" class="row g-4"></div>
                </div>
                <div class="tab-pane fade" id="history-panel" role="tabpanel">
                    <h4>Historial de Tractaments (Completats/Omés)</h4>
                    <div id="historical-treatments-list"></div>
                </div>
            </div>
        </div>
    </div>
</main>

<div class="modal fade" id="selectProtocolModal" tabindex="-1"> <div class="modal-dialog modal-lg"> <div class="modal-content"> <div class="modal-header"> <h5 class="modal-title">Selecciona un Protocol per a <?= htmlspecialchars($pacient['nombre']) ?></h5> <button type="button" class="btn-close" data-bs-dismiss="modal"></button> </div> <div class="modal-body"> <div class="input-group mb-3"> <span class="input-group-text"><i class="bi bi-search"></i></span> <input type="text" id="protocolSearchInputModal" class="form-control" placeholder="Cercar protocols..."> </div> <div id="protocol-list-modal-container" style="max-height: 60vh; overflow-y: auto;"></div> </div> </div> </div> </div>

<div class="modal fade" id="evolutionDetailModal" tabindex="-1"> 
    <div class="modal-dialog modal-dialog-scrollable modal-lg modal-fullscreen-md-down"> 
        <div class="modal-content"> 
            <div class="modal-header"> 
                <h5 class="modal-title" id="evolutionDetailModalLabel">Evolució del Tractament</h5> 
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button> 
            </div> 
            <div class="modal-body" id="evolutionDetailModalBody" style="display: flex; flex-direction: column;"> </div> 
            <div class="modal-footer"> 
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Tancar</button> 
            </div> 
        </div> 
    </div> 
</div>
<?php include 'partials/footer.php'; ?>

<script>
$(document).ready(function() {
    // --- Constantes Globales ---
    const PATIENT_ID = <?= $pacient_id ?>;
    const PATIENT_FULLNAME = "<?= htmlspecialchars($pacient['nombre'] . ' ' . $pacient['apellido'], ENT_QUOTES) ?>";
    const CURRENT_USER_ID = <?= $current_fisio_id ?>;
    const IS_SUPERADMIN = '<?= $user_rol ?>' === 'superadmin';
    // --- ★ INICIO CORRECCIÓN: Definir APP_BASE_URL ---
    const APP_BASE_URL = "<?php echo $app_base_url; ?>";
    // --- ★ FIN CORRECCIÓN ---

    // Instancias de Modales
    const evolutionDetailModal = new bootstrap.Modal('#evolutionDetailModal');
    let openedFromDashboard = false;
    let viewTreatmentModal;
    try { viewTreatmentModal = new bootstrap.Modal('#viewTreatmentModal'); } catch (e) {}

    let allFisios = [];
    let pageModalFunctions = {};
    let itemToManage = { id: null, name: '' };
    
    // Variables para el modal de confirmación (reutilizamos el de footer.php)
    let pendingAction = null, pendingId = null, pendingStatus = null;

    document.getElementById('evolutionDetailModal').addEventListener('hidden.bs.modal', function (event) {
        if (openedFromDashboard) { window.location.href = 'dashboard.php'; }
    });

    // --- UTILS ---
    function getImagePath(filename) {
        if (!filename) return 'logos/img_defecte.jpg';
        const systemImages = ['logo.jpg', 'logo2.jpg', 'img_defecte.jpg'];
        return systemImages.includes(filename) ? `logos/${filename}` : `images/${filename}`;
    }

    function getStatusBadge(status, realizacion_percent) {
        let badgeHtml = '', tooltipTitle = '';
        switch(status) {
            case 'En curs': badgeHtml = `<span class="badge bg-warning text-dark">En curs</span>`; tooltipTitle = 'Tractament actiu dins del rang de dates.'; break;
            case 'Programat': badgeHtml = `<span class="badge bg-info">Programat</span>`; tooltipTitle = 'Pendent de començar en la data d\'inici.'; break;
            case 'Completat': badgeHtml = `<span class="badge bg-success">Completat</span>`; tooltipTitle = 'Marcat com a completat (manual o automàtic).'; break;
            case 'Omés': badgeHtml = `<span class="badge bg-secondary">Omés</span>`; tooltipTitle = 'Marcat com a omés (manual o automàtic).'; break;
            default: badgeHtml = `<span class="badge bg-light text-dark">${escapeHtml(status)}</span>`; tooltipTitle = `Estat: ${escapeHtml(status)}`; break;
        }
        badgeHtml = badgeHtml.replace('>', ` data-bs-toggle="tooltip" title="${escapeHtml(tooltipTitle)}">`);
        let percentHtml = '';
        if (realizacion_percent !== null && realizacion_percent !== undefined) {
             if (status === 'Completat' || status === 'Omés') {
                 percentHtml = `<span class="badge bg-light text-dark fw-normal">${realizacion_percent}% realitzat</span>`;
             }
        }
        return `<div class="status-badge-group">${badgeHtml}${percentHtml}</div>`;
    }

    // --- LOGICA MENU ACCIONES (Corregida para Historial y Opciones Completas) ---
    function renderPatientActionButtons(treatment) {
        const t_id = treatment.id;
        const t_title_safe = escapeHtml(treatment.title);
        const isCreator = treatment.creator_fisio_id == CURRENT_USER_ID;
        const collaboratorIdsArray = treatment.collaborator_ids ? treatment.collaborator_ids.split(',') : [];
        const isCollaborator = collaboratorIdsArray.includes(String(CURRENT_USER_ID));
        const canModify = IS_SUPERADMIN || isCreator || isCollaborator;
        const canManage = IS_SUPERADMIN || isCreator;

        const isHistory = treatment.status === 'Completat' || treatment.status === 'Omés';

        let buttonsHtml = `
            <button class="btn btn-primary btn-sm view-evolution-btn" data-id="${t_id}" data-title="${t_title_safe}" data-bs-toggle="tooltip" title="Veure Evolució i Adherència">
                <i class="bi bi-graph-up me-1"></i> Evolució
            </button>
        `;

        buttonsHtml += `
            <div class="btn-group ms-1">
                <button class="btn btn-sm btn-outline-secondary dropdown-toggle" type="button" data-bs-toggle="dropdown" data-bs-container="body" aria-expanded="false" data-bs-toggle="tooltip" title="Més accions">
                    <i class="bi bi-gear-fill"></i>
                </button>
                <ul class="dropdown-menu dropdown-menu-end">
                    
                    <li><a class="dropdown-item view-treatment-btn" href="#" data-id="${t_id}">
                        <i class="bi bi-eye"></i> Veure Detalls
                    </a></li>
        `;

        if (!isHistory) {
            // --- OPCIONES PARA TRATAMIENTOS ACTIVOS ---
            buttonsHtml += `
                    <li><a class="dropdown-item edit-treatment-btn ${!canModify ? 'disabled' : ''}" href="#" data-id="${t_id}" ${!canModify ? 'aria-disabled="true" tabindex="-1"' : ''}>
                        <i class="bi bi-pencil"></i> Editar
                    </a></li>
                    <li><hr class="dropdown-divider"></li>
                    <li><a class="dropdown-item ${!canModify ? 'disabled' : ''}"
                           href="${canModify ? 'reports/treatment_report.php?id=' + t_id + '&return_to=' + encodeURIComponent(window.location.pathname + window.location.search) : '#'}"
                           ${!canModify ? 'aria-disabled="true" tabindex="-1" title="Només creador/col·laborador pot imprimir"' : ''}
                           >
                        <i class="bi bi-printer"></i> Imprimir Informe
                    </a></li>
                    
                    <li><hr class="dropdown-divider"></li>
                    <li><h6 class="dropdown-header">Finalitzar Manualment</h6></li>
                    <li>
                        <a class="dropdown-item set-status-btn ${!canModify ? 'disabled' : ''}"
                           href="#"
                           data-id="${t_id}" data-status="Completat"
                           ${!canModify ? 'aria-disabled="true" tabindex="-1" title="Només creador/col·laborador pot finalitzar"' : ''}
                        >
                            <i class="bi bi-check-circle-fill text-success"></i> Marcar com a Completat
                        </a>
                    </li>
                    <li>
                        <a class="dropdown-item set-status-btn ${!canModify ? 'disabled' : ''}"
                           href="#"
                           data-id="${t_id}" data-status="Omés"
                           ${!canModify ? 'aria-disabled="true" tabindex="-1" title="Només creador/col·laborador pot finalitzar"' : ''}
                        >
                            <i class="bi bi-x-octagon-fill text-secondary"></i> Marcar com a Omés
                        </a>
                    </li>
            `;
        } else {
            // --- OPCIONES PARA HISTORIAL (REACTIVAR) ---
            buttonsHtml += `
                <li><hr class="dropdown-divider"></li>
                <li><a class="dropdown-item reactivate-treatment-btn ${!canModify ? 'disabled' : ''}" href="#" data-id="${t_id}" data-title="${t_title_safe}">
                    <i class="bi bi-arrow-repeat text-success"></i> Reactivar Tractament
                </a></li>
            `;
        }

        // Opciones Comunes (Siempre visibles)
        buttonsHtml += `
                    <li><hr class="dropdown-divider"></li>
                    <li><a class="dropdown-item manage-treatment-btn ${!canManage ? 'disabled' : ''}" href="#" data-id="${t_id}" data-name="${t_title_safe}" ${!canManage ? 'aria-disabled="true" tabindex="-1"' : ''}>
                        <i class="bi bi-shield-slash"></i> Arxivar / Eliminar
                    </a></li>
                </ul>
            </div>
        `;
        return buttonsHtml;
    }

    // --- RENDERIZADO DE TRATAMIENTOS ---
    function renderPatientTreatments(activeTreatments, historicalTreatments) {
        const activeContainer = $('#active-treatments-list');
        const historicalContainer = $('#historical-treatments-list');
        activeContainer.empty();
        historicalContainer.empty();

        // 1. ACTIVOS
        if (activeTreatments.length === 0) {
            activeContainer.html('<div class="col-12"><div class="alert alert-secondary text-center">No hi ha tractaments actius o programats.</div></div>');
        } else {
            activeTreatments.forEach(t => {
                let thumbnailHtml = '';
                if (t.first_video_filename) {
                    if (t.first_video_filename.startsWith('http')) { 
                        const ytMatch = t.first_video_filename.match(/youtube\.com\/embed\/([a-zA-Z0-9\-_]+)/); 
                        thumbnailHtml = `<img src="${ytMatch ? `https://img.youtube.com/vi/${ytMatch[1]}/mqdefault.jpg` : 'https://placehold.co/16x9/e9ecef/6c757d?text=URL'}" alt="Miniatura">`; 
                    } else { 
                        thumbnailHtml = `<video src="videos/${t.first_video_filename}#t=0.5" preload="metadata"></video>`; 
                    }
                } else if (t.first_image_filename) {
                    thumbnailHtml = `<img src="images/${t.first_image_filename}" alt="Miniatura">`;
                } else {
                    thumbnailHtml = `<div class="w-100 h-100 no-media-placeholder d-flex align-items-center justify-content-center"><div class="text-center"><i class="bi bi-camera-video-off fs-1"></i><p class="mb-0 mt-2 small">Sense medis</p></div></div>`;
                }
                const imageContainer = `<div class="card-img-top ratio ratio-16x9">${thumbnailHtml}</div>`;
                
                const buttonsHtml = renderPatientActionButtons(t);
                let statusBadge = getStatusBadge(t.status, t.realizacion_percent);
                const startDate = new Date(t.start_date).toLocaleDateString('ca-ES');
                const endDate = t.end_date ? new Date(t.end_date).toLocaleDateString('ca-ES') : 'N/A';

                let collaboratorsHtml = '';
                if (t.collaborator_ids && allFisios.length > 0) {
                    const collaboratorIdsArray = t.collaborator_ids.split(',');
                    const collaboratorNames = collaboratorIdsArray.map(id => {
                        if (id == t.creator_fisio_id) return null;
                        const fisio = allFisios.find(f => f.id == id);
                        return (fisio && fisio.rol !== 'superadmin') ? escapeHtml(`${fisio.nombre} ${fisio.apellido}`) : null;
                    }).filter(name => name !== null);
                    if (collaboratorNames.length > 0) {
                        collaboratorsHtml = `<p class="card-text small text-muted mb-2" data-bs-toggle="tooltip" title="Col·laboradors"><i class="bi bi-people-fill me-1"></i> ${collaboratorNames.join(', ')}</p>`;
                    }
                }

                activeContainer.append(`
                <div class="col-md-6 col-lg-4 col-xl-3" data-treatment-id="${t.id}">
                    <div class="card h-100 shadow-sm treatment-card"> 
                        ${imageContainer} 
                        <div class="card-body d-flex flex-column"> 
                            <h5 class="card-title">${escapeHtml(t.title)}</h5> 
                            <p class="card-text small text-muted mb-2">Creat per: ${escapeHtml(t.creator_name)} ${escapeHtml(t.creator_surname)}</p>
                            ${collaboratorsHtml}
                            <div class="mt-auto"> 
                                <p class="card-text small text-muted mb-2">(${startDate} - ${endDate})</p> 
                                <div class="d-flex justify-content-between align-items-center">
                                    ${statusBadge}
                                    <div class="btn-group">${buttonsHtml}</div>
                                </div> 
                            </div> 
                        </div> 
                    </div> 
                </div>`);
            });
        }

        // 2. HISTORIAL (AHORA CON CARDS)
        if (historicalTreatments.length === 0) {
            historicalContainer.html('<div class="alert alert-secondary text-center">No hi ha tractaments a l\'historial.</div>');
        } else {
            let historyHtml = '<div class="row g-4">';
            
            historicalTreatments.forEach(t => {
                let thumbnailHtml = '';
                if (t.first_video_filename) {
                    if (t.first_video_filename.startsWith('http')) { 
                        const ytMatch = t.first_video_filename.match(/youtube\.com\/embed\/([a-zA-Z0-9\-_]+)/); 
                        thumbnailHtml = `<img src="${ytMatch ? `https://img.youtube.com/vi/${ytMatch[1]}/mqdefault.jpg` : 'https://placehold.co/16x9/e9ecef/6c757d?text=URL'}" alt="Miniatura">`; 
                    } else { 
                        thumbnailHtml = `<video src="videos/${t.first_video_filename}#t=0.5" preload="metadata"></video>`; 
                    }
                } else if (t.first_image_filename) {
                    thumbnailHtml = `<img src="images/${t.first_image_filename}" alt="Miniatura">`;
                } else {
                    thumbnailHtml = `<div class="w-100 h-100 no-media-placeholder d-flex align-items-center justify-content-center"><div class="text-center"><i class="bi bi-camera-video-off fs-1"></i><p class="mb-0 mt-2 small">Sense medis</p></div></div>`;
                }
                // FILTRO GRIS PARA HISTORIAL
                const imageContainer = `<div class="card-img-top ratio ratio-16x9" style="filter: grayscale(100%); opacity: 0.8;">${thumbnailHtml}</div>`;

                const buttonsHtml = renderPatientActionButtons(t);
                let statusBadge = getStatusBadge(t.status, t.realizacion_percent);
                const startDate = t.start_date ? new Date(t.start_date).toLocaleDateString('ca-ES') : 'N/A';
                const endDate = t.end_date ? new Date(t.end_date).toLocaleDateString('ca-ES') : 'N/A';

                let collaboratorsHtml = '';
                if (t.collaborator_ids && allFisios.length > 0) {
                    const collaboratorIdsArray = t.collaborator_ids.split(',');
                    const collaboratorNames = collaboratorIdsArray.map(id => {
                        if (id == t.creator_fisio_id) return null;
                        const fisio = allFisios.find(f => f.id == id);
                        return (fisio && fisio.rol !== 'superadmin') ? escapeHtml(`${fisio.nombre} ${fisio.apellido}`) : null;
                    }).filter(name => name !== null);
                    if (collaboratorNames.length > 0) {
                        collaboratorsHtml = `<p class="card-text small text-muted mb-2" data-bs-toggle="tooltip" title="Col·laboradors"><i class="bi bi-people-fill me-1"></i> ${collaboratorNames.join(', ')}</p>`;
                    }
                }

                // CARD DE HISTORIAL (FONDO GRISÁCEO)
                historyHtml += `
                <div class="col-md-6 col-lg-4 col-xl-3" data-treatment-id="${t.id}">
                    <div class="card h-100 shadow-sm treatment-card bg-light border-0"> 
                        ${imageContainer} 
                        <div class="card-body d-flex flex-column"> 
                            <h5 class="card-title text-muted">${escapeHtml(t.title)}</h5> 
                            <p class="card-text small text-muted mb-2">Creat per: ${escapeHtml(t.creator_name)} ${escapeHtml(t.creator_surname)}</p>
                            ${collaboratorsHtml}
                            <div class="mt-auto"> 
                                <p class="card-text small text-muted mb-2">(${startDate} - ${endDate})</p> 
                                <div class="d-flex justify-content-between align-items-center">
                                    ${statusBadge}
                                    <div class="btn-group">${buttonsHtml}</div>
                                </div> 
                            </div> 
                        </div> 
                    </div> 
                </div>`;
            });
            
            historyHtml += '</div>';
            historicalContainer.html(historyHtml);
        }
        $('[data-bs-toggle="tooltip"]').tooltip('dispose').tooltip();
    }

    // --- CARGA DE DATOS ---
    function loadPatientTreatments() {
        const activeContainer = $('#active-treatments-list');
        const historicalContainer = $('#historical-treatments-list');
        const loadingHtml = '<div class="text-center p-5"><div class="spinner-border text-primary"></div><p class="mt-2 text-muted">Carregant tractaments...</p></div>';

        activeContainer.html(loadingHtml);
        historicalContainer.html(loadingHtml);

        $.getJSON('patient_ajax.php', { ajax: true, action: 'get_patient_treatments', pacient_id: PATIENT_ID })
            .done(response => {
                if (response.status === 'success') {
                    renderPatientTreatments(response.active, response.historical);

                    const urlParams = new URLSearchParams(window.location.search);
                    const actionToTake = urlParams.get('action');
                    const treatmentIdToOpen = urlParams.get('treatment_id');
                    const tabToOpen = urlParams.get('tab');
                    const highlightId = urlParams.get('highlight');
                    const evoDateToOpen = urlParams.get('evo_date');

                    if (actionToTake === 'open_evo' && treatmentIdToOpen) {
                        openedFromDashboard = true;
                        const $evolutionButton = $(`.view-evolution-btn[data-id="${treatmentIdToOpen}"]`);
                        if ($evolutionButton.length > 0) {
                            if (evoDateToOpen) { $evolutionButton.data('evo-date', evoDateToOpen); }
                            const $cardOrRow = $evolutionButton.closest('.treatment-card, tr');
                            setTimeout(() => {
                                if ($cardOrRow.length > 0) {
                                    $cardOrRow[0].scrollIntoView({ behavior: 'smooth', block: 'center' });
                                    $cardOrRow.css('transition', 'background-color 0.5s').css('background-color', '#fff3cd');
                                    setTimeout(() => { $cardOrRow.css('background-color', ''); }, 2000);
                                }
                                $evolutionButton.click();
                                history.replaceState(null, '', window.location.pathname + `?id=${PATIENT_ID}`);
                            }, 500);
                        }
                    }
                    else if (tabToOpen === 'history') {
                        const historyTab = document.getElementById('history-tab');
                        if (historyTab) { (new bootstrap.Tab(historyTab)).show(); }
                        if(highlightId) {
                             setTimeout(() => {
                                const $rowToHighlight = $(`div[data-treatment-id="${highlightId}"]`);
                                if ($rowToHighlight.length > 0) {
                                    $rowToHighlight[0].scrollIntoView({ behavior: 'smooth', block: 'center' });
                                    const card = $rowToHighlight.find('.card');
                                    card.css('transition', 'background-color 0.5s').css('background-color', '#fff3cd');
                                    setTimeout(() => { card.css('background-color', ''); }, 2500);
                                }
                             }, 200);
                        }
                        history.replaceState(null, '', window.location.pathname + `?id=${PATIENT_ID}`);
                    }
                } else {
                    const errorHtml = `<div class="alert alert-warning">${escapeHtml(response.message || 'Error desconegut.')}</div>`;
                    activeContainer.html(errorHtml);
                    historicalContainer.html(errorHtml);
                }
            })
            .fail(xhr => {
                const errorHtml = `<div class="alert alert-danger">${escapeHtml(xhr.responseJSON?.message || 'Error de connexió.')}</div>`;
                activeContainer.html(errorHtml);
                historicalContainer.html(errorHtml);
            });
    }

    // --- HANDLER REACTIVAR (MEJORADO) ---
    $(document).on('click', '.reactivate-treatment-btn', function(e) {
        e.preventDefault();
        if ($(this).hasClass('disabled')) return;

        const treatmentId = $(this).data('id');
        const treatmentTitle = $(this).data('title');

        // 1. CONFIRMACIÓN SIMPLE (Sin hablar de fechas)
        if (confirm(`Vols reactivar el tractament "${treatmentTitle}"?`)) {
            
            const originalHtml = $(this).html();
            $(this).html('<span class="spinner-border spinner-border-sm"></span> Processant...').addClass('disabled');

            $.post('treatments.php', {
                ajax: true,
                action: 'reactivate_treatment',
                id: treatmentId
            }, 'json')
            .done(response => {
                if (response.status === 'success' && response.action === 'reactivated') {
                    showToast("Tractament reactivat.", 'success');
                    
                    // 2. ABRIR MODAL DE EDICIÓN PARA REVISAR FECHAS
                    // Necesitamos cargar los datos del tratamiento recién activado
                    if (typeof pageModalFunctions.populateAndOpenModalCRUD === 'function') {
                        $.getJSON('treatments.php', { ajax: true, action: 'get_treatment_details', id: treatmentId })
                        .done(res => {
                            if (res.status === 'success') {
                                // Abrir modal
                                pageModalFunctions.populateAndOpenModalCRUD(res.treatment);
                                
                                // Cambiar a pestaña Activos en segundo plano
                                const activeTab = document.getElementById('active-tab');
                                if (activeTab) {
                                    const tabInstance = bootstrap.Tab.getOrCreateInstance(activeTab);
                                    tabInstance.show();
                                }
                                loadPatientTreatments();

                                // 3. FLASHEAR LAS FECHAS (Animación Visual)
                                setTimeout(() => {
                                    const datePickerEl = document.getElementById('date_range_picker');
                                    const deliveryOptions = document.getElementById('delivery-options-wrapper');
                                    
                                    if (datePickerEl) {
                                        datePickerEl.classList.add('flash-attention');
                                        // Scroll suave hasta el elemento dentro del modal
                                        $('#treatmentModal .modal-body').animate({
                                            scrollTop: $(datePickerEl).offset().top - $('#treatmentModal .modal-body').offset().top - 20
                                        }, 500);
                                    }
                                    if (deliveryOptions) {
                                        deliveryOptions.classList.add('flash-attention');
                                    }

                                    // Quitar clase después de la animación
                                    setTimeout(() => {
                                        if (datePickerEl) datePickerEl.classList.remove('flash-attention');
                                        if (deliveryOptions) deliveryOptions.classList.remove('flash-attention');
                                    }, 3000);
                                    
                                    // Mostrar Toast de instrucción
                                    showToast("Si us plau, revisa les dates d'inici i fi.", 'info');

                                }, 500); // Pequeño delay para asegurar que el modal está renderizado
                            }
                        });
                    } else {
                        // Fallback si no se puede abrir el modal
                        loadPatientTreatments();
                    }
                } else {
                    showToast(response.message || 'Error en reactivar.', 'danger');
                    $(this).html(originalHtml).removeClass('disabled');
                }
            })
            .fail(xhr => {
                showToast(xhr.responseJSON?.message || 'Error de connexió.', 'danger');
                $(this).html(originalHtml).removeClass('disabled');
            });
        }
    });

    // --- HANDLER FINALIZAR MANUALMENTE (NUEVO) ---
    $(document).on('click', '.set-status-btn', function(e) {
        e.preventDefault();
        if ($(this).hasClass('disabled')) return;

        const treatmentId = $(this).data('id');
        const newStatus = $(this).data('status'); // 'Completat' o 'Omés'
        
        // Usamos el modal de confirmación global del footer
        triggerConfirmationModal(treatmentId, 'set_manual_status', newStatus);
    });

    function triggerConfirmationModal(id, action, status = null) {
      // Variables globales para el modal de confirmación (definidas en footer o header)
      // Si no existen en fitxa_pacient, las definimos aquí localmente o usamos window
      // Pero como fitxa_pacient.php carga footer.php, el HTML del modal está ahí.
      // Necesitamos las variables globales JS para pasar datos al botón de confirmar.
      
      // Reutilizamos las variables locales definidas al inicio de $(document).ready
      pendingId = id;
      pendingAction = action;
      pendingStatus = status;

      const modalTitle = $('#confirmationModalLabel');
      const modalBody = $('#confirmationModalBody');
      const confirmBtn = $('#confirmActionButton');
      let titleText, bodyText, btnText, headerClass = 'bg-warning text-dark', btnClass = 'btn-warning';

      if (action === 'set_manual_status') {
          const statusText = status === 'Completat' ? 'Completat' : 'Omès';
          titleText = `Confirmar: ${statusText}`;
          bodyText = `<p>Estàs a punt de marcar el tractament com a <strong>"${statusText}"</strong>. Aquesta acció el mourà a l'historial.</p>`;
          btnText = `Sí, Marcar com a ${statusText}`;
          if(status === 'Completat') { headerClass = 'bg-success text-white'; btnClass = 'btn-success'; }
          else { headerClass = 'bg-secondary text-white'; btnClass = 'btn-secondary'; }
      }
      
      modalTitle.text(titleText);
      modalBody.html(bodyText);
      confirmBtn.text(btnText).removeClass('btn-warning btn-success btn-secondary btn-primary btn-danger').addClass(btnClass).prop('disabled', false);
      $('#confirmationModal .modal-header').removeClass('bg-warning bg-success bg-secondary bg-primary text-dark text-white').addClass(headerClass);

      bootstrap.Modal.getOrCreateInstance(document.getElementById('confirmationModal')).show();
    }

    // Listener para el botón del modal de confirmación (Reemplaza o se suma al existente)
    // Para evitar conflictos con otros scripts, usamos un handler específico aquí
    // Pero el modal de footer.php tiene su propio ID.
    // Lo mejor es usar un handler delegated único para esta página
    
    $('#confirmActionButton').off('click').on('click', function() {
        if (!pendingAction) return; // Si no es nuestra acción, salir (aunque hemos hecho off, así que somos los únicos)
        
        const $button = $(this);
        $button.prop('disabled', true).html('<span class="spinner-border spinner-border-sm"></span> Processant...');
        const confirmationModalInstance = bootstrap.Modal.getOrCreateInstance(document.getElementById('confirmationModal'));

        // Usamos treatments.php porque ahí está la lógica de set_manual_status
        $.post('treatments.php', { ajax: true, action: pendingAction, id: pendingId, status: pendingStatus }, 'json')
            .done(res => {
                showToast(res.message, 'success');
                confirmationModalInstance.hide();
                loadPatientTreatments(); // Recargar listas

                // Enviar email si corresponde
                if (pendingAction === 'set_manual_status' && res.treatment_id && res.new_status) {
                    $.post('treatments.php', {
                        ajax: true,
                        action: 'send_treatment_notification',
                        treatment_id: res.treatment_id,
                        type: (res.new_status === 'Completat' ? 'complete' : 'omit')
                    }).fail(err => console.error('Error enviando email', err));
                }
            })
            .fail(xhr => {
                showToast(xhr.responseJSON?.message || 'Error en l\'operació.', 'danger');
                confirmationModalInstance.hide();
            })
            .always(() => {
                pendingAction = null; pendingId = null; pendingStatus = null;
            });
    });


    // --- OTROS HANDLERS (EVOLUCIÓN, GESTIÓN, MODALES) ---
    $(document).on('click', '.view-evolution-btn', function() {
        const treatmentId = $(this).data('id');
        const treatmentTitle = $(this).data('title');
        const evoDate = $(this).data('evo-date');
        const modalBody = $('#evolutionDetailModalBody');

        $('#evolutionDetailModalLabel').text(`Evolució: ${escapeHtml(treatmentTitle)}`);
        modalBody.html('<div class="text-center p-5"><div class="spinner-border text-primary" style="width: 3rem; height: 3rem;"></div><p class="mt-3">Carregant dades d\'evolució detallades...</p></div>');
        evolutionDetailModal.show();

        $.when(
            $.getJSON('patient_ajax.php', { ajax: true, action: 'get_evolution_overview', treatment_id: treatmentId, pacient_id: PATIENT_ID }),
            $.getJSON('patient_ajax.php', { ajax: true, action: 'get_full_evolution_data', treatment_id: treatmentId, pacient_id: PATIENT_ID, exercise_id: 0 })
        ).done(function(overviewResponse, fullEvolutionResponse) {
            if (overviewResponse[0].status === 'success' && fullEvolutionResponse[0].status === 'success') {
                renderEvolutionDetailsInModal(modalBody, overviewResponse[0], fullEvolutionResponse[0], evoDate);
            } else {
                modalBody.html(`<div class="alert alert-danger m-3">${escapeHtml(overviewResponse[0].message || 'Error.')}</div>`);
            }
        }).fail(function() {
             modalBody.html(`<div class="alert alert-danger m-3">Error de connexió.</div>`);
        });
    });

function renderEvolutionDetailsInModal(modalBodyElement, overviewData, evolutionData, evoDate) {
        const treatment = overviewData.treatment;
        const exercises = overviewData.exercises;
        let fullEvolution = evolutionData.evolution || {};
        const adherencePercent = overviewData.progress_percent_adherence;
        const timePercent = overviewData.progress_percent_time;

        let startDateFormatted = 'N/A', endDateFormatted = 'N/A';
        try { startDateFormatted = new Date(treatment.start_date + 'T12:00:00').toLocaleDateString('ca-ES'); } catch(e){}
        try { endDateFormatted = new Date(treatment.end_date + 'T12:00:00').toLocaleDateString('ca-ES'); } catch(e){}

        let modalSelectedDateStr = evoDate ? evoDate : ((treatment.end_date && treatment.end_date < new Date().toISOString().split('T')[0]) ? treatment.end_date : new Date().toISOString().split('T')[0]);
        let modalCurrentDate = new Date(modalSelectedDateStr + 'T12:00:00');
        
        // --- LÓGICA RESPONSIVE AÑADIDA ---
        const isMobile = window.innerWidth < 768; // Detectar móvil
        let modalViewMode = isMobile ? 'month' : 'week'; // Forzar mes en móvil, semana en PC
        
        // Clases para ocultar botones en móvil (d-none) y mostrar en PC (d-md-block)
        const toggleBtnClass = "btn btn-outline-primary modal-view-btn d-none d-md-block"; 
        const weekActive = modalViewMode === 'week' ? 'active' : '';
        const monthActive = modalViewMode === 'month' ? 'active' : '';

        let modalHtml = `
            <div class="px-3 pt-3 mb-3 border-bottom pb-3">
                 <div class="row">
                     <div class="col-md-6">
                         <h6 class="mb-1 text-muted">Pacient</h6>
                         <p class="mb-1"><strong>${escapeHtml(PATIENT_FULLNAME)}</strong></p>
                         <p class="mb-1 small"><i class="bi bi-envelope me-1"></i> ${escapeHtml(PATIENT_EMAIL)}</p>
                         <p class="mb-0 small"><i class="bi bi-phone me-1"></i> ${escapeHtml(PATIENT_PHONE)}</p>
                     </div>
                     <div class="col-md-6 mt-2 mt-md-0">
                         <h6 class="mb-1 text-muted">Període del Tractament</h6>
                         <p class="mb-0"><strong>${startDateFormatted}</strong> - <strong>${endDateFormatted}</strong></p>
                     </div>
                 </div>
            </div>
            <div class="p-3 mb-3 bg-light rounded border">
                <div class="row align-items-center">
                    <div class="col-md-7">
                        <label class="small fw-bold">Progrés (Temps)</label>
                        <div class="progress mb-2" style="height: 18px;" data-bs-toggle="tooltip" title="${timePercent}% temps transcorregut">
                            <div class="progress-bar bg-info" role="progressbar" style="width: ${timePercent}%;">${timePercent}%</div>
                        </div>
                        <label class="small fw-bold">Adherència (Realització)</label>
                        <div class="progress" style="height: 18px;" data-bs-toggle="tooltip" title="${adherencePercent}% exercicis completats">
                            <div class="progress-bar bg-success" role="progressbar" style="width: ${adherencePercent}%;">${adherencePercent}%</div>
                        </div>
                    </div>
                    <div class="col-md-5 mt-2 mt-md-0">
                        <label for="evo-chart-exercise-filter" class="form-label small">Filtre Gràfic/Evolució:</label>
                        <select id="evo-chart-exercise-filter" class="form-select form-select-sm">
                            <option value="0">Tots els Exercicis</option>
                            ${exercises.map(ex => `<option value="${ex.ejercicio_id}">${escapeHtml(ex.title)}</option>`).join('')}
                        </select>
                    </div>
                </div>
            </div>

            <ul class="nav nav-tabs nav-fill mb-3" id="evolutionTab" role="tablist">
                <li class="nav-item" role="presentation"><button class="nav-link active" id="calendar-tab" data-bs-toggle="tab" data-bs-target="#calendar-panel" type="button"><i class="bi bi-calendar-week me-1"></i> Calendari</button></li>
                <li class="nav-item" role="presentation"><button class="nav-link" id="chart-tab" data-bs-toggle="tab" data-bs-target="#chart-panel" type="button"><i class="bi bi-graph-up me-1"></i> Gràfic</button></li>
            </ul>
            <div class="tab-content flex-grow-1" id="evolutionTabContent" style="min-height: 400px;">
                <div class="tab-pane fade show active" id="calendar-panel" role="tabpanel" style="display: flex; flex-direction: column;">
                    <div id="evo-calendar-controls" class="mb-3">
                         <div class="d-flex align-items-center">
                             <button class="btn btn-sm btn-link text-muted modal-nav-btn" data-direction="prev-month"><i class="bi bi-chevron-double-left"></i></button>
                             <h6 class="mb-0 mx-2" id="evo-month-display"></h6>
                             <button class="btn btn-sm btn-link text-muted modal-nav-btn" data-direction="next-month"><i class="bi bi-chevron-double-right"></i></button>
                         </div>
                         
                         <div class="btn-group btn-group-sm">
                             <button class="${toggleBtnClass} ${weekActive}" data-view="week">Setmanal</button>
                             <button class="${toggleBtnClass} ${monthActive}" data-view="month">Mensual</button>
                             <button class="btn btn-primary modal-today-btn ms-2">Hui</button>
                         </div>
                    </div>
                    
                     <div id="evo-week-carousel-container" class="d-flex align-items-center mb-3">
                         <button class="btn btn-sm btn-outline-secondary modal-nav-btn me-2" data-direction="prev-week"><i class="bi bi-chevron-left"></i></button>
                         <div id="evo-day-carousel-wrapper" class="flex-grow-1 overflow-hidden"><div id="evo-day-carousel" class="d-flex justify-content-between"></div></div>
                         <button class="btn btn-sm btn-outline-secondary modal-nav-btn ms-2" data-direction="next-week"><i class="bi bi-chevron-right"></i></button>
                     </div>
                     
                     <div id="evo-month-calendar-wrapper" class="d-none"></div>
                     
                     <div id="evo-daily-feedback-container" class="mt-3 border-top pt-3 flex-grow-1" style="overflow-y: auto; min-height: 150px;">
                        <h6 id="evo-daily-title" class="mb-3">Selecciona un dia per veure el detall</h6>
                        <div id="evo-daily-exercises"></div>
                    </div>
                </div>
                <div class="tab-pane fade" id="chart-panel" role="tabpanel" style="display: flex; flex-direction: column;">
                    <div class="chart-container"><canvas id="evolutionChartCanvas"></canvas><div id="chartNoDataMessage" class="chart-alert alert alert-warning d-none"><i class="bi bi-exclamation-triangle me-2"></i> No hi ha dades suficients.</div></div>
                    <div id="evolutionChartComments" class="mt-3 small border-top pt-2" style="max-height: 150px; overflow-y: auto;"><h6>Comentaris Registrats:</h6><ul class="list-unstyled mb-0"></ul></div>
                </div>
            </div>
        `;
        modalBodyElement.html(modalHtml);

        const DAY_NAMES_MODAL = ['DG', 'DL', 'DM', 'DX', 'DJ', 'DV', 'DS'];
        const MONTH_NAMES_MODAL = ["Gener", "Febrer", "Març", "Abril", "Maig", "Juny", "Juliol", "Agost", "Setembre", "Octubre", "Novembre", "Desembre"];
        let evolutionChartInstance = null;

        function getScheduledExercisesForDayModal(dateStr) { if (!treatment || !exercises) return []; if ((treatment.start_date && dateStr < treatment.start_date) || (treatment.end_date && dateStr > treatment.end_date)) return []; const selectedDate = new Date(dateStr + 'T12:00:00'); const dayOfWeek = selectedDate.getDay(); let startDate = null; try { startDate = new Date(treatment.start_date + 'T12:00:00'); } catch(e) { return []; } return exercises.filter(ex => { const freq = ex.frecuencia; if (!freq || freq === 'Diari') return true; if (freq === '3xSetmana') return [1, 3, 5].includes(dayOfWeek); if (freq === '2xSetmana') return [2, 4].includes(dayOfWeek); if (freq === 'Altern') { const timeDiff = selectedDate.getTime() - startDate.getTime(); const dayDiff = Math.round(timeDiff / (1000 * 60 * 60 * 24)); return dayDiff >= 0 && dayDiff % 2 === 0; } return true; }); }
        function createProgressRingSVGModal(percentage, radius, strokeWidth) { const normalizedRadius = radius - strokeWidth / 2; const circumference = normalizedRadius * 2 * Math.PI; const offset = circumference - (percentage / 100) * circumference; const colorClass = percentage === 100 ? 'progress-ring__circle--complete' : ''; const viewBoxSize = radius * 2; return `<svg class="progress-ring" viewBox="0 0 ${viewBoxSize} ${viewBoxSize}"><circle class="progress-ring__background" stroke-width="${strokeWidth}" r="${normalizedRadius}" cx="${radius}" cy="${radius}"/><circle class="progress-ring__circle ${colorClass}" stroke-width="${strokeWidth}" stroke-dasharray="${circumference} ${circumference}" stroke-dashoffset="${offset}" r="${normalizedRadius}" cx="${radius}" cy="${radius}"/></svg>`; }
        function renderWeekCalendarModal() { const carousel = modalBodyElement.find('#evo-day-carousel'); carousel.empty(); const date = modalCurrentDate; const currentDayOfWeek = date.getDay(); const diff = date.getDate() - currentDayOfWeek + (currentDayOfWeek === 0 ? -6 : 1); const startOfWeek = new Date(date); startOfWeek.setDate(diff); const weeklyRadius = 35; const weeklyStrokeWidth = 5; for (let i = 0; i < 7; i++) { const day = new Date(startOfWeek); day.setDate(startOfWeek.getDate() + i); const dateStr = day.toISOString().split('T')[0]; const isSelected = dateStr === modalSelectedDateStr; const scheduledExercises = getScheduledExercisesForDayModal(dateStr); let progressIndicator = ''; let cardClasses = `day-card mx-1 p-2 text-center rounded flex-grow-1`; let percentage = 0; const currentExerciseFilterId = parseInt(modalBodyElement.find('#evo-chart-exercise-filter').val(), 10) || 0; const exercisesToCheck = (currentExerciseFilterId > 0) ? scheduledExercises.filter(ex => ex.ejercicio_id == currentExerciseFilterId) : scheduledExercises; const todayStr = new Date().toISOString().split('T')[0]; if (dateStr > todayStr && !scheduledExercises.length) { cardClasses += ' is-empty'; } else if (exercisesToCheck.length > 0) { const completedCount = exercisesToCheck.filter(ex => fullEvolution[ex.id]?.some(rec => rec.fecha_realizacion === dateStr)).length; percentage = Math.round((completedCount / exercisesToCheck.length) * 100); progressIndicator = createProgressRingSVGModal(percentage, weeklyRadius, weeklyStrokeWidth); } else if(scheduledExercises.length > 0) { progressIndicator = createProgressRingSVGModal(0, weeklyRadius, weeklyStrokeWidth); } else { cardClasses += ' is-empty'; } if (isSelected) cardClasses += ' active'; const card = $(`<div class="${cardClasses}" data-date="${dateStr}"></div>`); card.html(`${progressIndicator}<div class="day-name fw-bold">${DAY_NAMES_MODAL[day.getDay()]}</div><div class="day-number">${day.getDate()}</div>`); carousel.append(card); } modalBodyElement.find('#evo-month-display').text(MONTH_NAMES_MODAL[startOfWeek.getMonth()] + ' ' + startOfWeek.getFullYear()); renderDailyEvolutionFeedback(modalSelectedDateStr); }
        function renderMonthCalendarModal() { const wrapper = modalBodyElement.find('#evo-month-calendar-wrapper'); wrapper.empty(); const date = modalCurrentDate; const month = date.getMonth(); const year = date.getFullYear(); const firstDay = new Date(year, month, 1); const lastDay = new Date(year, month + 1, 0); const lastDayDate = lastDay.getDate(); let startDayOfWeek = (firstDay.getDay() + 6) % 7; const monthlyRadius = 20; const monthlyStrokeWidth = 4; let html = '<table class="table table-bordered text-center month-calendar"><thead><tr class="small text-muted"><th>DL</th><th>DM</th><th>DX</th><th>DJ</th><th>DV</th><th>DS</th><th>DG</th></tr></thead><tbody><tr>'; for (let i = 0; i < startDayOfWeek; i++) { html += '<td class="is-empty"></td>'; } const todayStr = new Date().toISOString().split('T')[0]; for (let day = 1; day <= lastDayDate; day++) { const dateStr = `${year}-${(month + 1).toString().padStart(2, '0')}-${day.toString().padStart(2, '0')}`; const isToday = dateStr === todayStr; let classes = 'day-cell'; let progressIndicator = ''; const scheduledExercises = getScheduledExercisesForDayModal(dateStr); let percentage = 0; const currentExerciseFilterId = parseInt(modalBodyElement.find('#evo-chart-exercise-filter').val(), 10) || 0; const exercisesToCheck = (currentExerciseFilterId > 0) ? scheduledExercises.filter(ex => ex.ejercicio_id == currentExerciseFilterId) : scheduledExercises; if (dateStr > todayStr && !scheduledExercises.length) { classes += ' is-empty'; } else if (exercisesToCheck.length > 0) { const completedCount = exercisesToCheck.filter(ex => fullEvolution[ex.id]?.some(rec => rec.fecha_realizacion === dateStr)).length; percentage = Math.round((completedCount / exercisesToCheck.length) * 100); progressIndicator = createProgressRingSVGModal(percentage, monthlyRadius, monthlyStrokeWidth); } else if (scheduledExercises.length > 0) { progressIndicator = createProgressRingSVGModal(0, monthlyRadius, monthlyStrokeWidth); } else { classes += ' is-empty'; } if (dateStr === modalSelectedDateStr) classes += ' active'; if (isToday) classes += ' today'; html += `<td class="${classes}" data-date="${dateStr}"><div>${progressIndicator}<span class="day-number-month">${day}</span></div></td>`; if ((day + startDayOfWeek) % 7 === 0 && day < lastDayDate) { html += '</tr><tr>'; } } const remainingCells = (7 - ((lastDayDate + startDayOfWeek) % 7)) % 7; for (let i = 0; i < remainingCells; i++) { html += '<td class="is-empty"></td>'; } html += '</tr></tbody></table>'; wrapper.html(html); renderDailyEvolutionFeedback(modalSelectedDateStr); }
        
        // Lógica de actualización de vistas (Semanal vs Mensual)
        function updateModalCalendarView() { 
            if (!treatment) return; 
            modalBodyElement.find('#evo-month-display').text(MONTH_NAMES_MODAL[modalCurrentDate.getMonth()] + ' ' + modalCurrentDate.getFullYear()); 
            
            if (modalViewMode === 'week') { 
                modalBodyElement.find('#evo-week-carousel-container').removeClass('d-none').addClass('d-flex'); 
                modalBodyElement.find('#evo-month-calendar-wrapper').addClass('d-none'); 
                renderWeekCalendarModal(); 
            } else { 
                // Modo Mensual
                modalBodyElement.find('#evo-week-carousel-container').addClass('d-none'); 
                modalBodyElement.find('#evo-month-calendar-wrapper').removeClass('d-none'); 
                renderMonthCalendarModal(); 
            } 
        }
        
        function renderDailyEvolutionFeedback(dateStr) { modalSelectedDateStr = dateStr; const dailyContainer = modalBodyElement.find('#evo-daily-exercises'); const dailyTitle = modalBodyElement.find('#evo-daily-title'); const displayDate = new Date(dateStr + 'T12:00:00').toLocaleDateString('ca-ES', { weekday: 'long', day: 'numeric', month: 'long' }); dailyTitle.text(`Detall per al ${displayDate}`); dailyTitle.tooltip('dispose').tooltip({ title: `Detall per al ${displayDate}` }); const scheduledToday = getScheduledExercisesForDayModal(dateStr); if (scheduledToday.length === 0) { dailyContainer.html('<p class="text-muted text-center fst-italic p-3">No hi havia exercicis programats per a este dia.</p>'); return; } let feedbackHtml = '<ul class="list-group list-group-flush">'; let overallFeedbackRegistered = false; const currentExerciseFilterId = parseInt(modalBodyElement.find('#evo-chart-exercise-filter').val(), 10) || 0; const exercisesToShow = (currentExerciseFilterId > 0) ? scheduledToday.filter(ex => ex.ejercicio_id == currentExerciseFilterId) : scheduledToday; if (exercisesToShow.length === 0 && scheduledToday.length > 0) { dailyContainer.html('<p class="text-muted text-center fst-italic p-3">L\'exercici seleccionat no estava programat per a este dia.</p>'); return; } exercisesToShow.forEach(ex => { const recordsForExercise = fullEvolution[ex.id] || []; const recordForDay = recordsForExercise.find(rec => rec.fecha_realizacion === dateStr); const hasFeedback = !!recordForDay; overallFeedbackRegistered = overallFeedbackRegistered || hasFeedback; feedbackHtml += `<li class="list-group-item d-flex justify-content-between align-items-center flex-wrap ${hasFeedback ? 'has-feedback' : 'no-feedback'}"> <div class="fw-bold">${escapeHtml(ex.title)}</div>`; if (recordForDay) { feedbackHtml += ` <div class="ms-md-auto mt-2 mt-md-0 text-nowrap"> <span class="badge bg-danger rounded-pill me-1" data-bs-toggle="tooltip" title="Dolor Percebut"> <i class="bi bi-heartbreak-fill me-1"></i> ${recordForDay.dolor_percibido ?? 'N/A'} </span> <span class="badge bg-warning text-dark rounded-pill me-1" data-bs-toggle="tooltip" title="Esforç Percebut"> <i class="bi bi-lungs-fill me-1"></i> ${recordForDay.esfuerzo_percibido ?? 'N/A'} </span> ${recordForDay.comentarios ? `<i class="bi bi-chat-left-text-fill text-primary ms-1" data-bs-toggle="tooltip" title="${escapeHtml(recordForDay.comentarios)}"></i>` : ''} </div> `; } else { feedbackHtml += `<div class="ms-md-auto mt-2 mt-md-0"><span class="badge bg-light text-dark">Sense registre</span></div>`; } feedbackHtml += `</li>`; if (recordForDay && recordForDay.comentarios) { feedbackHtml += `<li class="list-group-item pt-0 pb-2 border-0"><small class="text-muted fst-italic ps-3">"${escapeHtml(recordForDay.comentarios)}"</small></li>`; } }); feedbackHtml += '</ul>'; if (!overallFeedbackRegistered && exercisesToShow.length > 0) { feedbackHtml += '<p class="text-muted text-center fst-italic mt-3">No es va registrar feedback per a este dia' + (currentExerciseFilterId > 0 ? ' per a l\'exercici seleccionat.' : '.') + '</p>'; } dailyContainer.html(feedbackHtml); modalBodyElement.find('[data-bs-toggle="tooltip"]').tooltip('dispose').tooltip({ boundary: modalBodyElement[0] }); }

        function prepareChartDataModal() {
            const labels = []; const painData = []; const effortData = []; const commentsList = [];
            if (!treatment || !fullEvolution || Object.keys(fullEvolution).length === 0) return { labels, datasets: [], comments: [] };
            const dataByDate = {};
            const exerciseList = overviewData.exercises || [];
            const currentExerciseFilterId = parseInt(modalBodyElement.find('#evo-chart-exercise-filter').val(), 10) || 0;
            Object.keys(fullEvolution).forEach(te_id_str => {
                const te_id = parseInt(te_id_str, 10);
                const exerciseInfo = exerciseList.find(ex => ex.id == te_id);
                const ejercicio_id_real = exerciseInfo ? exerciseInfo.ejercicio_id : null;
                if (currentExerciseFilterId > 0 && ejercicio_id_real != currentExerciseFilterId) return;
                if (fullEvolution[te_id] && Array.isArray(fullEvolution[te_id])) {
                    fullEvolution[te_id].forEach(record => {
                        const date = record.fecha_realizacion;
                        if (!date) return;
                        if (!dataByDate[date]) dataByDate[date] = { painSum: 0, painCount: 0, effortSum: 0, effortCount: 0, comments: [] };
                        const dolor = (record.dolor_percibido !== null && !isNaN(record.dolor_percibido)) ? Number(record.dolor_percibido) : null;
                        const esfuerzo = (record.esfuerzo_percibido !== null && !isNaN(record.esfuerzo_percibido)) ? Number(record.esfuerzo_percibido) : null;
                        if (dolor !== null) { dataByDate[date].painSum += dolor; dataByDate[date].painCount++; }
                        if (esfuerzo !== null) { dataByDate[date].effortSum += esfuerzo; dataByDate[date].effortCount++; }
                        if (record.comentarios && record.comentarios.trim() !== '') {
                            let title = exerciseInfo ? exerciseInfo.title : `Ex. ID ${te_id}`;
                            dataByDate[date].comments.push({ title: title, text: record.comentarios });
                        }
                    });
                }
            });
            try {
                const startDate = new Date(treatment.start_date + 'T12:00:00');
                const endDate = new Date(treatment.end_date + 'T12:00:00');
                let currentDate = new Date(startDate);
                while (currentDate <= endDate) {
                    const dateStr = currentDate.toISOString().split('T')[0];
                    labels.push(dateStr);
                    if (dataByDate[dateStr]) {
                        painData.push(dataByDate[dateStr].painCount > 0 ? (dataByDate[dateStr].painSum / dataByDate[dateStr].painCount) : null);
                        effortData.push(dataByDate[dateStr].effortCount > 0 ? (dataByDate[dateStr].effortSum / dataByDate[dateStr].effortCount) : null);
                        if (dataByDate[dateStr].comments.length > 0) commentsList.push({ date: dateStr, comments: dataByDate[dateStr].comments });
                    } else { painData.push(null); effortData.push(null); }
                    currentDate.setDate(currentDate.getDate() + 1);
                }
            } catch (dateError) { return { labels: [], datasets: [], comments: [] }; }
            return {
                labels,
                datasets: [{ label: 'Dolor Mitjà (0-5)', data: painData, borderColor: 'rgb(255, 99, 132)', backgroundColor: 'rgba(255, 99, 132, 0.5)', tension: 0.1, spanGaps: true, yAxisID: 'y' }, { label: 'Esforç Mitjà (0-5)', data: effortData, borderColor: 'rgb(54, 162, 235)', backgroundColor: 'rgba(54, 162, 235, 0.5)', tension: 0.1, spanGaps: true, yAxisID: 'y' }],
                comments: commentsList.sort((a, b) => a.date.localeCompare(b.date))
            };
        }

        function renderEvolutionChartModal() { const chartData = prepareChartDataModal(); const ctx = document.getElementById('evolutionChartCanvas'); const commentsContainer = modalBodyElement.find('#evolutionChartComments ul'); const canvasElement = $(ctx); const alertMessage = modalBodyElement.find('#chartNoDataMessage'); commentsContainer.empty(); if (evolutionChartInstance) { evolutionChartInstance.destroy(); evolutionChartInstance = null; } const hasValidData = chartData && chartData.labels.length > 0 && chartData.datasets.some(ds => ds.data.some(val => val !== null && !isNaN(val))); if (!hasValidData) { canvasElement.hide(); alertMessage.removeClass('d-none'); commentsContainer.html('<li>No hi ha dades d\'evolució registrades per a este filtre.</li>'); return; } canvasElement.show(); alertMessage.addClass('d-none'); const chartOptions = { responsive: true, maintainAspectRatio: false, scales: { y: { beginAtZero: true, max: 5, ticks: { stepSize: 1 } }, x: { type: 'time', time: { unit: 'day', tooltipFormat: 'dd MMM yyyy', displayFormats: { day: 'dd MMM' } }, ticks: { maxTicksLimit: Math.min(15, chartData.labels.length), autoSkip: true, maxRotation: 0, minRotation: 0 } } }, plugins: { tooltip: { mode: 'index', intersect: false } }, interaction: { intersect: false, mode: 'index' } }; try { const context = ctx.getContext('2d'); if (!context) throw new Error("No context"); evolutionChartInstance = new Chart(context, { type: 'line', data: chartData, options: chartOptions }); } catch (e) { console.error("Error renderizando gráfico:", e); canvasElement.hide(); alertMessage.removeClass('d-none').text(`Error crític al carregar el gràfic: ${e.message}`); return; } if (chartData.comments.length > 0) { chartData.comments.forEach(entry => { const dateFormatted = new Date(entry.date + 'T12:00:00').toLocaleDateString('ca-ES', { year: 'numeric', month: 'short', day: 'numeric' }); entry.comments.forEach(comment => { commentsContainer.append(`<li><strong>${dateFormatted} (${escapeHtml(comment.title)}):</strong> ${escapeHtml(comment.text)}</li>`); }); }); } else { commentsContainer.html('<li>No hi ha comentaris registrats per a este filtre.</li>'); } }

        modalBodyElement.on('click', '.modal-nav-btn', function() { const direction = $(this).data('direction'); const currentMonth = modalCurrentDate.getMonth(); switch(direction) { case 'prev-week': modalCurrentDate.setDate(modalCurrentDate.getDate() - 7); break; case 'next-week': modalCurrentDate.setDate(modalCurrentDate.getDate() + 7); break; case 'prev-month': modalCurrentDate.setMonth(currentMonth - 1); break; case 'next-month': modalCurrentDate.setMonth(currentMonth + 1); break; } if (modalViewMode === 'week') { const dayOfWeek = modalCurrentDate.getDay(); const diff = modalCurrentDate.getDate() - dayOfWeek + (dayOfWeek === 0 ? -6 : 1); const firstDay = new Date(modalCurrentDate); firstDay.setDate(diff); modalSelectedDateStr = firstDay.toISOString().split('T')[0]; } else { const firstDay = new Date(modalCurrentDate.getFullYear(), modalCurrentDate.getMonth(), 1); modalSelectedDateStr = firstDay.toISOString().split('T')[0]; } updateModalCalendarView(); });
        modalBodyElement.on('click', '.modal-today-btn', function() { modalCurrentDate = new Date(); modalSelectedDateStr = modalCurrentDate.toISOString().split('T')[0]; updateModalCalendarView(); });
        modalBodyElement.on('click', '.modal-view-btn', function() { const newView = $(this).data('view'); if (newView === modalViewMode) return; modalViewMode = newView; modalBodyElement.find('.modal-view-btn').removeClass('active'); $(this).addClass('active'); updateModalCalendarView(); });
        modalBodyElement.on('click', '#evo-day-carousel .day-card:not(.is-empty), #evo-month-calendar-wrapper .day-cell:not(.is-empty)', function() { const dateStr = $(this).data('date'); if (dateStr && dateStr !== modalSelectedDateStr) { modalSelectedDateStr = dateStr; modalCurrentDate = new Date(dateStr + 'T12:00:00'); modalBodyElement.find('.day-card, .day-cell').removeClass('active'); modalBodyElement.find(`.day-card[data-date="${dateStr}"], .day-cell[data-date="${dateStr}"]`).addClass('active'); renderDailyEvolutionFeedback(dateStr); } });
        modalBodyElement.on('change', '#evo-chart-exercise-filter', function() { const selectedExerciseId = $(this).val(); $.getJSON('patient_ajax.php', { ajax: true, action: 'get_full_evolution_data', treatment_id: treatment.id, pacient_id: PATIENT_ID, exercise_id: selectedExerciseId }) .done(response => { if (response.status === 'success') { fullEvolution = response.evolution || {}; updateModalCalendarView(); if ($('#chart-tab').hasClass('active')) renderEvolutionChartModal(); if ($('#calendar-tab').hasClass('active')) renderDailyEvolutionFeedback(modalSelectedDateStr); } else { showToast('Error recarregant dades.', 'danger'); } }).fail(() => showToast('Error de connexió.', 'danger')); });
        const chartTabEl = document.getElementById('chart-tab'); if(chartTabEl) { chartTabEl.addEventListener('shown.bs.tab', renderEvolutionChartModal); chartTabEl.addEventListener('hidden.bs.tab', () => { if (evolutionChartInstance) { evolutionChartInstance.destroy(); evolutionChartInstance = null; } }); }

        updateModalCalendarView();
        modalBodyElement.find('[data-bs-toggle="tooltip"]').tooltip({ boundary: modalBodyElement[0] });
    }

    $(document).on('click', '.view-treatment-btn', function(e) {
        e.preventDefault();
        if ($(this).hasClass('disabled') || !viewTreatmentModal) return;
        const treatmentId = $(this).data('id');
        const modal = $('#viewTreatmentModal');
        const modalBody = modal.find('.modal-body');
        modal.find('.modal-title').text('Carregant detalls...');
        modalBody.html('<div class="text-center p-5"><div class="spinner-border text-primary"></div></div>');
        viewTreatmentModal.show();
        $.getJSON('treatments.php', { ajax: true, action: 'get_treatment_details', id: treatmentId })
            .done(res => {
                const data = res.treatment;
                modal.find('.modal-title').text(data.title);
                let contentHtml = '';
                let headerHtml = `<div class="row mb-4 small">`;
                if (data.paciente_nombre) { headerHtml += `<div class="col-md-6"><h6 class="text-dark mb-1"><i class="bi bi-person-badge me-2"></i>Pacient</h6><p class="ps-3 mb-0">${data.paciente_apellido}, ${data.paciente_nombre}</p></div>`; }
                if (data.creator_fisio_name) { headerHtml += `<div class="col-md-6"><h6 class="text-dark mb-1"><i class="bi bi-person-circle me-2"></i>Creat per</h6><p class="ps-3 mb-0">${data.creator_fisio_name} ${data.creator_fisio_surname}</p></div>`; }
                headerHtml += `</div>`;
                 if (data.status && data.start_date) { headerHtml += `<div class="row mb-4 small"><div class="col-md-6"><h6 class="text-dark mb-1"><i class="bi bi-check-circle me-2"></i>Estat</h6><p class="ps-3 mb-0">${getStatusBadge(data.status)}</p></div><div class="col-md-6"><h6 class="text-dark mb-1"><i class="bi bi-calendar-range me-2"></i>Rang de Dates</h6><p class="ps-3 mb-0">${new Date(data.start_date).toLocaleDateString('ca-ES')} - ${data.end_date ? new Date(data.end_date).toLocaleDateString('ca-ES') : 'N/A'}</p></div></div>`; }
                headerHtml += '<hr>';
                let evaluationHtml = `<h5 class="mb-3">Avaluació Inicial</h5><div class="row mb-4"><div class="col-md-6"><h6><i class="bi bi-file-text me-2"></i>Anamnesi</h6><p class="text-muted ps-4">${data.anamnesis ? escapeHtml(data.anamnesis) : 'No especificat'}</p></div><div class="col-md-6"><h6><i class="bi bi-clipboard-check me-2"></i>Diagnòstic</h6><p class="text-muted ps-4">${data.diagnostico ? escapeHtml(data.diagnostico) : 'No especificat'}</p></div></div><hr>`;
                let exercisesHtml = '';
                if (data.assigned_exercises && data.assigned_exercises.length > 0) {
                    exercisesHtml += `<h5 class="mb-3"><i class="bi bi-list-ol me-2"></i>Pauta d'Exercicis (${data.assigned_exercises.length})</h5><div class="list-group list-group-flush">`;
                    data.assigned_exercises.forEach(ex => {
                         let thumbnailHtml = '';
                        if(ex.video_filename) {
                            const isEmbed = ex.video_filename.startsWith('http');
                            const ytMatch = isEmbed ? ex.video_filename.match(/youtube\.com\/embed\/([a-zA-Z0-9\-_]+)/) : null;
                            thumbnailHtml = isEmbed ? `<img src="${ytMatch ? `https://img.youtube.com/vi/${ytMatch[1]}/mqdefault.jpg` : ''}" class="view-ex-thumb" alt="Miniatura Video">` : `<video src="videos/${ex.video_filename}#t=0.5" class="view-ex-thumb" preload="metadata"></video>`;
                        } else if (ex.image_filename) { thumbnailHtml = `<img src="${getImagePath(ex.image_filename)}" class="view-ex-thumb" alt="Miniatura Imatge">`; } else { thumbnailHtml = `<div class="view-ex-thumb d-flex align-items-center justify-content-center bg-light border"><i class="bi bi-camera-video-off fs-4 text-muted"></i></div>`; }
                        exercisesHtml += `<div class="list-group-item px-0"><div class="d-flex w-100"><div class="flex-shrink-0 me-3">${thumbnailHtml}</div><div class="flex-grow-1"><h6 class="mb-1">${escapeHtml(ex.title)}</h6><p class="mb-1 small"><strong>Pauta:</strong> ${escapeHtml(ex.frecuencia)} | ${escapeHtml(ex.series)} series | ${escapeHtml(ex.repetitions)} reps | ${escapeHtml(ex.rest_time)} descans</p>${ex.pauta_notes ? `<p class="mb-0 small text-muted fst-italic"><strong>Notes:</strong> ${escapeHtml(ex.pauta_notes)}</p>` : ''}</div></div></div>`;
                    });
                    exercisesHtml += `</div>`;
                }
                contentHtml = headerHtml + evaluationHtml + exercisesHtml;
                modalBody.html(contentHtml);
            })
            .fail(xhr => { modalBody.html(`<div class="alert alert-danger">${escapeHtml(xhr.responseJSON?.message || 'Error de connexió.')}</div>`); });
    });

    function handlePatientArchive() {
        const $button = $('#archiveBtn');
        $button.prop('disabled', true).html('<span class="spinner-border spinner-border-sm"></span>');
        $.post('treatments.php', { ajax: true, action: 'personal_archive', id: itemToManage.id }, 'json')
        .done(response => { showToast(response.message, 'success'); bootstrap.Modal.getOrCreateInstance(document.getElementById('manageModal')).hide(); loadPatientTreatments(); })
        .fail(xhr => showToast(xhr.responseJSON?.message || 'Error de connexió.', 'danger'))
        .always(() => { $button.prop('disabled', false).html('Arxivar'); });
    }

    function handlePatientDelete() {
        const manageModalInstance = bootstrap.Modal.getOrCreateInstance(document.getElementById('manageModal'));
        const treatmentName = (itemToManage.name || '').replace(/&#39;/g, "'").replace(/&quot;/g, '"');
        if (prompt(`Per a confirmar l'eliminació PERMANENT de "${treatmentName}", escriu ELIMINAR ací baix:`) === 'ELIMINAR') {
            const $button = $('#deleteBtn');
            $button.prop('disabled', true).html('<span class="spinner-border spinner-border-sm"></span>');
            $.post('treatments.php', { ajax: true, action: 'delete_treatment', id: itemToManage.id }, 'json')
            .done(response => { showToast(response.message, 'success'); manageModalInstance.hide(); loadPatientTreatments(); })
            .fail(xhr => showToast(xhr.responseJSON?.message || 'Error a l\'eliminar.', 'danger'))
            .always(() => { $button.prop('disabled', false).html('Eliminar'); });
        } else { showToast("L'acció d'eliminació ha sigut cancel·lada.", 'info'); }
    }

    $(document).on('click', '.manage-treatment-btn', function(e) {
        e.preventDefault();
        if ($(this).hasClass('disabled')) return;
        itemToManage = { id: $(this).data('id'), name: $(this).data('name') };
        const modal = $('#manageModal');
        $.getJSON('treatments.php', { ajax: true, action: 'check_treatment_usage', id: itemToManage.id }, response => {
            const isActive = response.is_active;
            modal.find('#manageModalLabel').text(`Gestionar: ${escapeHtml(itemToManage.name)}`);
            const modalBody = modal.find('#manageModalBody');
            modalBody.html(`<p>Què vols fer amb el tractament "<strong>${escapeHtml(itemToManage.name)}</strong>"?</p>`);
            if (isActive) { modalBody.append(`<div class="alert alert-warning"><i class="bi bi-exclamation-triangle-fill me-2"></i>Aquest tractament està 'En curs' i no es pot eliminar directament.</div>`); }
            modalBody.append(`<p class="text-muted small"><strong>Arxivar:</strong> L'ocultarà de la teua vista personal sense afectar altres usuaris.</p>`);
            modalBody.append(`<p class="text-muted small"><strong>Eliminar:</strong> Esborrarà el tractament (només si no està 'En Curs').</p>`);
            modal.find('#archiveBtn').off('click').on('click', handlePatientArchive);
            modal.find('#deleteBtn').off('click').on('click', handlePatientDelete);
            modal.find('#deleteBtn').prop('disabled', isActive).attr('title', isActive ? "No es pot eliminar porque està 'En curs'" : 'Eliminar permanentment');
            bootstrap.Modal.getOrCreateInstance(document.getElementById('manageModal')).show();
        }).fail(() => { showToast("Error al comprovar l'estat del tractament.", 'danger'); });
    });

    function initializeApp() {
        $.when(
            $.getJSON('patient_ajax.php', { ajax: true, action: 'get_fisio_dependencies' }),
            $.getJSON('protocols.php', { ajax: true, action: 'read_protocols', limit: 50 })
        ).done(function(depsRes, protocolsRes){
            const deps = depsRes[0];
            if (deps.status === 'success') {
                allFisios = deps.fisios || [];
                let allCategories = deps.categories || [];
                let allTags = deps.tags || [];
                if (typeof initializeTreatmentModalApp === 'function') {
                    pageModalFunctions = initializeTreatmentModalApp({
                        allFisios: allFisios,
                        allCategories: allCategories,
                        allTags: allTags,
                        IS_SUPERADMIN: IS_SUPERADMIN,
                        CURRENT_USER_ID: CURRENT_USER_ID,
                        PATIENT_ID: PATIENT_ID,
                        PATIENT_FULLNAME: PATIENT_FULLNAME,
                        onSaveSuccess: loadPatientTreatments
                    });
                } else { console.error("No se pudo inicializar treatment_modal.js"); }

                const urlParams = new URLSearchParams(window.location.search);
                const actionToTake = urlParams.get('action');
                const protocolIdToAssign = urlParams.get('protocol_id');

                if (actionToTake === 'assign_protocol' && protocolIdToAssign) {
                    if (typeof pageModalFunctions.populateAndOpenModalCRUD === 'function') {
                        showToast('Carregant dades del protocol...', 'info');
                        $.getJSON('patient_ajax.php', { ajax: true, action: 'get_protocol_details_for_assignment', protocol_id: protocolIdToAssign, pacient_id: PATIENT_ID })
                        .done(response => {
                            if (response.status === 'success') {
                                const protocolData = response.protocol;
                                pageModalFunctions.populateAndOpenModalCRUD({
                                    title: `(Protocol) ${protocolData.title}`,
                                    anamnesis: protocolData.anamnesis,
                                    diagnostico: protocolData.diagnostico,
                                    paciente_id: PATIENT_ID,
                                    assigned_exercises: protocolData.assigned_exercises
                                });
                                history.replaceState(null, '', window.location.pathname + `?id=${PATIENT_ID}`);
                                setTimeout(() => {
                                    const datePickerEl = document.getElementById('date_range_picker');
                                    if (datePickerEl) {
                                        datePickerEl.classList.add('flash-warning');
                                        datePickerEl.scrollIntoView({ behavior: 'smooth', block: 'center' });
                                        setTimeout(() => { datePickerEl.classList.remove('flash-warning'); }, 3000);
                                    }
                                }, 500);
                            } else { showToast(response.message || 'Error carregant detalls del protocol.', 'danger'); }
                        })
                        .fail(xhr => showToast(xhr.responseJSON?.message || 'Error de connexió.', 'danger'));
                    } else { showToast("Error: La funció del modal no està disponible.", 'danger'); }
                }
            } else { showToast("Error crític carregant dependències de formularis.", 'danger'); }
            if (protocolsRes[0].status === 'success') { allProtocols = protocolsRes[0].protocols || []; }
            loadPatientTreatments();
        }).fail(function(xhr1, xhr2){
             console.error("Error al cargar dependencias iniciales:", xhr1.responseText, xhr2.responseText);
             showToast("Error crític carregant dades inicials.", 'danger');
             loadPatientTreatments();
        });
    }

    $('#impersonatePatientBtn').on('click', function(e) {
        e.preventDefault();
        if (confirm(`Estàs segur que vols "suplantar" a ${PATIENT_FULLNAME}?\n\nVeuràs la plataforma exactament com la veu aquest pacient. Podràs tornar al teu compte des d'una barra d'advertència superior.`)) {
            window.location.href = `impersonate.php?id=${PATIENT_ID}`;
        }
    });

    initializeApp();
});
</script>
</body>
</html>