<?php
// /stop_impersonating.php
// Finaliza la suplantación de un usuario y restaura la sesión original del admin/fisio

session_start();
require_once 'db.php';
require_once 'logger.php'; // <-- INCLUIDA: Función centralizada de logs

// --- 1. Verificación de Seguridad ---
// Si no hay una sesión de 'admin_origen_id', no hay nada que detener.
if (!isset($_SESSION['admin_origen_id'])) {
    // Si el rol actual es paciente, lo mandamos a su dashboard.
    // Si es admin/fisio, al dashboard de admin.
    $redirect = ($_SESSION['user_rol'] ?? '') === 'paciente' ? 'patient_dashboard.php' : 'dashboard.php';
    header('Location: ' . $redirect);
    exit;
}

// --- 2. Preparar Log y Variables de Restauración (antes de la restauración) ---

// Variables del *ACTOR* (el admin que vuelve a su sesión)
$original_admin_id = $_SESSION['admin_origen_id'];
$original_admin_rol = $_SESSION['admin_origen_rol'];
$original_admin_nombre = $_SESSION['admin_origen_nombre'];
$original_admin_apellido = $_SESSION['admin_origen_apellido'] ?? '';
$return_url = $_SESSION['admin_origen_return_url'] ?? 'users.php';

$actor_username = $original_admin_nombre . ' ' . $original_admin_apellido;


// Variables del *TARGET* (el usuario que se deja de suplantar, que es el que estaba en la sesión activa)
$target_user_id = $_SESSION['user_id'];
$target_user_rol = $_SESSION['user_rol'];
$target_detail = $_SESSION['user_nombre'] . ' ' . ($_SESSION['user_apellido'] ?? '') . ' (Rol: ' . $target_user_rol . ')';


// ★★★ INICIO: REGISTRO DE AUDITORÍA CRÍTICO (A4: IMPERSONATE_STOP) - DELEGACIÓN COMPLETA ★★★
// Los detalles del log son construidos y almacenados por la función helper.
// Parámetros: $db, $admin_id, $admin_name, $target_id, $target_info
registrar_impersonate_stop($db, $original_admin_id, $actor_username, $target_user_id, $target_detail);
// ★★★ FIN: REGISTRO DE AUDITORÍA ★★★


// --- 3. Limpiar todas las variables de sesión de suplantación ---
unset($_SESSION['admin_origen_id']);
unset($_SESSION['admin_origen_rol']);
unset($_SESSION['admin_origen_nombre']);
unset($_SESSION['admin_origen_apellido']);
unset($_SESSION['admin_origen_return_url']);
unset($_SESSION['is_impersonating']);


// --- 4. Restaurar la Sesión Original ---
session_regenerate_id(true); // Regenerar ID de sesión por seguridad

$_SESSION['user_id'] = $original_admin_id;
$_SESSION['user_rol'] = $original_admin_rol;
$_SESSION['user_nombre'] = $original_admin_nombre;
$_SESSION['user_apellido'] = $original_admin_apellido;

// --- 5. Redirección ---
header('Location: ' . $return_url);
exit;
