<!DOCTYPE html>
<html lang="ca">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Termes i Condicions d'Ús - AVANT ONLINE</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
    <link rel="stylesheet" href="../style.css"> <?php // Apunta a la fulla d'estil principal ?>
    <style>
        body { background-color: #f8f9fa; }
        .legal-header {
            background-color: var(--custom-brand-purple, #684987);
            color: white;
            padding: 2rem 0;
        }
        .card-body h3 {
            color: var(--custom-brand-purple, #684987);
            margin-top: 1.5rem;
            margin-bottom: 1rem;
            border-bottom: 2px solid #e9ecef;
            padding-bottom: 0.5rem;
        }
        /* Estil per al text ressaltat */
        mark {
            background-color: #fffb8f; /* Un groc més suau que el per defecte */
            padding: 0.1em 0.3em;
            border-radius: 3px;
            font-weight: 600;
        }
    </style>
</head>
<body>

    <header class="legal-header text-center">
        <div class="container">
            <h1 class="h2 fw-bold"><i class="bi bi-file-text-fill me-2"></i>Termes i Condicions d'Ús</h1>
            <p class="lead mb-0"><mark>Última actualització: 4 de novembre de 2025</mark></p>
            </div>
    </header>

    <main class="container py-5">
        <div class="row justify-content-center">
            <div class="col-lg-10">
                <div class="card shadow-sm border-0">
                    <div class="card-body p-4 p-md-5">

                        <p class="lead">Benvingut/da a AVANT ONLINE. Aquests Termes i Condicions d'Ús ("Termes") regeixen l'accés i l'ús de la plataforma de programari com a servei (SaaS) proporcionada per
                        <mark>[Nom de l'empresa propietària d'AVANT ONLINE]</mark>
                        ("L'Empresa", "nosaltres").</p>

                        <h3>1. Acceptació dels Termes</h3>
                        <p>En registrar-se, accedir o utilitzar la nostra plataforma (ja sigui com a "Professional" o com a "Pacient"), vostè accepta estar vinculat per aquests Termes i per la nostra <a href="politica-privacidad.php">Política de Privacitat</a>. Si no està d'acord amb alguna part dels termes, no podrà utilitzar els nostres serveis.</p>

                        <h3>2. Definicions</h3>
                        <ul>
                            <li><strong>"Plataforma"</strong>: Es refereix al programari AVANT ONLINE, accessible via web i mòbil, que inclou totes les seves funcionalitats, eines i serveis.</li>
                            <li><strong>"Professional"</strong>: Es refereix al fisioterapeuta, clínica o professional sanitari degudament qualificat que contracta els nostres serveis per gestionar els seus pacients. Inclou els rols de "Fisio" i "Superadmin".</li>
                            <li><strong>"Pacient"</strong>: Es refereix a l'usuari final que rep accés a la Plataforma per part d'un Professional per a la realització del seu tractament.</li>
                        </ul>

                        <h3>3. Objecte del Servei</h3>
                        <p>AVANT ONLINE és una eina tecnològica dissenyada per facilitar la tele-rehabilitació. Permetem als Professionals crear i gestionar contingut clínic (exercicis, protocols), assignar tractaments als seus Pacients, monitorar-ne l'evolució i comunicar-s'hi.</p>

                        <h3>4. Termes Específics per a Professionals</h3>

                        <h5 class="fw-bold mt-4">4.1. Responsabilitat Legal i de Dades (RGPD)</h5>
                        <p>Aquesta és la clàusula més important que regeix la nostra relació:</p>
                        <ul>
                            <li>En utilitzar AVANT ONLINE, el Professional actua com a <strong>Responsable del Tractament</strong> de les dades personals i de salut dels seus Pacients.</li>
                            <li>L'Empresa (AVANT ONLINE) actua estrictament com a <strong>Encarregat del Tractament</strong>, limitant-se a proveir la infraestructura tecnològica i processar les dades sota les instruccions del Professional.</li>
                            <li>El Professional garanteix que compta amb totes les autoritzacions legals i el <strong>consentiment explícit</strong> dels seus Pacients per recollir, emmagatzemar i tractar les seves dades (incloses dades de salut) a través de la nostra Plataforma, complint amb el RGPD i la LOPDGDD.</li>
                        </ul>

                        <h5 class="fw-bold mt-4">4.2. Ús Clínic i Contingut</h5>
                        <ul>
                            <li>El Professional és l'únic responsable de la precisió, idoneïtat i legalitat del contingut clínic (exercicis, vídeos, pautes) que puja o crea a la Plataforma.</li>
                            <li>AVANT ONLINE no realitza cap validació mèdica ni es fa responsable del diagnòstic, pauta o consell mèdic que el Professional proporcioni als seus Pacients a través de la Plataforma.</li>
                            <li>El Professional garanteix que posseeix els drets d'autor o les llicències necessàries per a tot el contingut (vídeos, imatges) que puja a la Plataforma.</li>
                        </ul>

                        <h5 class="fw-bold mt-4">4.3. Comptes i Subscripcions</h5>
                        <p>El Professional és responsable de mantenir la confidencialitat de la seva contrasenya.
                        <mark>[Aquí s'han d'incloure els termes de pagament, cicles de facturació, política de reemborsament i cancel·lació de la subscripció del servei SaaS].</mark>
                        </p>

                        <h3>5. Termes Específics per a Pacients</h3>
                        <ul>
                            <li>El seu accés a la Plataforma és gestionat i proporcionat pel seu Professional sanitari.</li>
                            <li><strong>AVANT ONLINE NO ÉS UN PROVEÏDOR MÈDIC.</strong> La Plataforma és una eina de comunicació i seguiment. Qualsevol consell, diagnòstic, pauta d'exercicis o informació clínica prové exclusivament del seu Professional.</li>
                            <li>Vostè no ha d'utilitzar la Plataforma per a emergències mèdiques. Si sent dolor agut o té una emergència, contacti amb el seu metge o els serveis d'emergència immediatament.</li>
                            <li>És la seva responsabilitat utilitzar la Plataforma de bona fe i seguir les indicacions del seu Professional.</li>
                        </ul>

                        <h3>6. Propietat Intel·lectual</h3>
                        <p>El programari, codi font, logotips i marques d'AVANT ONLINE són propietat exclusiva de
                        <mark>[Nom de l'empresa propietària d'AVANT ONLINE]</mark>.
                        El contingut clínic pujat per un Professional és propietat d'aquest Professional.</p>

                        <h3>7. Limitació de Responsabilitat</h3>
                        <p>AVANT ONLINE es proporciona "tal qual". No garantim que la Plataforma estigui lliure d'errors o interrupcions. En la mesura que la llei ho permeti, l'Empresa no serà responsable de cap dany indirecte, incidental o lucratiu cessant derivat de:</p>
                        <ul>
                            <li>Un diagnòstic o tractament incorrecte proporcionat per un Professional.</li>
                            <li>Una lesió soferta per un Pacient durant la realització d'un exercici.</li>
                            <li>La pèrdua de dades o la interrupció del servei.</li>
                        </ul>

                        <h3>8. Modificació i Legislació</h3>
                        <p>Ens reservem el dret de modificar aquests Termes en qualsevol moment. Qualsevol disputa es regirà per les lleis d'Espanya i se sotmetrà a la jurisdicció dels tribunals de
                        <mark>[Ciutat de la teva empresa]</mark>.
                        </p>

                        <hr class="my-5">
                        <div class="text-center">
                            <a href="../index.php" class="btn btn-outline-primary mt-3">
                                <i class="bi bi-arrow-left me-2"></i>Tornar a l'inici
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </main>

    <footer class="text-center py-4 mt-5">
        <span class="text-muted">&copy; <?= date('Y') ?> AVANT ONLINE. Tots els drets reservats.</span>
    </footer>

</body>
</html>
