<!DOCTYPE html>
<html lang="ca">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Política de Privacitat - AVANT ONLINE</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
    <link rel="stylesheet" href="../style.css"> <?php // Apunta a la fulla d'estil principal ?>
    <style>
        body { background-color: #f8f9fa; }
        .legal-header {
            background-color: var(--custom-brand-purple, #684987);
            color: white;
            padding: 2rem 0;
        }
    </style>
</head>
<body>

    <header class="legal-header text-center">
        <div class="container">
            <h1 class="h2 fw-bold"><i class="bi bi-shield-lock-fill me-2"></i>Política de Privacitat</h1>
            <p class="lead mb-0">La teva informació està protegida amb nosaltres.</p>
        </div>
    </header>

    <main class="container py-5">
        <div class="row justify-content-center">
            <div class="col-lg-10">
                <div class="card shadow-sm border-0">
                    <div class="card-body p-4 p-md-5">

                        <div class="alert alert-warning border-warning border-2" role="alert">
                            <h4 class="alert-heading"><i class="bi bi-info-circle-fill me-2"></i>Informació Clau per a Pacients</h4>
                            <p>AVANT ONLINE és una plataforma tecnològica (SaaS) que proporciona eines de programari a professionals sanitaris (fisioterapeutes, clíniques, etc.) per a la gestió dels seus tractaments.</p>
                            <hr>
                            <p class="mb-0">D'acord amb el Reglament General de Protecció de Dades (RGPD) i la Llei Orgànica de Protecció de Dades (LOPDGDD), t'informem que:</p>
                            <ul>
                                <li>El <strong>Responsable del Tractament</strong> de les teves dades personals i de salut és el <strong>professional sanitari o la clínica</strong> que t'ha donat accés a aquesta plataforma. Ell és qui pren les decisions sobre el teu tractament i les teves dades.</li>
                                <li class="mt-2"><strong>AVANT ONLINE</strong> actua únicament com a <strong>Encarregat del Tractament</strong>. La nostra funció es limita a processar les teves dades de forma segura en nom del teu professional sanitari i seguint estrictament les seves instruccions, sense utilitzar-les per a cap finalitat pròpia.</li>
                            </ul>
                            <p class="mt-3 fw-bold">Per a qualsevol sol·licitud sobre els teus drets (accés, rectificació, supressió, etc.) sobre les teves dades de salut, has de contactar directament amb el teu professional o clínica responsable.</p>
                        </div>

                        <h3 class="mt-5">1. Qui som?</h3>

                        <?php // --- INICI DE LA MODIFICACIÓ --- ?>
                        <p>AVANT ONLINE Som un equip de fisioterapeutes compromesos amb la salut, el benestar i la qualitat de vida de cada pacient, oferint un tracte humà i personalitzat a Alberic, Castelló i voltants.</p>
                        <p>Més informació a la pàgina web d'<a href="https://www.avantfisioterapia.com/" target="_blank" rel="noopener noreferrer">AVANT Fisioteràpia</a>.</p>
                        <?php // --- FI DE LA MODIFICACIÓ --- ?>

                        <h3 class="mt-4">2. Quines dades recollim?</h3>
                        <p>Recollim les dades que tu o el teu professional introduïu a la plataforma, com ara dades identificatives (nom, email), dades de contacte (telèfon) i dades de salut (evolucions, comentaris, valoracions de dolor...).</p>

                        <h3 class="mt-4">3. Finalitat del tractament</h3>
                        <p>Com a Encarregats del Tractament, l'única finalitat és oferir el servei de tele-rehabilitació contractat pel teu professional sanitari (el Responsable del Tractament).</p>

                        <h3 class="mt-4">4. Conservació de les dades</h3>
                        <p>Les dades es conservaran mentre el teu professional sanitari mantingui el seu compte actiu a la plataforma. Un cop ell decideixi eliminar el teu compte o el seu propi, les dades seran eliminades de forma segura...</p>

                        <?php // ... Aquí continuaries amb la resta de la teva política de privacitat ... ?>

                        <hr class="my-5">

                        <div class="text-center">
                            <p class="text-muted">Per a més informació, pots consultar els nostres <a href="terminos-de-uso.php">Termes d'Ús</a>.</p>
                            <a href="../index.php" class="btn btn-outline-primary mt-3">
                                <i class="bi bi-arrow-left me-2"></i>Tornar a l'inici
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </main>

    <footer class="text-center py-4 mt-5">
        <span class="text-muted">&copy; <?= date('Y') ?> AVANT ONLINE. Tots els drets reservats.</span>
    </footer>

</body>
</html>
