<?php // ESTA DEBE SER LA PRIMERA LÍNEA EXACTA DEL ARCHIVO
// /chat_patient.php

session_start();
if (!isset($_SESSION['user_id']) || $_SESSION['user_rol'] !== 'paciente') {
    // Línea 6 - Verificada sin caracteres extraños
    header('Location: index.php');
    exit;
}

require 'db.php';
require_once 'logger.php'; // ★★★ AÑADIDO: Incluir logger.php ★★★

$patient_id = $_SESSION['user_id'];
$patient_name = $_SESSION['user_nombre'] . ' ' . $_SESSION['user_apellido']; // ★★★ AÑADIDO: Obtener nombre completo del actor ★★★

$page_title = "Missatges - AVANT ONLINE";

// --- ★ INICIO CORRECCIÓN BUG CHAT (Lógica Simétrica) ★ ---
// Esta consulta ahora usa la misma lógica que chat_inbox.php,
// asegurando que si un fisio ve al paciente, el paciente ve al fisio.
$stmt = $db->prepare("
    SELECT
        c.id,
        c.nombre,
        c.apellido,
        ccv.deleted_until, -- Obtenemos la fecha de borrado si existe para este usuario

        -- Subconsulta para last_message, considerando deleted_until
        (SELECT cm.body FROM chat_messages cm
         WHERE ((cm.from_id = c.id AND cm.to_id = :patient_id) OR (cm.from_id = :patient_id AND cm.to_id = c.id))
           -- Condición: Mostrar mensaje solo si NO ha sido borrado O si el mensaje es MÁS NUEVO que la fecha de borrado
           AND (ccv.user_id IS NULL OR cm.created_at > ccv.deleted_until)
         ORDER BY cm.created_at DESC LIMIT 1) as last_message,

        -- Subconsulta para last_message_time, considerando deleted_until (misma lógica)
        (SELECT cm.created_at FROM chat_messages cm
         WHERE ((cm.from_id = c.id AND cm.to_id = :patient_id) OR (cm.from_id = :patient_id AND cm.to_id = c.id))
           AND (ccv.user_id IS NULL OR cm.created_at > ccv.deleted_until)
         ORDER BY cm.created_at DESC LIMIT 1) as last_message_time,

        -- El contador de no leídos AHORA cuenta 1 si hay > 0, o 0 si no hay
        (SELECT CASE WHEN COUNT(*) > 0 THEN 1 ELSE 0 END
         FROM chat_messages cm
         WHERE cm.from_id = c.id AND cm.to_id = :patient_id AND cm.status != 'read') as unread_count
    FROM
        cuentas c
    LEFT JOIN chat_conversation_visibility ccv -- Unimos para acceder a deleted_until en las subconsultas
        ON ccv.user_id = :patient_id AND ccv.other_user_id = c.id
    WHERE
        c.rol IN ('fisio', 'superadmin')
        -- Criterio de vinculación:
        -- El fisio/admin (c.id) debe estar vinculado AL MENOS a UN tratamiento 'En curs'
        -- del paciente, ya sea como creador o colaborador asignado.
        AND EXISTS (
            SELECT 1
            FROM tratamientos t
            LEFT JOIN tratamiento_fisios_asignados tfa ON t.id = tfa.tratamiento_id
            WHERE
                t.paciente_id = :patient_id
                AND t.status = 'En curs'
                AND (
                    t.creator_fisio_id = c.id       -- 1. Es el creador
                    OR tfa.fisio_id = c.id         -- 2. Es un colaborador asignado
                    -- 3. Se elimina la condición de 'id_fisio_registrador'
                )
        )
    GROUP BY c.id
    ORDER BY COALESCE(last_message_time, '1970-01-01') DESC, c.apellido, c.nombre
");
// --- ★ FIN CORRECCIÓN BUG CHAT ★ ---

$stmt->execute([':patient_id' => $patient_id]);
$fisios = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Determina el fisio activo: SOLO el de la URL, o 0 si no hay
$active_fisio_id = 0;
if (isset($_GET['fisio_id'])) {
    // Validar que el fisio_id de la URL está en la lista permitida obtenida por la consulta
    foreach ($fisios as $f) {
        if ($f['id'] == $_GET['fisio_id']) {
            $active_fisio_id = (int)$_GET['fisio_id'];
            break;
        }
    }
}

// AHORA INCLUIMOS EL HEADER (QUE CALCULARÁ LAS NOTIFICACIONES)
include 'partials/header_patient.php';
?>

<link rel="stylesheet" href="chat_interface.css">

<main class="main-content container mt-4">

    <div class="d-flex justify-content-between align-items-center mb-3">
        <h3><i class="bi bi-chat-dots-fill me-2" style="color: var(--custom-primary-teal);"></i>Xat</h3>
        <a href="patient_dashboard.php" class="btn btn-sm btn-outline-secondary" title="Tornar al Portal">
            <i class="bi bi-arrow-left me-1"></i> Tornar
        </a>
    </div>
    <div class="card shadow-sm">
        <div class="card-body p-0">
            <div class="chat-app">

                <div class="chat-sidebar">
                    <div class="chat-sidebar-header">
                        <div class="input-group">
                            <span class="input-group-text bg-light border-0"><i class="bi bi-search"></i></span>
                            <input type="text" id="contactSearchInput" class="form-control bg-light border-0" placeholder="Cercar fisioterapeutes...">
                        </div>
                    </div>

                    <ul class="chat-contacts-list" id="conversations-list">
                        <?php if (empty($fisios)): ?>
                            <li class="text-muted text-center p-3 small">
                                No tens fisioterapeutes assignats a tractaments actius.
                            </li>
                        <?php else: ?>
                            <?php foreach ($fisios as $fisio): ?>
                                <?php
                                $initials = strtoupper(mb_substr($fisio['nombre'] ?? '', 0, 1) . mb_substr($fisio['apellido'] ?? '', 0, 1));

                                // Lógica para previsualizar mensaje de imagen
                                $last_message_display = '';
                                $last_message_title = '';
                                if (empty($fisio['last_message']) && !empty($fisio['deleted_until'])) {
                                    $last_message_display = '<i>Historial buit...</i>'; // Usamos cursiva para diferenciar
                                } elseif (!empty($fisio['last_message'])) {
                                    if (strpos($fisio['last_message'], 'img:') === 0) {
                                         $last_message_display = '[Imatge enviada]';
                                         $last_message_title = '[Imatge enviada]';
                                    } else {
                                         $last_message_display = htmlspecialchars($fisio['last_message']);
                                         $last_message_title = htmlspecialchars($fisio['last_message']);
                                    }
                                } else {
                                    $last_message_display = 'Cap missatge encara...';
                                    $last_message_title = 'Cap missatge encara...';
                                }
                                ?>
                                <li class="chat-contact conversation-item <?= $fisio['id'] == $active_fisio_id ? 'active' : '' ?>"
                                    data-fisio-id="<?= $fisio['id'] ?>"
                                    data-fisio-name="<?= htmlspecialchars($fisio['nombre'] . ' ' . $fisio['apellido']) ?>">

                                    <div class="initial-circle me-3"><?= htmlspecialchars($initials) ?></div>

                                    <div class="contact-info">
                                        <strong><?= htmlspecialchars($fisio['nombre'] . ' ' . $fisio['apellido']) ?></strong>

                                        <div class="text-muted small text-truncate last-message"
                                             title="<?= $last_message_title ?>">
                                            <?= $last_message_display ?>
                                        </div>
                                        </div>

                                    <button class="btn btn-sm btn-outline-danger ms-2 delete-conversation-btn-patient"
                                            data-fisio-id="<?= $fisio['id'] ?>"
                                            title="Buidar historial de conversa"
                                            style="padding: 0.1rem 0.4rem; font-size: 0.8rem;">
                                        <i class="bi bi-trash3" style="pointer-events: none;"></i>
                                    </button>

                                    <?php if ($fisio['unread_count'] > 0): ?>
                                        <span class="badge bg-danger rounded-pill unread-badge flex-shrink-0 ms-2"><?= $fisio['unread_count'] ?></span>
                                    <?php endif; ?>
                                </li>
                            <?php endforeach; ?>
                        <?php endif; ?>
                    </ul>
                </div>
                <div class="chat-main">
                    <div class="chat-header d-flex align-items-center" id="chat-header">

                        <a class="back-to-list-btn" id="back-to-chat-list-patient" href="#">
                            <i class="bi bi-arrow-left"></i>
                        </a>
                        <div class="d-flex flex-column flex-grow-1">
                            <h5 class="mb-0">
                                <?php
                                $active_fisio_name = "Selecciona una conversa";
                                if ($active_fisio_id > 0) {
                                    foreach ($fisios as $f) {
                                        if ($f['id'] == $active_fisio_id) {
                                            $active_fisio_name = htmlspecialchars($f['nombre'] . ' ' . $f['apellido']);
                                            break;
                                        }
                                    }
                                }
                                echo $active_fisio_name;
                                ?>
                            </h5>
                            <div id="fisio-status-display" style="height: 1.2rem;">
                                </div>
                        </div>
                         </div>
                    <div class="chat-body" id="chat-body">
                        <?php if ($active_fisio_id == 0 && !empty($fisios)): ?>
                            <div class="d-flex h-100 justify-content-center align-items-center">
                                <div class="text-center text-muted">
                                    <i class="bi bi-chat-dots" style="font-size: 4rem;"></i>
                                    <p>Selecciona un fisioterapeuta per veure els missatges.</p>
                                </div>
                            </div>
                        <?php elseif (empty($fisios)): ?>
                             <div class="d-flex h-100 justify-content-center align-items-center">
                                <div class="text-center text-muted">
                                    <i class="bi bi-person-x" style="font-size: 4rem;"></i>
                                    <p>No hi ha fisioterapeutes disponibles per xatejar.</p>
                                </div>
                            </div>
                         <?php endif; // Mensajes se cargarán via JS ?>
                    </div>
                     <div class="chat-footer" id="chat-footer" style="<?= $active_fisio_id > 0 ? '' : 'display: none;' ?>">
                        <form id="message-form" class="d-flex">
                            <button type="button" class="btn btn-outline-secondary me-2" id="attach-file-btn" title="Adjuntar Imatge">
                                <i class="bi bi-paperclip"></i>
                            </button>
                            <input type="file" id="image-input-file" accept="image/jpeg,image/png,image/gif" style="display: none;">
                            <input type="text" id="message-input" class="form-control" placeholder="Escriu el teu missatge..." autocomplete="off">
                            <button type="submit" class="btn btn-primary ms-2"><i class="bi bi-send-fill"></i></button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</main>

<div class="modal fade" id="imagePreviewModal" tabindex="-1" aria-labelledby="imagePreviewModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="imagePreviewModalLabel">Imatge Adjunta</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Tancar"></button>
            </div>
            <div class="modal-body text-center">
                <img src="" id="modal-preview-image" class="img-fluid" alt="Previsualització d'imatge" style="max-height: 80vh;">
            </div>
        </div>
    </div>
</div>
<?php include 'partials/footer.php'; ?>

<script>
$(document).ready(function() {
    const PATIENT_ID = <?= $patient_id ?>;
    let activeFisioId = <?= $active_fisio_id ?>;
    let chatInterval;
    let isPollingActive = true;

    // --- INICIO MODIFICACIÓN (Añadir semáforo global) ---
    // Esta variable global será usada por footer.php para saber si el chat está ocupado
    window.isChatLoading = false;
    // --- FIN MODIFICACIÓN ---

    let deletePatientChatModal = null;
    if ($('#deleteChatPatientModal').length) {
         deletePatientChatModal = new bootstrap.Modal(document.getElementById('deleteChatPatientModal'));
    }

    // --- ======================================================= ---
    // --- [INICIO] CAMBIO 1: INICIALIZAR EL MODAL MANUALMENTE
    // --- ======================================================= ---
    let imagePreviewModalInstance = null;
    if ($('#imagePreviewModal').length) {
        imagePreviewModalInstance = new bootstrap.Modal(document.getElementById('imagePreviewModal'));

        // Opcional: Limpiar el src al cerrar para evitar "flash" de la imagen anterior
        $('#imagePreviewModal').on('hidden.bs.modal', function () {
            $(this).find('#modal-preview-image').attr('src', '');
        });
    }
    // --- ======================================================= ---
    // --- [FIN] CAMBIO 1
    // --- ======================================================= ---


    // --- FUNCIONES DEL CHAT ---
    function getStatusIcon(status) {
        if (status === 'read') return '<i class="bi bi-check2-all text-primary" title="Llegit"></i>';
        if (status === 'delivered') return '<i class="bi bi-check2-all" title="Entregat"></i>';
        if (status === 'sent') return '<i class="bi bi-check2" title="Enviat"></i>';
        return '';
    }

    function formatTimestamp(datetime) {
        if (!datetime) return '';
        try {
             // Modificado para asegurar compatibilidad entre Chrome (con Z) y Safari (sin Z)
             const date = new Date(datetime.endsWith('Z') ? datetime : datetime.replace(' ', 'T'));
             if (isNaN(date)) return '';
             return date.toLocaleTimeString('ca-ES', { hour: '2-digit', minute: '2-digit' });
        } catch (e) { console.error("Error formatting date:", datetime, e); return ''; }
    }

    function escapeHtml(text) { // Añadida función escapeHtml por si no está global
        if (typeof text !== 'string') return '';
        const map = { '&': '&amp;', '<': '&lt;', '>': '&gt;', '"': '&quot;', "'": '&#039;' };
        return text.replace(/[&<>"']/g, m => map[m]);
    }

    function renderFisioStatus(lastSeenTimestamp) {
        const statusElement = $('#fisio-status-display');
        if (!statusElement.length) return;

        if (lastSeenTimestamp) {
            try {
                // Asumimos que el timestamp de SQLite es UTC y necesita 'Z'
                const lastSeenDate = new Date(lastSeenTimestamp.replace(' ', 'T') + 'Z');
                const now = new Date();

                const diffMinutes = Math.floor((now - lastSeenDate) / 60000);

                if (diffMinutes < 3) {
                    statusElement.html('<span class="text-success small fw-bold" style="font-size: 0.8rem;"><i class="bi bi-circle-fill" style="font-size: 0.6rem;"></i> Conectat</span>');
                } else if (diffMinutes < 60) {
                    statusElement.html(`<span class="text-muted small" style="font-size: 0.8rem;">Últ. vegada: fa ${diffMinutes} min</span>`);
                } else if (diffMinutes < 1440) {
                    statusElement.html(`<span class="text-muted small" style="font-size: 0.8rem;">Últ. vegada: fa ${Math.floor(diffMinutes / 60)} h</span>`);
                } else {
                    statusElement.html(`<span class="text-muted small" style="font-size: 0.8rem;">Últ. vegada: ${lastSeenDate.toLocaleDateString()}</span>`);
                }
            } catch(e) {
                 console.error("Error parsing lastSeenDate:", lastSeenTimestamp, e);
                 statusElement.html('<span class="text-muted small" style="font-size: 0.8rem;">Últ. vegada: desconegut</span>');
            }
        } else {
            statusElement.html('<span class="text-muted small" style="font-size: 0.8rem;">Últ. vegada: desconegut</span>');
        }
    }


    // --- ★ INICIO MODIFICACIÓN: renderMessage (para formato gris/cursiva) ---
    function renderMessage(msg) {
        const isMe = msg.from_id == PATIENT_ID;
        const alignClass = isMe ? 'message-sent' : 'message-received';
        const statusIcon = isMe ? getStatusIcon(msg.status) : '';
        let bodyContent;
        const rawBody = msg.body || '';

        // Comprobar si el mensaje es una imagen
        if (rawBody.startsWith('img:')) {
            const filename = rawBody.substring(4);

            if (filename.startsWith('(Càrrega...')) {
                 bodyContent = `<p class="mb-0 text-muted"><span class="spinner-border spinner-border-sm me-2"></span>Enviant imatge...</p>`;
            } else {
                 const imagePath = `chat_img/${filename}`;
                 const deleteButtonHtml = isMe ? `
                     <button class="btn btn-danger btn-sm delete-image-btn"
                             data-message-id="${msg.id}"
                             title="Eliminar imatge permanentment">
                         <i class="bi bi-trash3" style="pointer-events: none;"></i>
                     </button>
                 ` : '';

                 bodyContent = `
                     <a href="#" class="chat-image-link"
                        data-image-src="${imagePath}"
                        title="Ampliar imatge">
                         <img src="${imagePath}" class="chat-image-preview" alt="Imatge adjunta"/>
                         ${deleteButtonHtml}
                     </a>
                 `;
            }

        // ★ NUEVO: Comprobar si es un mensaje de feedback con formato
        } else if (rawBody.startsWith('Sobre el ejercicio "') && rawBody.includes('\n')) {

            // Lo partimos por el primer salto de línea
            const parts = rawBody.split('\n');
            const contextLine = escapeHtml(parts[0]);
            const messageLines = escapeHtml(parts.slice(1).join('\n')).replace(/\n/g, '<br>');

            // Generamos el HTML con el formato gris/cursiva
            bodyContent = `
                <p class="fst-italic text-muted" style="font-size: 0.9em; margin-bottom: 4px; opacity: 0.8;">
                    ${contextLine}
                </p>
                <p class="mb-0">${messageLines}</p>
            `;

        } else {
            // Mensaje de texto normal
            bodyContent = escapeHtml(rawBody).replace(/\n/g, '<br>');
        }

        return `
            <div class="message ${alignClass}" data-message-id="${msg.id || ('temp-' + Date.now())}">
                <div class="message-body">${bodyContent}</div>
                <div class="message-meta">
                    <span class="timestamp">${formatTimestamp(msg.created_at)}</span>
                    <span class="status-icon">${statusIcon}</span>
                </div>
            </div>`;
    }
    // --- ★ FIN MODIFICACIÓN: renderMessage ---


    // ****** MODIFICADO: loadMessages ahora llama a checkUnreadMessages después de cargar ******
    function loadMessages(fisioId) {

        // --- INICIO MODIFICACIÓN (Activar semáforo) ---
        // Informar a footer.php que el chat está ocupado
        window.isChatLoading = true;
        // --- FIN MODIFICACIÓN ---

        if (!fisioId || fisioId == 0) {
            $('#chat-header h5').text("Selecciona una conversa");
            $('#fisio-status-display').empty();
            $('#chat-footer').hide();
            const listIsEmpty = $('#conversations-list').children(':not(.text-muted)').length === 0;
            const placeholderHtml = listIsEmpty ? `
                <div class="d-flex h-100 justify-content-center align-items-center">
                    <div class="text-center text-muted">
                         <i class="bi bi-person-x" style="font-size: 4rem;"></i>
                         <p>No hi ha fisioterapeutes disponibles per xatejar.</p>
                    </div>
                </div>` : `
                <div class="d-flex h-100 justify-content-center align-items-center">
                    <div class="text-center text-muted">
                        <i class="bi bi-chat-dots" style="font-size: 4rem;"></i>
                        <p>Selecciona un fisioterapeuta per veure els missatges.</p>
                    </div>
                </div>`;
            $('#chat-body').html(placeholderHtml);
            clearInterval(chatInterval);
            activeFisioId = 0;

            window.isChatLoading = false; // <-- MODIFICACIÓN: Desactivar semáforo

            // ★★★ AÑADIDO: Salir del modo conversación
            $('.chat-app').removeClass('modo-conversacion');
            return;
        }

        // Si ya está activo, solo quitamos el badge y llamamos a checkUnread
        if (fisioId === activeFisioId && $('#chat-body').children().length > 0 && !$('#chat-body').find('.spinner-border').length) {
             console.log("loadMessages skipped: Fisio already active.");
             $(`.conversation-item[data-fisio-id=${fisioId}]`).find('.unread-badge').remove(); // Quitar badge si se hace clic

             // --- INICIO MODIFICACIÓN: Actualizar contador general ---
             // Añadimos un pequeño delay para asegurar que el DOM del header esté listo
             setTimeout(function() {
                if (typeof checkUnreadMessages === 'function') {
                    checkUnreadMessages(true); // <-- MODIFICADO: Añadido 'true' para forzar
                }
             }, 100); // 100ms delay
             // --- FIN MODIFICACIÓN ---

             if(!chatInterval) startPolling(); // Reiniciar polling si estaba parado

             window.isChatLoading = false; // <-- MODIFICACIÓN: Desactivar semáforo

             // ★★★ AÑADIDO: Forzar modo conversación si no estaba (ej. al recargar)
             $('.chat-app').addClass('modo-conversacion');
             return;
        }

        // Si es un fisio diferente o es la primera carga
        clearInterval(chatInterval);
        isPollingActive = false;
        activeFisioId = fisioId;

        // ★★★ AÑADIDO: Activar modo conversación en móvil ★★★
        $('.chat-app').addClass('modo-conversacion');

        const $activeListItem = $(`.conversation-item[data-fisio-id=${activeFisioId}]`);
        const fisioName = $activeListItem.length ? $activeListItem.data('fisio-name') : "Conversa";

        $('.conversation-item').removeClass('active');
        if($activeListItem.length) $activeListItem.addClass('active');
        $activeListItem.find('.unread-badge').remove();

        // --- INICIO MODIFICACIÓN: Llamar a checkUnreadMessages aquí también (para quitar el badge) ---
         setTimeout(function() {
             if (typeof checkUnreadMessages === 'function') {
               checkUnreadMessages(true); // <-- MODIFICADO: Añadido 'true' para forzar
             }
         }, 100); // Delay
        // --- FIN MODIFICACIÓN ---

        $('#chat-header h5').text(fisioName);
        $('#fisio-status-display').html('<span class="text-muted small" style="font-size: 0.8rem;">Cargando estado...</span>');
        $('#chat-footer').show();
        $('#chat-body').html('<div class="d-flex h-100 justify-content-center align-items-center"><div class="spinner-border text-primary"></div></div>');

        history.pushState(null, '', `chat_patient.php?fisio_id=${fisioId}`);

        $.getJSON('patient_ajax.php', { ajax: true, action: 'get_chat_messages', fisio_id: fisioId }) // <-- CORREGIDO
            .done(function(response) {
                if (fisioId !== activeFisioId) {
                    window.isChatLoading = false; // <-- MODIFICACIÓN: Desactivar semáforo (Race condition)
                    return;
                }

                if (response.status === 'success') {

                    renderFisioStatus(response.fisio_last_seen);

                    const chatBody = $('#chat-body');
                    chatBody.empty();
                    if (response.messages && response.messages.length > 0) {
                        response.messages.forEach(msg => chatBody.append(renderMessage(msg)));
                    } else {
                        chatBody.html('<p class="text-center text-muted mt-3">Comença a escriure per iniciar la conversa.</p>');
                    }
                    setTimeout(() => {
                        if (chatBody.prop("scrollHeight") > chatBody.outerHeight()) {
                             chatBody.scrollTop(chatBody.prop("scrollHeight"));
                        }
                    }, 50);
                    isPollingActive = true;
                    startPolling();

                    // --- INICIO MODIFICACIÓN: Llamar checkUnreadMessages DESPUÉS de cargar mensajes ---
                    setTimeout(function() {
                        if (typeof checkUnreadMessages === 'function') {
                             checkUnreadMessages(true); // <-- MODIFICADO: Añadido 'true' para forzar
                        }
                    }, 100); // Delay
                    // --- FIN MODIFICACIÓN ---

                } else {
                     $('#chat-body').html('<p class="text-danger text-center">Error: '+(response.message || 'No s\'han pogut carregar els missatges.')+'</p>');
                     $('#fisio-status-display').empty();
                }
            })
            .fail(() => {
                if (fisioId === activeFisioId) {
                    $('#chat-body').html('<p class="text-danger text-center">Error de connexió.</p>');
                    $('#fisio-status-display').empty();
                }
            })
            // --- INICIO MODIFICACIÓN (Añadir .always() para desactivar semáforo) ---
            .always(() => {
                // Informar a footer.php que el chat ha terminado de cargar (éxito o fallo)
                window.isChatLoading = false;
            });
            // --- FIN MODIFICACIÓN ---
    }
    // ****** FIN loadMessages MODIFICADO ******

    function checkUpdates() {
        if (!isPollingActive || !activeFisioId || document.hidden) return;

        const requestFisioId = activeFisioId;

        $.getJSON('patient_ajax.php', { ajax: true, action: 'check_chat_updates', fisio_id: requestFisioId }) // <-- CORREGIDO
            .done(function(response) {
                if (activeFisioId !== requestFisioId) return; // Race condition

                if (response.status !== 'success') return;

                const chatBody = $('#chat-body');
                let shouldScroll = false;
                let addedMessages = false;

                if (response.new_messages && response.new_messages.length > 0) {
                    if (chatBody.find('p.text-muted').length > 0 && chatBody.find('.message').length === 0) {
                        chatBody.empty();
                    }
                    response.new_messages.forEach(msg => {
                        if ($(`.message[data-message-id=${msg.id}]`).length === 0) {
                            chatBody.append(renderMessage(msg));
                            shouldScroll = true;
                            addedMessages = true;
                        }
                    });
                     // --- INICIO MODIFICACIÓN: Llamar checkUnreadMessages si hubo mensajes nuevos ---
                     if (addedMessages) {
                         setTimeout(function() {
                             if (typeof checkUnreadMessages === 'function') {
                                 checkUnreadMessages(true); // <-- MODIFICADO: Añadido 'true' para forzar
                             }
                         }, 100); // Delay
                     }
                     // --- FIN MODIFICACIÓN ---
                }

                if (response.status_updates && response.status_updates.length > 0) {
                    response.status_updates.forEach(update => {
                        $(`.message-sent[data-message-id=${update.id}] .status-icon`).html(getStatusIcon(update.status));
                    });
                }

                 if (shouldScroll) {
                    const scrollThreshold = 150;
                    const isScrolledNearBottom = chatBody.prop('scrollHeight') - chatBody.scrollTop() - chatBody.outerHeight() < scrollThreshold;
                    if (isScrolledNearBottom) {
                        chatBody.animate({ scrollTop: chatBody.prop("scrollHeight") }, 300);
                    }
                 }

                 if (addedMessages && response.new_messages.length > 0) {
                      const lastNewMsg = response.new_messages[response.new_messages.length - 1];
                      const $listItem = $(`.conversation-item[data-fisio-id=${activeFisioId}]`);
                      if ($listItem.length > 0) {
                           let lastMessagePreview = lastNewMsg.body;
                           if (lastMessagePreview.startsWith('img:')) {
                               lastMessagePreview = "[Imatge enviada]";
                           } else {
                               lastMessagePreview = escapeHtml(lastMessagePreview);
                           }

                           $listItem.find('.last-message').text(lastMessagePreview).prop('title', lastMessagePreview);
                           $listItem.prependTo('#conversations-list'); // Mover al principio
                      }
                 }
            })
            .fail(function() { console.warn("Error checking for chat updates."); });
    }

    function startPolling() {
        clearInterval(chatInterval);
        if (activeFisioId && isPollingActive && !document.hidden) {
            console.log("Starting polling for fisioId:", activeFisioId);
            checkUpdates();
            chatInterval = setInterval(checkUpdates, 7000);
        } else {
             console.log("Polling not started (activeFisioId:", activeFisioId, ", isPollingActive:", isPollingActive, ", hidden:", document.hidden,")");
        }
    }

    // --- MANEJADORES DE EVENTOS ---

    $('#conversations-list').on('click', '.chat-contact.conversation-item', function(e) {
        if ($(e.target).closest('.delete-conversation-btn-patient').length > 0) {
            e.stopPropagation(); return;
        }
        const fisioId = $(this).data('fisio-id');
        loadMessages(fisioId); // Ahora loadMessages se encarga de llamar a checkUnreadMessages
    });


    // --- ======================================================= ---
    // --- [INICIO] CAMBIO 3: LÓGICA DE CLIC COMBINADA
    // --- ======================================================= ---

    // 1. Manejador para ABRIR el modal (solo si no se clica el botón)
    $('#chat-body').on('click', '.chat-image-link', function(e) {
        e.preventDefault();
        e.stopPropagation();

        // Comprobar si el objetivo del clic (e.target) ES o ESTÁ DENTRO del botón de borrar
        if ($(e.target).closest('.delete-image-btn').length > 0) {
            // Si fue en el botón, no hacer nada.
            // El manejador del .delete-image-btn se encargará.
            return;
        }

        // Si el clic fue en cualquier otra parte (la imagen), abrir el modal
        if (imagePreviewModalInstance) {
            const imageSrc = $(this).data('image-src');
            if (imageSrc) {
                $('#modal-preview-image').attr('src', imageSrc);
                imagePreviewModalInstance.show();
            }
        }
    });

    // 2. Manejador para BORRAR la imagen
    $('#chat-body').on('click', '.delete-image-btn', function(e) {
        e.preventDefault();
        e.stopPropagation(); // Detener burbujeo
        e.stopImmediatePropagation(); // Detener otros listeners

        // Por si acaso, nos aseguramos de que el modal se oculte
        if (imagePreviewModalInstance) {
            imagePreviewModalInstance.hide();
        }

        const $button = $(this);
        const messageId = $button.data('message-id');
        const $messageElement = $button.closest('.message');

        if (!messageId) return;

        // Confirmación
        if (confirm("Estàs segur/a que vols eliminar aquesta imatge PERMANENTMENT? Aquesta acció no es pot desfer.")) {

            $button.prop('disabled', true).html('<i class="bi bi-arrow-repeat fa-spin"></i>');

            $.post('patient_ajax.php', { // <-- CORREGIDO
                ajax: true,
                action: 'delete_chat_message',
                message_id: messageId
            }, 'json')
            .done(function(response) {
                if (response.status === 'success') {
                    $messageElement.fadeOut(300, function() { $(this).remove(); });
                    if (typeof showToast === 'function') {
                        showToast(response.message || 'Imatge eliminada.', 'success');
                    }
                } else {
                    if (typeof showToast === 'function') {
                        showToast(response.message || 'Error en eliminar la imatge.', 'danger');
                    }
                    $button.prop('disabled', false).html('<i class="bi bi-trash3"></i>');
                }
            })
            .fail(function(jqXHR) {
                 console.error("Error al eliminar imagen:", jqXHR.responseText);
                 let errorMsg = 'Error de connexió.';
                 try { const errResp = JSON.parse(jqXHR.responseText); if(errResp && errResp.message) errorMsg = errResp.message; } catch(e) {}
                 if (typeof showToast === 'function') {
                     showToast(errorMsg, 'danger');
                 }
                 $button.prop('disabled', false).html('<i class="bi bi-trash3"></i>');
            });
        }
    });
    // --- ======================================================= ---
    // --- [FIN] CAMBIO 3
    // --- ======================================================= ---


    // 1. Manejador para el botón adjuntar archivo
    $('#attach-file-btn').on('click', function() {
        if (activeFisioId > 0) {
            $('#image-input-file').click();
        } else {
            if (typeof showToast === 'function') { showToast("Selecciona una conversa primer.", 'warning'); }
        }
    });

    // 2. Manejador para el input de archivo
    $('#image-input-file').on('change', function(e) {
        const file = e.target.files[0];
        if (!file) return;

        const MAX_SIZE = 2 * 1024 * 1024; // 2MB
        if (file.size > MAX_SIZE) {
            if (typeof showToast === 'function') { showToast("La imatge és massa gran (màx. 2MB).", 'danger'); }
            $(this).val('');
            return;
        }

        if (!file.type.match('image/(jpeg|png|gif)')) {
            if (typeof showToast === 'function') { showToast("Només s'accepten imatges JPG, PNG o GIF.", 'danger'); }
            $(this).val('');
            return;
        }

        const currentActiveFisio = activeFisioId;
        const tempId = 'temp-' + Date.now();

        // 1. Mostrar mensaje temporal en el chat
        const tempMessage = {
            id: tempId, from_id: PATIENT_ID, body: `img:(Càrrega... ${file.name})`,
            status: 'sent', created_at: new Date().toISOString()
        };

        const chatBody = $('#chat-body');
        if (chatBody.find('p.text-muted').length > 0 && chatBody.find('.message').length === 0) {
             chatBody.empty();
        }
        const $newMessage = $(renderMessage(tempMessage));

        chatBody.append($newMessage);
        chatBody.animate({ scrollTop: chatBody.prop("scrollHeight") }, 300);

        // 2. Deshabilitar inputs durante la carga
        $('#message-input, #message-form button[type="submit"], #attach-file-btn').prop('disabled', true);


        // 3. Preparar y enviar la petición AJAX con FormData
        const formData = new FormData();
        formData.append('ajax', true);
        formData.append('action', 'upload_chat_image'); // Nuevo action
        formData.append('fisio_id', currentActiveFisio);
        formData.append('chat_image', file);
        formData.append('tempId', tempId);

        $.ajax({
            url: 'patient_ajax.php', // <-- CORREGIDO
            type: 'POST',
            data: formData,
            processData: false,
            contentType: false,
            dataType: 'json'
        })
        .done(function(response) {
            if (response.status === 'success') {
                const $tempMessage = $(`div.message[data-message-id=${response.tempId}]`);
                if ($tempMessage.length) {
                    const realMessage = {
                        id: response.newId, from_id: PATIENT_ID, body: response.body,
                        status: 'sent', created_at: response.created_at
                    };
                    $tempMessage.replaceWith(renderMessage(realMessage));

                    // Actualizar last_message en la lista de contactos
                    const $listItem = $(`.conversation-item[data-fisio-id=${currentActiveFisio}]`);
                    if ($listItem.length > 0) {
                        const messagePreview = "[Imatge]";
                        $listItem.find('.last-message').text(messagePreview).prop('title', messagePreview);
                        $listItem.prependTo('#conversations-list');
                    }
                }
            } else {
                 $(`div.message[data-message-id=${response.tempId}]`).find('.message-body').html(`
                     <p class="mb-0 text-danger"><i class="bi bi-exclamation-triangle-fill me-2"></i> ${response.message || 'Error de càrrega.'}</p>
                 `);
                 if (typeof showToast === 'function') { showToast(response.message || 'Error al pujar la imatge.', 'danger'); }
            }
        })
        .fail((jqXHR) => {
             console.error("Error AJAX en upload_chat_image:", jqXHR.responseText);
             $(`div.message[data-message-id=${tempId}]`).find('.message-body').html('<p class="mb-0 text-danger"><i class="bi bi-exclamation-triangle-fill me-2"></i> Error de xarxa al pujar.</p>');
             if (typeof showToast === 'function') { showToast('Error de connexió al servidor.', 'danger'); }
        })
        .always(() => {
            // Re-habilitar inputs
            if (currentActiveFisio === activeFisioId) {
                $('#message-input, #message-form button[type="submit"], #attach-file-btn').prop('disabled', false);
                $('#message-input').focus();
            }
            // Limpiar input de archivo
            $('#image-input-file').val('');
        });
    });


    $('#message-form').on('submit', function(e) {
        e.preventDefault();
        const input = $('#message-input');
        const messageBody = input.val().trim();
        const currentActiveFisio = activeFisioId;

        if (messageBody === '' || !currentActiveFisio) return;

        input.prop('disabled', true);
        $(this).find('button[type="submit"]').prop('disabled', true);

        const tempId = 'temp-' + Date.now();
        const tempMessage = {
            id: tempId, from_id: PATIENT_ID, body: messageBody,
            status: 'sent', created_at: new Date().toISOString()
        };

        const chatBody = $('#chat-body');
        if (chatBody.find('p.text-muted').length > 0 && chatBody.find('.message').length === 0) {
             chatBody.empty();
        }
        const $newMessage = $(renderMessage(tempMessage));
        chatBody.append($newMessage);
        chatBody.animate({ scrollTop: chatBody.prop("scrollHeight") }, 300);
        input.val('');

        const $listItem = $(`.conversation-item[data-fisio-id=${currentActiveFisio}]`);
        if ($listItem.length > 0) {
             const escapedBody = escapeHtml(messageBody);
             $listItem.find('.last-message').text(escapedBody).prop('title', escapedBody);
             $listItem.prependTo('#conversations-list');
        }

        $.post('patient_ajax.php', { // <-- CORREGIDO
            ajax: true, action: 'send_chat_message',
            to_id: currentActiveFisio, message: messageBody
        }, 'json')
        .done(function(response) {
            if (response.status !== 'success') {
                $newMessage.addClass('message-error').attr('title', response.message || 'Error en enviar');
                 $newMessage.find('.status-icon').html('<i class="bi bi-exclamation-triangle-fill text-danger" title="Error"></i>');
            }
        })
        .fail(() => {
             $newMessage.addClass('message-error').attr('title', 'Error de connexió');
             $newMessage.find('.status-icon').html('<i class="bi bi-exclamation-triangle-fill text-danger" title="Error de xarxa"></i>');
        })
        .always(() => {
            if (currentActiveFisio === activeFisioId) { // Re-check active ID
                input.prop('disabled', false).focus();
                $('#message-form').find('button[type="submit"]').prop('disabled', false);
            }
        });
    });

    $(window).on('visibilitychange', function() {
        if (document.hidden) {
            console.log("Tab hidden, stopping polling.");
            isPollingActive = false;
            clearInterval(chatInterval);
        } else {
            console.log("Tab visible, maybe restarting polling.");
            isPollingActive = true;
             if (activeFisioId > 0) { startPolling(); }
        }
    });

    $('#conversations-list').on('click', '.delete-conversation-btn-patient', function(e) {
        e.stopPropagation();
        const fisioId = $(this).data('fisio-id');
        $('#deletePatientChatFisioId').val(fisioId);
        if (deletePatientChatModal) {
            $('#deleteChatPatientModal .modal-body p:first').text("Estàs segur/a que vols buidar l'historial d'aquesta conversa?");
            $('#deleteChatPatientModal .modal-body .small').text("Els missatges s'esborraran només per a tu.");
            $('#confirmDeletePatientChatBtn').text("Buidar Historial");
            deletePatientChatModal.show();
        } else {
            console.error("Modal not found.");
            if (confirm("Vols buidar l'historial d'aquesta conversa? (Només per a tu)")) {
                 handleDeleteConfirmation(fisioId);
            }
        }
    });

    $(document).on('click', '#confirmDeletePatientChatBtn', function() {
        const fisioId = $('#deletePatientChatFisioId').val();
        handleDeleteConfirmation(fisioId, $(this));
    });

    function handleDeleteConfirmation(fisioId, $button = null) {
         if (!fisioId) return;

         const originalButtonText = $button ? $button.html() : 'Buidar Historial';
         if ($button) {
            $button.prop('disabled', true).html('<span class="spinner-border spinner-border-sm"></span> Buidant...');
         }

         $.post('patient_ajax.php', { // <-- CORREGIDO
             ajax: true, action: 'delete_conversation', fisio_id: fisioId
         }, 'json')
         .done(function(response) {
             if (response.status === 'success') {
                 if (fisioId == activeFisioId) {
                     $('#chat-body').html('<p class="text-center text-muted mt-3">Historial de missatges buidat. Pots continuar escrivint.</p>');
                     $('#chat-body').scrollTop(0);
                 }

                 const $listItem = $(`.conversation-item[data-fisio-id=${fisioId}]`);
                 if ($listItem.length > 0) {
                     $listItem.find('.last-message').html('<i>Historial buit...</i>').prop('title', '');
                 }

                 if (typeof showToast === 'function') {
                     showToast(response.message || 'Historial de conversa buidat.', 'success');
                 }
                 if (deletePatientChatModal) deletePatientChatModal.hide();

             } else {
                  if (typeof showToast === 'function') {
                     showToast(response.message || 'Error en buidar l\'historial.', 'danger');
                  }
             }
         })
         .fail((jqXHR, textStatus, errorThrown) => {
              console.error("Error al buidar historial:", jqXHR.responseText, textStatus, errorThrown);
              if (typeof showToast === 'function') {
                  let errorMsg = 'Error de connexió.';
                  try { const errorResponse = JSON.parse(jqXHR.responseText); if (errorResponse && errorResponse.message) errorMsg = errorResponse.message; } catch(e) {}
                  showToast(errorMsg, 'danger');
              }
         })
         .always(() => {
             if ($button) {
                 $button.prop('disabled', false).html(originalButtonText);
             }
         });
    }


    $('#contactSearchInput').on('keyup', function() {
        const searchTerm = $(this).val().toLowerCase();
        let visibleCount = 0;
        $('#conversations-list .chat-contact').each(function() {
            const contactName = $(this).data('fisio-name').toLowerCase();
            const isVisible = contactName.includes(searchTerm);
            $(this).toggle(isVisible);
            if(isVisible) visibleCount++;
        });
        $('#no-search-results').remove();
        if (visibleCount === 0 && $('#conversations-list').children(':not(.text-muted)').length > 0) {
             $('#conversations-list').append('<li id="no-search-results" class="text-muted text-center p-3 small">No s\'han trobat coincidències.</li>');
        }
    });

    // --- ★★★ INICIO: CÓDIGO AÑADIDO (Botón "Volver" en móvil) ★★★
    $(document).on('click', '#back-to-chat-list-patient', function(e) {
        e.preventDefault();
        // Quitar la clase para volver a la lista
        $('.chat-app').removeClass('modo-conversacion');

        // Opcional: Deseleccionar el fisio activo
        activeFisioId = 0;
        $('.conversation-item').removeClass('active');
        // Limpiar el ?fisio_id= de la URL
        history.pushState(null, '', 'chat_patient.php');
        // Cargar la pantalla de bienvenida
        loadMessages(0);
    });
    // ★★★ FIN: CÓDIGO AÑADIDO ★★★

    // --- INICIALIZACIÓN ---
    console.log("Initial activeFisioId on load:", activeFisioId);
    if (activeFisioId > 0) {
        $('.conversation-item').removeClass('active');
        const $initialItem = $(`.conversation-item[data-fisio-id=${activeFisioId}]`);
        if ($initialItem.length) {
            $initialItem.addClass('active');
        }
        loadMessages(activeFisioId);
    } else {
         loadMessages(0); // Muestra placeholder adecuado
    }

});
</script>
</body>
</html>
