-- Backup de la base de datos 'francesc_avant_online_mysql'
-- Fecha: 2025-12-02 16:49:23

SET NAMES utf8mb4;
SET FOREIGN_KEY_CHECKS = 0;


-- Estructura de `anuncio_recipients`
DROP TABLE IF EXISTS `anuncio_recipients`;
CREATE TABLE `anuncio_recipients` (
  `id` int NOT NULL AUTO_INCREMENT,
  `anuncio_id` int NOT NULL,
  `user_id` int NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `anuncio_id` (`anuncio_id`,`user_id`),
  KEY `user_id` (`user_id`),
  CONSTRAINT `anuncio_recipients_ibfk_1` FOREIGN KEY (`anuncio_id`) REFERENCES `anuncios` (`id`) ON DELETE CASCADE,
  CONSTRAINT `anuncio_recipients_ibfk_2` FOREIGN KEY (`user_id`) REFERENCES `cuentas` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;


-- Estructura de `anuncio_vistos`
DROP TABLE IF EXISTS `anuncio_vistos`;
CREATE TABLE `anuncio_vistos` (
  `id` int NOT NULL AUTO_INCREMENT,
  `anuncio_id` int NOT NULL,
  `user_id` int NOT NULL,
  `dismissed_at` datetime DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `anuncio_id` (`anuncio_id`,`user_id`),
  KEY `user_id` (`user_id`),
  CONSTRAINT `anuncio_vistos_ibfk_1` FOREIGN KEY (`anuncio_id`) REFERENCES `anuncios` (`id`) ON DELETE CASCADE,
  CONSTRAINT `anuncio_vistos_ibfk_2` FOREIGN KEY (`user_id`) REFERENCES `cuentas` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;


-- Estructura de `anuncios`
DROP TABLE IF EXISTS `anuncios`;
CREATE TABLE `anuncios` (
  `id` int NOT NULL AUTO_INCREMENT,
  `title` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `content` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `message_type` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT 'info',
  `creator_id` int DEFAULT NULL,
  `created_at` datetime DEFAULT CURRENT_TIMESTAMP,
  `start_date` date DEFAULT NULL,
  `end_date` date DEFAULT NULL,
  `target_audience` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT '0',
  `is_blocking` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `creator_id` (`creator_id`),
  KEY `idx_anuncios_active_dates` (`is_active`,`start_date`,`end_date`),
  CONSTRAINT `anuncios_ibfk_1` FOREIGN KEY (`creator_id`) REFERENCES `cuentas` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;


-- Estructura de `app_settings`
DROP TABLE IF EXISTS `app_settings`;
CREATE TABLE `app_settings` (
  `setting_key` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `setting_value` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`setting_key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Datos de `app_settings`
INSERT INTO `app_settings` (`setting_key`, `setting_value`) VALUES
('last_partition_maintenance', '2025-11-14');


-- Estructura de `archivado_personal`
DROP TABLE IF EXISTS `archivado_personal`;
CREATE TABLE `archivado_personal` (
  `fisio_id` int NOT NULL,
  `item_id` int NOT NULL,
  `item_type` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  PRIMARY KEY (`fisio_id`,`item_id`,`item_type`),
  CONSTRAINT `archivado_personal_ibfk_1` FOREIGN KEY (`fisio_id`) REFERENCES `cuentas` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;


-- Estructura de `banned_emails`
DROP TABLE IF EXISTS `banned_emails`;
CREATE TABLE `banned_emails` (
  `id` int NOT NULL AUTO_INCREMENT,
  `email` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `reason` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `banned_by_user_id` int DEFAULT NULL,
  `banned_at` datetime DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `email` (`email`),
  KEY `banned_by_user_id` (`banned_by_user_id`),
  CONSTRAINT `banned_emails_ibfk_1` FOREIGN KEY (`banned_by_user_id`) REFERENCES `cuentas` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;


-- Estructura de `categorias`
DROP TABLE IF EXISTS `categorias`;
CREATE TABLE `categorias` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `parent_id` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`),
  KEY `parent_id` (`parent_id`),
  CONSTRAINT `categorias_ibfk_1` FOREIGN KEY (`parent_id`) REFERENCES `categorias` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Datos de `categorias`
INSERT INTO `categorias` (`id`, `name`, `parent_id`) VALUES
('1', 'Extremitat Superior', NULL),
('2', 'Muscle', '1'),
('3', 'Colze', '1'),
('4', 'Canell i Mà', '1'),
('5', 'Extremitat Inferior', NULL),
('6', 'Maluc', '5'),
('7', 'Genoll', '5'),
('8', 'Turmell i Peu', '5'),
('9', 'Columna Vertebral', NULL),
('10', 'Cervical', '9'),
('11', 'Dorsal', '9'),
('12', 'Lumbar', '9'),
('13', 'Core / Abdomen', NULL),
('14', 'Manegot dels Rotadors', '2'),
('15', 'Lligament Creuat Anterior', '7');


-- Estructura de `chat_conversation_visibility`
DROP TABLE IF EXISTS `chat_conversation_visibility`;
CREATE TABLE `chat_conversation_visibility` (
  `user_id` int NOT NULL,
  `other_user_id` int NOT NULL,
  `deleted_until` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`user_id`,`other_user_id`),
  KEY `other_user_id` (`other_user_id`),
  CONSTRAINT `chat_conversation_visibility_ibfk_1` FOREIGN KEY (`other_user_id`) REFERENCES `cuentas` (`id`) ON DELETE CASCADE,
  CONSTRAINT `chat_conversation_visibility_ibfk_2` FOREIGN KEY (`user_id`) REFERENCES `cuentas` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;


-- Estructura de `chat_messages`
DROP TABLE IF EXISTS `chat_messages`;
CREATE TABLE `chat_messages` (
  `id` int NOT NULL AUTO_INCREMENT,
  `from_id` int NOT NULL,
  `to_id` int NOT NULL,
  `body` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `status` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT 'sent',
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `to_id` (`to_id`),
  KEY `idx_chat_conversation` (`from_id`,`to_id`),
  KEY `idx_chat_timestamp` (`created_at`),
  CONSTRAINT `chat_messages_ibfk_1` FOREIGN KEY (`from_id`) REFERENCES `cuentas` (`id`) ON DELETE CASCADE,
  CONSTRAINT `chat_messages_ibfk_2` FOREIGN KEY (`to_id`) REFERENCES `cuentas` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=35 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;


-- Estructura de `cuentas`
DROP TABLE IF EXISTS `cuentas`;
CREATE TABLE `cuentas` (
  `id` int NOT NULL AUTO_INCREMENT,
  `nombre` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `apellido` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `email` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `telefono` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `password` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `rol` varchar(15) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `id_fisio_registrador` int DEFAULT NULL,
  `fecha_creacion` datetime DEFAULT CURRENT_TIMESTAMP,
  `is_archived` tinyint(1) NOT NULL DEFAULT '0',
  `filtro_personal_defecto` tinyint(1) NOT NULL DEFAULT '0',
  `status` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT 'activo',
  `fecha_baja` date DEFAULT NULL,
  `vista_defecto` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `records_per_page` int NOT NULL DEFAULT '8',
  `last_seen` datetime DEFAULT NULL,
  `motivo_baja` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `avatar` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `email` (`email`),
  KEY `id_fisio_registrador` (`id_fisio_registrador`),
  KEY `idx_cuentas_status` (`status`),
  CONSTRAINT `cuentas_ibfk_1` FOREIGN KEY (`id_fisio_registrador`) REFERENCES `cuentas` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Datos de `cuentas`
INSERT INTO `cuentas` (`id`, `nombre`, `apellido`, `email`, `telefono`, `password`, `rol`, `id_fisio_registrador`, `fecha_creacion`, `is_archived`, `filtro_personal_defecto`, `status`, `fecha_baja`, `vista_defecto`, `records_per_page`, `last_seen`, `motivo_baja`, `avatar`) VALUES
('1', 'Sergi', 'Rodríguez', 'fisio1@avant.es', '667543456', '$2y$10$jDPWy9BAThBFWb232JPcK.3zwQ0T7GqL3/yXBbagvvHVoAfTbOfNy', 'superadmin', NULL, '2025-10-13 11:11:09', '0', '0', 'activo', NULL, '{\"pacientes\":\"list\",\"gallery_video\":\"list\",\"gallery_image\":\"list\",\"exercises\":\"list\",\"protocols\":\"list\",\"treatments\":\"list\"}', '8', '2025-12-02 16:49:12', NULL, 'avatar/user_1_1763883854.png'),
('2', 'Isa', 'Serrano', 'pacient1@avant.es', '667741432', '$2y$10$P3x38BG8b4iWZZQdw47v3.pYvhuHMBWwHvbvRgzuOIKDHzdrgLsVi', 'paciente', '1', '2025-11-01 11:58:29', '0', '0', 'activo', NULL, NULL, '8', '2025-11-09 13:37:22', NULL, 'avatar/user_2_1763885455.png'),
('3', 'Joan', 'Castells', 'fisio3@avant.es', '683741967', '$2y$10$NyFk6d8hsIf8u75XhfXLO.gTFbFG3dd2BauXnhBKHNZDqSjf5mY2K', 'fisio', NULL, '2025-11-01 11:59:48', '0', '0', 'activo', NULL, '{\"gallery_image\":\"grid\",\"treatments\":\"list\",\"exercises\":\"grid\",\"gallery_video\":\"list\",\"protocols\":\"list\"}', '8', '2025-11-24 07:09:13', NULL, 'avatar/user_3_1763884114.png'),
('4', 'Anabel', 'Anabel', 'fisio2@avant.es', '666869967', '$2y$10$ZMRmAtLeVZB7D.ljjcKCDe6RS97SShqiM4SaFb7dygfJir3gXdpRe', 'superadmin', NULL, '2025-11-01 12:00:33', '0', '0', 'activo', NULL, '{\"exercises\":\"list\"}', '8', '2025-11-24 07:08:43', NULL, 'avatar/user_4_1763883952.png'),
('5', 'Fernando', 'Polo', 'pacient2@avant.es', '664741967', '$2y$10$b3VT9y1zIpuPdozNpdW/R.9xymik1QGouI8sjnkWTI/z3.45LJRHa', 'paciente', '3', '2025-11-01 12:02:52', '0', '0', 'activo', NULL, NULL, '8', '2025-11-09 13:32:44', 'xzczxvczxvzxvczxzcx', 'avatar/user_5_1763885529.png'),
('6', 'Clara', 'Román', 'pacient3@avant.es', '677741966', '$2y$10$8sjnfqe4PJBLrB9/ahlfQeyAGfpPXl3561YnCliQXxnj86lr605ZG', 'paciente', '1', '2025-11-01 12:19:02', '0', '0', 'activo', NULL, NULL, '8', '2025-11-09 13:34:03', NULL, 'avatar/user_6_1763885552.png');


-- Estructura de `dashboard_alert_dismissals`
DROP TABLE IF EXISTS `dashboard_alert_dismissals`;
CREATE TABLE `dashboard_alert_dismissals` (
  `user_id` int NOT NULL,
  `evolucion_id` int NOT NULL,
  `dismissed_at` datetime DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`user_id`,`evolucion_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;


-- Estructura de `ejercicio_fisios_asignados`
DROP TABLE IF EXISTS `ejercicio_fisios_asignados`;
CREATE TABLE `ejercicio_fisios_asignados` (
  `id` int NOT NULL AUTO_INCREMENT,
  `ejercicio_id` int NOT NULL,
  `fisio_id` int NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ejercicio_id` (`ejercicio_id`,`fisio_id`),
  KEY `fisio_id` (`fisio_id`),
  CONSTRAINT `ejercicio_fisios_asignados_ibfk_1` FOREIGN KEY (`ejercicio_id`) REFERENCES `ejercicios` (`id`) ON DELETE CASCADE,
  CONSTRAINT `ejercicio_fisios_asignados_ibfk_2` FOREIGN KEY (`fisio_id`) REFERENCES `cuentas` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=27 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;


-- Estructura de `ejercicio_tags`
DROP TABLE IF EXISTS `ejercicio_tags`;
CREATE TABLE `ejercicio_tags` (
  `ejercicio_id` int NOT NULL,
  `tag_id` int NOT NULL,
  PRIMARY KEY (`ejercicio_id`,`tag_id`),
  KEY `tag_id` (`tag_id`),
  CONSTRAINT `ejercicio_tags_ibfk_1` FOREIGN KEY (`ejercicio_id`) REFERENCES `ejercicios` (`id`) ON DELETE CASCADE,
  CONSTRAINT `ejercicio_tags_ibfk_2` FOREIGN KEY (`tag_id`) REFERENCES `tags` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;


-- Estructura de `ejercicios`
DROP TABLE IF EXISTS `ejercicios`;
CREATE TABLE `ejercicios` (
  `id` int NOT NULL AUTO_INCREMENT,
  `id_video` int DEFAULT NULL,
  `id_image` int DEFAULT NULL,
  `id_creator` int NOT NULL,
  `id_categoria` int DEFAULT NULL,
  `title` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `series` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `repetitions` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `rest_time` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `notes` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `creation_date` datetime DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `id_categoria` (`id_categoria`),
  KEY `id_creator` (`id_creator`),
  KEY `id_image` (`id_image`),
  KEY `id_video` (`id_video`),
  CONSTRAINT `ejercicios_ibfk_1` FOREIGN KEY (`id_categoria`) REFERENCES `categorias` (`id`) ON DELETE SET NULL,
  CONSTRAINT `ejercicios_ibfk_2` FOREIGN KEY (`id_creator`) REFERENCES `cuentas` (`id`),
  CONSTRAINT `ejercicios_ibfk_3` FOREIGN KEY (`id_image`) REFERENCES `images` (`id`) ON DELETE SET NULL,
  CONSTRAINT `ejercicios_ibfk_4` FOREIGN KEY (`id_video`) REFERENCES `videos` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;


-- Estructura de `email_settings`
DROP TABLE IF EXISTS `email_settings`;
CREATE TABLE `email_settings` (
  `setting_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `description` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `is_enabled` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`setting_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Datos de `email_settings`
INSERT INTO `email_settings` (`setting_name`, `description`, `is_enabled`) VALUES
('new_treatment_assigned', 'Quan s\'assigna un tractament (nou, clonat o reassignat)', '1'),
('new_user_admin', 'Quan un admin crea un nou usuari', '1'),
('new_user_register', 'Quan un pacient s\'auto-registra', '1'),
('password_reset', 'Quan un usuari demana recuperar contrasenya', '1'),
('treatment_finished', 'Quan un tractament es marca com a Completat/Omés', '0'),
('treatment_transferred', 'Quan un tractament es transfereix a un nou fisio', '1'),
('weekly_summary', 'Quan s\'envia el resum setmanal al pacient', '0');


-- Estructura de `images`
DROP TABLE IF EXISTS `images`;
CREATE TABLE `images` (
  `id` int NOT NULL AUTO_INCREMENT,
  `filename` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `title` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `upload_date` datetime DEFAULT CURRENT_TIMESTAMP,
  `id_uploader` int NOT NULL,
  PRIMARY KEY (`id`),
  KEY `id_uploader` (`id_uploader`),
  CONSTRAINT `images_ibfk_1` FOREIGN KEY (`id_uploader`) REFERENCES `cuentas` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;


-- Estructura de `log_auditoria`
DROP TABLE IF EXISTS `log_auditoria`;
CREATE TABLE `log_auditoria` (
  `id` int NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `actor_user_id` int DEFAULT NULL,
  `actor_username` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `action` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `target_user_id` int DEFAULT NULL,
  `target_object_id` int DEFAULT NULL,
  `ip_address` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `details` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  PRIMARY KEY (`id`,`timestamp`),
  KEY `actor_user_id` (`actor_user_id`),
  KEY `target_user_id` (`target_user_id`),
  KEY `idx_log_auditoria_timestamp` (`timestamp`)
) ENGINE=InnoDB AUTO_INCREMENT=854 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci
/*!50100 PARTITION BY RANGE (to_days(`timestamp`))
(PARTITION p_before_2024 VALUES LESS THAN (739251) ENGINE = InnoDB,
 PARTITION p2024_01 VALUES LESS THAN (739282) ENGINE = InnoDB,
 PARTITION p2024_02 VALUES LESS THAN (739311) ENGINE = InnoDB,
 PARTITION p2024_03 VALUES LESS THAN (739342) ENGINE = InnoDB,
 PARTITION p2024_04 VALUES LESS THAN (739372) ENGINE = InnoDB,
 PARTITION p2024_05 VALUES LESS THAN (739403) ENGINE = InnoDB,
 PARTITION p2024_06 VALUES LESS THAN (739433) ENGINE = InnoDB,
 PARTITION p2024_07 VALUES LESS THAN (739464) ENGINE = InnoDB,
 PARTITION p2024_08 VALUES LESS THAN (739495) ENGINE = InnoDB,
 PARTITION p2024_09 VALUES LESS THAN (739525) ENGINE = InnoDB,
 PARTITION p2024_10 VALUES LESS THAN (739556) ENGINE = InnoDB,
 PARTITION p2024_11 VALUES LESS THAN (739586) ENGINE = InnoDB,
 PARTITION p2024_12 VALUES LESS THAN (739617) ENGINE = InnoDB,
 PARTITION p2025_01 VALUES LESS THAN (739648) ENGINE = InnoDB,
 PARTITION p2025_02 VALUES LESS THAN (739676) ENGINE = InnoDB,
 PARTITION p2025_03 VALUES LESS THAN (739707) ENGINE = InnoDB,
 PARTITION p2025_04 VALUES LESS THAN (739737) ENGINE = InnoDB,
 PARTITION p2025_05 VALUES LESS THAN (739768) ENGINE = InnoDB,
 PARTITION p2025_06 VALUES LESS THAN (739798) ENGINE = InnoDB,
 PARTITION p2025_07 VALUES LESS THAN (739829) ENGINE = InnoDB,
 PARTITION p2025_08 VALUES LESS THAN (739860) ENGINE = InnoDB,
 PARTITION p2025_09 VALUES LESS THAN (739890) ENGINE = InnoDB,
 PARTITION p2025_10 VALUES LESS THAN (739921) ENGINE = InnoDB,
 PARTITION p2025_11 VALUES LESS THAN (739951) ENGINE = InnoDB,
 PARTITION p2025_12 VALUES LESS THAN (739982) ENGINE = InnoDB,
 PARTITION p2026_01 VALUES LESS THAN (740013) ENGINE = InnoDB,
 PARTITION p2026_02 VALUES LESS THAN (740041) ENGINE = InnoDB,
 PARTITION p2026_03 VALUES LESS THAN (740072) ENGINE = InnoDB,
 PARTITION p2026_04 VALUES LESS THAN (740102) ENGINE = InnoDB,
 PARTITION p2026_05 VALUES LESS THAN (740133) ENGINE = InnoDB,
 PARTITION p2026_06 VALUES LESS THAN (740163) ENGINE = InnoDB,
 PARTITION p2026_07 VALUES LESS THAN (740194) ENGINE = InnoDB,
 PARTITION p2026_08 VALUES LESS THAN (740225) ENGINE = InnoDB,
 PARTITION p2026_09 VALUES LESS THAN (740255) ENGINE = InnoDB,
 PARTITION p2026_10 VALUES LESS THAN (740286) ENGINE = InnoDB,
 PARTITION p2026_11 VALUES LESS THAN (740316) ENGINE = InnoDB,
 PARTITION p2026_12 VALUES LESS THAN (740347) ENGINE = InnoDB,
 PARTITION p_future VALUES LESS THAN MAXVALUE ENGINE = InnoDB) */;

-- Datos de `log_auditoria`
INSERT INTO `log_auditoria` (`id`, `timestamp`, `actor_user_id`, `actor_username`, `action`, `target_user_id`, `target_object_id`, `ip_address`, `details`) VALUES
('836', '2025-11-23 21:50:27', NULL, 'N/A', 'LOGIN_FAIL', '2', NULL, '193.160.85.133', 'Intento de login fallido para email: pacient1@avant.es'),
('837', '2025-11-23 21:50:51', '2', 'Isa', 'LOGIN_SUCCESS', '2', NULL, '193.160.85.133', 'Login con éxito. Rol: paciente'),
('838', '2025-11-23 21:51:35', '1', 'Sergi', 'LOGIN_SUCCESS', '1', NULL, '193.160.85.133', 'Login con éxito. Rol: superadmin'),
('839', '2025-11-23 21:52:35', '3', 'Joan', 'LOGIN_SUCCESS', '3', NULL, '193.160.85.133', 'Login con éxito. Rol: fisio'),
('840', '2025-11-23 21:53:44', '4', 'Anabel', 'LOGIN_SUCCESS', '4', NULL, '193.160.85.133', 'Login con éxito. Rol: superadmin'),
('841', '2025-11-24 07:07:49', '1', 'Sergi', 'LOGIN_SUCCESS', '1', NULL, '193.160.85.133', 'Login con éxito. Rol: superadmin'),
('842', '2025-11-24 07:08:43', '4', 'Anabel', 'LOGIN_SUCCESS', '4', NULL, '193.160.85.133', 'Login con éxito. Rol: superadmin'),
('843', '2025-11-24 07:09:13', '3', 'Joan', 'LOGIN_SUCCESS', '3', NULL, '193.160.85.133', 'Login con éxito. Rol: fisio'),
('844', '2025-11-24 07:31:04', '1', 'Sergi', 'LOGIN_SUCCESS', '1', NULL, '193.160.85.133', 'Login con éxito. Rol: superadmin'),
('845', '2025-11-24 08:36:08', '1', 'Sergi', 'LOGIN_SUCCESS', '1', NULL, '193.160.85.133', 'Login con éxito. Rol: superadmin'),
('846', '2025-11-29 10:08:59', '1', 'Sergi', 'LOGIN_SUCCESS', '1', NULL, '193.160.85.69', 'Login con éxito. Rol: superadmin'),
('847', '2025-11-29 16:42:42', '1', 'Sergi', 'LOGIN_SUCCESS', '1', NULL, '193.160.85.69', 'Login con éxito. Rol: superadmin'),
('848', '2025-11-30 10:33:24', '1', 'Sergi', 'LOGIN_SUCCESS', '1', NULL, '193.160.85.69', 'Login con éxito. Rol: superadmin'),
('849', '2025-12-02 09:26:51', '1', 'Sergi', 'LOGIN_SUCCESS', '1', NULL, '193.160.85.69', 'Login con éxito. Rol: superadmin'),
('850', '2025-12-02 09:29:06', '1', 'Sergi', 'USER_REGISTERED', '19', NULL, '193.160.85.69', 'Nuevo usuario CREADO (ID: 19). Rol: paciente. Email: francescllorens62@gmail.com'),
('851', '2025-12-02 09:29:31', '1', 'Sergi', 'PATIENT_ARCHIVED', '19', NULL, '193.160.85.69', 'Paciente ID: 19 dado de BAJA. Motivo: N/A'),
('852', '2025-12-02 09:29:37', '1', 'Sergi', 'PATIENT_DELETED', '19', NULL, '193.160.85.69', 'Paciente ELIMINADO permanentemente (ID: 19). Nombre: Francesc Llorens'),
('853', '2025-12-02 16:49:11', '1', 'Sergi', 'LOGIN_SUCCESS', '1', NULL, '193.160.85.69', 'Login con éxito. Rol: superadmin');


-- Estructura de `notificaciones`
DROP TABLE IF EXISTS `notificaciones`;
CREATE TABLE `notificaciones` (
  `id` int NOT NULL AUTO_INCREMENT,
  `fisio_id` int NOT NULL,
  `tipo_evento` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `id_relacionado` int DEFAULT NULL,
  `id_secundario` int DEFAULT NULL,
  `mensaje` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `fecha_creacion` datetime DEFAULT CURRENT_TIMESTAMP,
  `leido_en` datetime DEFAULT NULL,
  `url_destino` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  PRIMARY KEY (`id`),
  KEY `idx_notificaciones_fisio_leido` (`fisio_id`,`leido_en`),
  CONSTRAINT `notificaciones_ibfk_1` FOREIGN KEY (`fisio_id`) REFERENCES `cuentas` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=25 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;


-- Estructura de `password_resets`
DROP TABLE IF EXISTS `password_resets`;
CREATE TABLE `password_resets` (
  `id` int NOT NULL AUTO_INCREMENT,
  `email` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `token` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `expires_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `token` (`token`)
) ENGINE=InnoDB AUTO_INCREMENT=23 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;


-- Estructura de `prohibited_passwords`
DROP TABLE IF EXISTS `prohibited_passwords`;
CREATE TABLE `prohibited_passwords` (
  `id` int NOT NULL AUTO_INCREMENT,
  `password_text` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `password_text` (`password_text`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;


-- Estructura de `tags`
DROP TABLE IF EXISTS `tags`;
CREATE TABLE `tags` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `parent_id` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`),
  KEY `parent_id` (`parent_id`),
  CONSTRAINT `tags_ibfk_1` FOREIGN KEY (`parent_id`) REFERENCES `tags` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=105 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Datos de `tags`
INSERT INTO `tags` (`id`, `name`, `parent_id`) VALUES
('1', 'Guanyar Força', '100'),
('2', 'Reduir Dolor', '100'),
('3', 'Millorar Mobilitat (ROM)', '100'),
('4', 'Augmentar Estabilitat', '100'),
('5', 'Control Motor', '100'),
('6', 'Propiocepció / Equilibri', '100'),
('7', 'Isomètric', '101'),
('8', 'Concèntric', '101'),
('9', 'Excèntric', '101'),
('10', 'Pliomètric', '101'),
('11', 'Fase 1 (Aguda)', '102'),
('12', 'Fase 2 (Enfortiment)', '102'),
('13', 'Fase 3 (Funcional)', '102'),
('14', 'Readaptació Esportiva', '102'),
('15', 'Sense Equipament', '103'),
('16', 'Banda Elàstica', '103'),
('17', 'Pes / Peses', '103'),
('18', 'Fitball', '103'),
('19', 'Bosu', '103'),
('20', 'TRX', '103'),
('21', 'Activació Muscular', '103'),
('22', 'Foam Roller', '103'),
('23', 'Cadena Cinètica Oberta', '104'),
('24', 'Cadena Cinètica Tancada', '104'),
('100', 'Objectiu Terapèutic', NULL),
('101', 'Tipus de Contracció', NULL),
('102', 'Fase de Rehabilitació', NULL),
('103', 'Equipament', NULL),
('104', 'Tipus de Cadena', NULL);


-- Estructura de `tratamiento_ejercicios`
DROP TABLE IF EXISTS `tratamiento_ejercicios`;
CREATE TABLE `tratamiento_ejercicios` (
  `id` int NOT NULL AUTO_INCREMENT,
  `tratamiento_id` int NOT NULL,
  `ejercicio_id` int DEFAULT NULL,
  `frecuencia` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT 'Diario',
  `series` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `repetitions` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `rest_time` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `notes` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `orden` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `ejercicio_id` (`ejercicio_id`),
  KEY `tratamiento_id` (`tratamiento_id`),
  CONSTRAINT `tratamiento_ejercicios_ibfk_1` FOREIGN KEY (`ejercicio_id`) REFERENCES `ejercicios` (`id`) ON DELETE SET NULL,
  CONSTRAINT `tratamiento_ejercicios_ibfk_2` FOREIGN KEY (`tratamiento_id`) REFERENCES `tratamientos` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=128 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;


-- Estructura de `tratamiento_evolucion`
DROP TABLE IF EXISTS `tratamiento_evolucion`;
CREATE TABLE `tratamiento_evolucion` (
  `id` int NOT NULL AUTO_INCREMENT,
  `tratamiento_ejercicio_id` int NOT NULL,
  `fecha_realizacion` date NOT NULL,
  `dolor_percibido` int DEFAULT NULL,
  `esfuerzo_percibido` int DEFAULT NULL,
  `comentarios` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `hora_realizacion` time DEFAULT NULL,
  `notificacion_enviada` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `tratamiento_ejercicio_id` (`tratamiento_ejercicio_id`),
  CONSTRAINT `tratamiento_evolucion_ibfk_1` FOREIGN KEY (`tratamiento_ejercicio_id`) REFERENCES `tratamiento_ejercicios` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;


-- Estructura de `tratamiento_fisios_asignados`
DROP TABLE IF EXISTS `tratamiento_fisios_asignados`;
CREATE TABLE `tratamiento_fisios_asignados` (
  `tratamiento_id` int NOT NULL,
  `fisio_id` int NOT NULL,
  `fecha_asignacion` datetime DEFAULT NULL,
  PRIMARY KEY (`tratamiento_id`,`fisio_id`),
  KEY `fisio_id` (`fisio_id`),
  CONSTRAINT `tratamiento_fisios_asignados_ibfk_1` FOREIGN KEY (`fisio_id`) REFERENCES `cuentas` (`id`) ON DELETE CASCADE,
  CONSTRAINT `tratamiento_fisios_asignados_ibfk_2` FOREIGN KEY (`tratamiento_id`) REFERENCES `tratamientos` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;


-- Estructura de `tratamientos`
DROP TABLE IF EXISTS `tratamientos`;
CREATE TABLE `tratamientos` (
  `id` int NOT NULL AUTO_INCREMENT,
  `paciente_id` int DEFAULT NULL,
  `creator_fisio_id` int NOT NULL,
  `is_protocol` tinyint(1) NOT NULL DEFAULT '0',
  `title` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `anamnesis` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `diagnostico` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `evaluacion_final` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `status` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT 'Sense iniciar',
  `start_date` date DEFAULT NULL,
  `end_date` date DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `realizacion_percent` int DEFAULT NULL,
  `protocolo_origen_id` int DEFAULT NULL,
  `creation_method` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `creator_fisio_id` (`creator_fisio_id`),
  KEY `paciente_id` (`paciente_id`),
  CONSTRAINT `tratamientos_ibfk_1` FOREIGN KEY (`creator_fisio_id`) REFERENCES `cuentas` (`id`),
  CONSTRAINT `tratamientos_ibfk_2` FOREIGN KEY (`paciente_id`) REFERENCES `cuentas` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=73 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;


-- Estructura de `videos`
DROP TABLE IF EXISTS `videos`;
CREATE TABLE `videos` (
  `id` int NOT NULL AUTO_INCREMENT,
  `filename` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `title` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `upload_date` datetime DEFAULT CURRENT_TIMESTAMP,
  `id_uploader` int NOT NULL,
  PRIMARY KEY (`id`),
  KEY `id_uploader` (`id_uploader`),
  CONSTRAINT `videos_ibfk_1` FOREIGN KEY (`id_uploader`) REFERENCES `cuentas` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

SET FOREIGN_KEY_CHECKS = 1;
