<?php
// /reports_ajax.php

// --- 1. GESTIÓN DE SESIÓN Y DEPENDENCIAS ---
session_start();
header('Content-Type: application/json');

// PERMISO: Permitir a fisios y superadmins usar esta API
if (!isset($_SESSION['user_id']) || !in_array($_SESSION['user_rol'], ['fisio', 'superadmin'])) {
    http_response_code(403);
    echo json_encode(['status' => 'error', 'message' => 'Accés denegat.']);
    exit;
}
require_once 'db.php';

// ===== Variables globals per als 'cases' =====
$action = $_REQUEST['action'] ?? $_GET['action'] ?? ''; // Unificat
$user_id = $_SESSION['user_id'];
$user_rol = $_SESSION['user_rol'];
// =============================================

try {
    switch ($action) {

        // --- INICIO: CORRECCIÓN DEFINITIVA (Heartbeat para estado "Conectado") ---
        // Apilem els 'case' per acceptar els dos noms d'acció
        // ja que el JavaScript els envia de forma inconsistent.
        case 'update_user_last_seen':
        case 'update_last_seen':
            // $user_id ya está definido al inicio del archivo
            $stmt = $db->prepare("UPDATE cuentas SET last_seen = NOW() WHERE id = ?");
            $stmt->execute([$user_id]);
            echo json_encode(['status' => 'success']);
            break;
        // --- FIN: CORRECCIÓN DEFINITIVA ---

        /**
         * Carga todas las entidades necesarias para los desplegables del informe.
         */
        case 'get_all_dependencies':
             $stmt_ex = $db->query("SELECT id, title FROM ejercicios ORDER BY title");
            $stmt_vid = $db->query("SELECT id, title FROM videos ORDER BY title");
            $stmt_img = $db->query("SELECT id, title FROM images ORDER BY title");
            $stmt_tr = $db->query("SELECT id, title FROM tratamientos WHERE is_protocol = 0 ORDER BY title");
            $stmt_pro = $db->query("SELECT id, title FROM tratamientos WHERE is_protocol = 1 ORDER BY title");

            echo json_encode([
                'status' => 'success',
                'exercises' => $stmt_ex->fetchAll(PDO::FETCH_ASSOC),
                'protocols' => $stmt_pro->fetchAll(PDO::FETCH_ASSOC),
                'treatments' => $stmt_tr->fetchAll(PDO::FETCH_ASSOC),
                'videos' => $stmt_vid->fetchAll(PDO::FETCH_ASSOC),
                'images' => $stmt_img->fetchAll(PDO::FETCH_ASSOC)
            ]);
            break;

        /**
         * Ejecuta la consulta del informe inteligente.
         */
        case 'run_smart_report':
             $mode = $_GET['mode'] ?? '';
            $type = $_GET['type'] ?? '';
            $id = (int)($_GET['id'] ?? 0);

            if (empty($mode) || empty($type) || $id === 0) {
                throw new Exception("Paràmetres invàlids.");
            }

            $response_data = [];

            if ($mode === 'usage_analysis') {
                switch ($type) {
                    case 'exercici':
                        $stmt_pro = $db->prepare("SELECT t.id, t.title FROM tratamientos t JOIN tratamiento_ejercicios te ON t.id = te.tratamiento_id WHERE te.ejercicio_id = :id AND t.is_protocol = 1 ORDER BY t.title");
                        $stmt_pro->execute([':id' => $id]);
                        $response_data['protocols'] = $stmt_pro->fetchAll(PDO::FETCH_ASSOC);
                        $stmt_act = $db->prepare("SELECT t.id, t.title, c.nombre, c.apellido FROM tratamientos t JOIN tratamiento_ejercicios te ON t.id = te.tratamiento_id JOIN cuentas c ON t.paciente_id = c.id WHERE te.ejercicio_id = :id AND t.is_protocol = 0 AND t.status IN ('En curs', 'Programat') ORDER BY c.apellido, c.nombre, t.title");
                        $stmt_act->execute([':id' => $id]);
                        $response_data['active_treatments'] = $stmt_act->fetchAll(PDO::FETCH_ASSOC);
                        $stmt_hist = $db->prepare("SELECT t.id, t.title, c.nombre, c.apellido FROM tratamientos t JOIN tratamiento_ejercicios te ON t.id = te.tratamiento_id JOIN cuentas c ON t.paciente_id = c.id WHERE te.ejercicio_id = :id AND t.is_protocol = 0 AND t.status NOT IN ('En curs', 'Programat') ORDER BY c.apellido, c.nombre, t.title");
                        $stmt_hist->execute([':id' => $id]);
                        $response_data['historic_treatments'] = $stmt_hist->fetchAll(PDO::FETCH_ASSOC);
                        break;
                    case 'protocol':
                        $stmt_treat = $db->prepare("SELECT t.id, t.title, c.nombre, c.apellido FROM tratamientos t JOIN cuentas c ON t.paciente_id = c.id WHERE t.protocolo_origen_id = :id ORDER BY c.apellido, c.nombre, t.title");
                        $stmt_treat->execute([':id' => $id]);
                        $response_data['treatments_from_protocol'] = $stmt_treat->fetchAll(PDO::FETCH_ASSOC);
                        break;
                    case 'tractament':
                        $stmt_pac = $db->prepare("SELECT c.id, c.nombre, c.apellido FROM cuentas c JOIN tratamientos t ON c.id = t.paciente_id WHERE t.id = :id");
                        $stmt_pac->execute([':id' => $id]);
                        $response_data['patient'] = $stmt_pac->fetchAll(PDO::FETCH_ASSOC);
                        $stmt_fis = $db->prepare("SELECT c.id, c.nombre, c.apellido FROM cuentas c JOIN tratamiento_fisios_asignados tfa ON c.id = tfa.fisio_id WHERE tfa.tratamiento_id = :id ORDER BY c.apellido");
                        $stmt_fis->execute([':id' => $id]);
                        $response_data['fisios'] = $stmt_fis->fetchAll(PDO::FETCH_ASSOC);
                        $stmt_ex = $db->prepare("SELECT e.id, e.title FROM ejercicios e JOIN tratamiento_ejercicios te ON e.id = te.ejercicio_id WHERE te.tratamiento_id = :id ORDER BY e.title");
                        $stmt_ex->execute([':id' => $id]);
                        $response_data['exercises'] = $stmt_ex->fetchAll(PDO::FETCH_ASSOC);
                        break;
                    case 'video':
                        $stmt_ex = $db->prepare("SELECT id, title FROM ejercicios WHERE id_video = :id ORDER BY title");
                        $stmt_ex->execute([':id' => $id]);
                        $response_data['exercises'] = $stmt_ex->fetchAll(PDO::FETCH_ASSOC);
                        break;
                    case 'image':
                         $stmt_ex = $db->prepare("SELECT id, title FROM ejercicios WHERE id_image = :id ORDER BY title");
                        $stmt_ex->execute([':id' => $id]);
                        $response_data['exercises'] = $stmt_ex->fetchAll(PDO::FETCH_ASSOC);
                        break;
                }

            } elseif ($mode === 'patient_search') {
                $sql = "";
                $params = [':id' => $id];

                switch ($type) {
                    case 'exercici':
                        $sql = "SELECT DISTINCT c.id, c.nombre, c.apellido, t.title as treatment_title, t.status FROM cuentas c JOIN tratamientos t ON c.id = t.paciente_id JOIN tratamiento_ejercicios te ON t.id = te.tratamiento_id WHERE te.ejercicio_id = :id AND c.rol = 'paciente' ORDER BY c.apellido, c.nombre";
                        break;
                    case 'protocol':
                        $sql = "SELECT DISTINCT c.id, c.nombre, c.apellido, t.title as treatment_title, t.status FROM cuentas c JOIN tratamientos t ON c.id = t.paciente_id WHERE t.protocolo_origen_id = :id AND c.rol = 'paciente' ORDER BY c.apellido, c.nombre";
                        break;
                    case 'video':
                        $sql = "SELECT DISTINCT c.id, c.nombre, c.apellido, t.title as treatment_title, t.status FROM cuentas c JOIN tratamientos t ON c.id = t.paciente_id JOIN tratamiento_ejercicios te ON t.id = te.tratamiento_id JOIN ejercicios e ON te.ejercicio_id = e.id WHERE e.id_video = :id AND c.rol = 'paciente' ORDER BY c.apellido, c.nombre";
                        break;
                    case 'image':
                        $sql = "SELECT DISTINCT c.id, c.nombre, c.apellido, t.title as treatment_title, t.status FROM cuentas c JOIN tratamientos t ON c.id = t.paciente_id JOIN tratamiento_ejercicios te ON t.id = te.tratamiento_id JOIN ejercicios e ON te.ejercicio_id = e.id WHERE e.id_image = :id AND c.rol = 'paciente' ORDER BY c.apellido, c.nombre";
                        break;
                }

                if (!empty($sql)) {
                    $stmt = $db->prepare($sql);
                    $stmt->execute($params);
                    $response_data['patients'] = $stmt->fetchAll(PDO::FETCH_ASSOC);
                }
            }

            echo json_encode(['status' => 'success', 'data' => $response_data]);
            break;

        case 'get_fisio_detailed_summary':
            $fisio_id_per_al_resum = $user_id;

            if ($user_rol === 'superadmin' && isset($_GET['target_id']) && (int)$_GET['target_id'] > 0) {
                $fisio_id_per_al_resum = (int)$_GET['target_id'];
            }

            ob_start();
            include 'partials/fisio_summary.php';
            $html_content = ob_get_clean();

            echo json_encode(['status' => 'success', 'html' => $html_content]);
            break;

        default:
            throw new Exception("Acció no reconeguda.");
    }
} catch (Exception $e) {
    // Código de depuración eliminado.
    // Ahora volvemos al comportamiento original:
    http_response_code(400);
    echo json_encode([
        'status' => 'error',
        'message' => $e->getMessage() // Devuelve el mensaje de error real (p.ej. "Acció no reconeguda")
    ]);
}
exit;
?>
