<?php
// /register.php (Pàgina de Registre en Valencià)
session_start();
if (isset($_SESSION['user_id'])) {
    if ($_SESSION['user_rol'] === 'paciente') {
        header('Location: patient_dashboard.php');
    } else {
        header('Location: dashboard.php');
    }
    exit;
}
require 'db.php';
// ★ INCLOÏM L'AJUDANT D'EMAIL ★
require 'mail_helpers.php';
require_once 'logger.php'; // <-- ★★★ AÑADIDO ★★★

// --- ★★★ CORRECCIÓN: DETECCIÓN DE URL BASE DINÁMICA ★★★ ---
// Esto permite que los emails funcionen en localhost y en producción sin cambios manuales.
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$domain = $_SERVER['HTTP_HOST'];
// Detectar carpeta actual y eliminar barras finales para evitar dobles slashes
$path = rtrim(dirname($_SERVER['SCRIPT_NAME']), '/');
$base_url = $protocol . $domain . $path . '/';
// --- ★★★ FIN CORRECCIÓN ★★★ ---

$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $apellido = trim($_POST['apellido']);
    $nombre = trim($_POST['nombre']);
    $email = trim($_POST['email']);
    $telefono = trim($_POST['telefono']);
    $password = $_POST['password'];
    $password_confirm = $_POST['password_confirm'];
    $terms = isset($_POST['terms']) ? $_POST['terms'] : '';

    if (empty($nombre) || empty($apellido) || empty($email) || empty($password)) {
        $error = 'Els camps amb * són obligatoris.';
    } elseif (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        $error = "El format de l'email no és vàlid.";
    } elseif (!preg_match('/^(?=.*\d)(?=.*[A-Z]).{6,12}$/', $password)) {
        $error = 'La contrasenya ha de tindre entre 6 i 12 caràcters, i incloure almenys una majúscula i un número.';
    } elseif ($password !== $password_confirm) {
        $error = 'Les contrasenyes no coincideixen.';
    } elseif ($terms !== 'on') {
        $error = "Has d'acceptar els Termes d'Ús i la Política de Privacitat per registrar-te.";
    } else {
        try {
            // --- ★★★ INICIO PASO 5: COMPROBACIONES DE BANEO ★★★ ---

            // 1. Comprobar si el email está baneado
            $stmt_email_ban = $db->prepare("SELECT 1 FROM banned_emails WHERE email = ? LIMIT 1");
            $stmt_email_ban->execute([$email]);
            if ($stmt_email_ban->fetch()) {
                // Mensaje vago intencionadamente
                throw new Exception("No és possible registrar-se amb aquest email.");
            }

            // 2. Comprobar si la contraseña está prohibida
            $stmt_pass_ban = $db->prepare("SELECT 1 FROM prohibited_passwords WHERE password_text = ? LIMIT 1");
            $stmt_pass_ban->execute([$password]);
            if ($stmt_pass_ban->fetch()) {
                // Mensaje específico
                throw new Exception('Aquesta contrasenya no està permesa per ser massa comuna o fàcil d\'endevinar. Per favor, tria\'n una més segura.');
            }

            // --- ★★★ FIN PASO 5: COMPROBACIONES DE BANEO ★★★ ---

            // 3. Comprobar si el email ya existe en cuentas
            $stmt = $db->prepare("SELECT id FROM cuentas WHERE email = ?");
            $stmt->execute([$email]);
            if ($stmt->fetch()) {
                throw new Exception("L'email ja està registrat. Per favor, utilitza un altre.");
            }

            // Si todas las comprobaciones pasan, proceder con la inserción

            // Tal como has pedido, el 'id_fisio_registrador' para un auto-registro debe ser NULL
            $id_fisio_registrador_para_paciente = null;

            $hashed_password = password_hash($password, PASSWORD_DEFAULT);

            // Añadimos la columna 'id_fisio_registrador' a la consulta INSERT
            $stmt = $db->prepare(
                "INSERT INTO cuentas (nombre, apellido, email, telefono, password, rol, id_fisio_registrador)
                 VALUES (?, ?, ?, ?, ?, 'paciente', ?)"
            );

            // Añadimos $id_fisio_registrador_para_paciente (que es NULL) a la ejecución
            $stmt->execute([$nombre, $apellido, $email, $telefono, $hashed_password, $id_fisio_registrador_para_paciente]);

            // Obtenemos el ID del nuevo usuario para el log
            $new_user_id = $db->lastInsertId();

            // --- ★★★ INICIO LOG B4 (Auto-Registro) CORREGIDO ★★★ ---
            // ¡ESTO CUMPLE TU PETICIÓN!
            $log_details_B4 = "Nuevo paciente AUTO-REGISTRADO (ID: $new_user_id). Nombre: $nombre $apellido. Email: $email";
            // El actor (actor_user_id) es el propio paciente.
            registrar_log($db, 'USER_REGISTERED', $new_user_id, $nombre, $log_details_B4, $new_user_id, null);
            // --- ★★★ FIN LOG B4 ★★★ ---


            // --- ★★★ INICI: ENVIAMENT D'EMAIL DE BENVINGUDA (AL PACIENT) ★★★ ---
            try {

                // --- ======================================================= ---
                // --- ★★★ INICIO DE LA CORRECCIÓN 1 ★★★ ---
                // --- ======================================================= ---
                // Copiamos la lógica manual de 'users.php'

                $stmt_check_patient = $db->prepare("SELECT is_enabled FROM email_settings WHERE setting_name = 'new_user_register' LIMIT 1");
                $stmt_check_patient->execute();

                // Solo si el interruptor devuelve '1', entramos a enviar el email
                if ($stmt_check_patient->fetchColumn() == 1) {

                    $subject_paciente = "Benvingut/da a AVANT ONLINE!";

                    // 1. Definim la imatge que volem incrustar. (ACTUALIZADO A .PNG Y 250px)
                    $logo_path = __DIR__ . '/logos/img_defecte.png';
                    $embedded_logo = [
                        ['path' => $logo_path, 'cid' => 'logo_avant']
                    ];

                    // 2. Creem el cos de l'email (HTML)
                    //    !! IMPORTANT: URL CORREGIDA A $base_url
                    $body_paciente = "
                    <div style='font-family: Arial, sans-serif; line-height: 1.6; max-width: 600px; margin: auto; padding: 20px; border: 1px solid #ddd; border-radius: 8px;'>
                        <div style='text-align: center; margin-bottom: 20px;'>
                            <img src='cid:logo_avant' alt='Logo de la Clínica' style='width: 250px; height: auto;'>
                        </div>
                        <h1 style='color: #333; text-align: center; font-size: 24px;'>Benvingut/da, " . htmlspecialchars($nombre) . "!</h1>
                        <p>El teu compte a la plataforma AVANT ONLINE ha sigut creat amb èxit.</p>
                        <p>Ja pots començar a gestionar la teva recuperació amb nosaltres. Aquestes són les teues dades per iniciar sessió:</p>
                        <ul style='list-style-type: none; padding-left: 0; background-color: #f9f9f9; border: 1px solid #eee; padding: 15px; border-radius: 5px;'>
                            <li><strong>Email:</strong> " . htmlspecialchars($email) . "</li>
                            <li><strong>Contrasenya:</strong> (la que vas triar durant el registre)</li>
                        </ul>
                        <p style='text-align: center; margin-top: 30px;'>
                            <a href='" . $base_url . "' style='background-color: #0d6efd; color: white; padding: 12px 20px; text-decoration: none; border-radius: 5px; font-weight: bold;'>
                                Accedir a la plataforma
                            </a>
                        </p>
                        <p style='color: #777; font-size: 0.9em; text-align: center; margin-top: 20px;'>
                            Si no has creat aquest compte, si us plau, ignora aquest correu.
                        </p>
                    </div>
                    ";

                    // 3. Enviem l'email usant la nostra funció
                    send_platform_email(
                        $email,
                        $subject_paciente,
                        $body_paciente,
                        true, // isHtml
                        $embedded_logo // El nou paràmetre amb la imatge
                    );

                // --- ======================================================= ---
                // --- ★★★ FIN DE LA CORRECCIÓN 1 (CIERRE DEL IF) ★★★ ---
                // --- ======================================================= ---
                } else {
                     error_log("EMAIL SKIPPED: El switch 'new_user_register' está deshabilitado.");
                }

            } catch (Exception $e) {
                // Si l'email falla, NO aturem el registre.
                // Només ho registrem a l'error_log del servidor.
                error_log("FALLO EN ENVÍO DE EMAIL DE BIENVENIDA: " . $e->getMessage());
            }
            // --- ★★★ FI: ENVIAMENT D'EMAIL DE BENVINGUDA (AL PACIENT) ★★★ ---


            // --- ★★★ INICIO: NOTIFICACIÓN AL SUPERADMIN (SUGERENCIA 3) ★★★ ---
            try {

                // --- ======================================================= ---
                // --- ★★★ INICIO DE LA CORRECCIÓN 2 ★★★ ---
                // --- ======================================================= ---
                // Volvemos a comprobar el MISMO interruptor

                $stmt_check_admin = $db->prepare("SELECT is_enabled FROM email_settings WHERE setting_name = 'new_user_register' LIMIT 1");
                $stmt_check_admin->execute();

                if ($stmt_check_admin->fetchColumn() == 1) {

                    // 1. Buscar los emails de los superadmins activos
                    $stmt_admins = $db->query("SELECT email FROM cuentas WHERE rol = 'superadmin' AND status = 'activo'");
                    $admin_emails = $stmt_admins->fetchAll(PDO::FETCH_COLUMN);

                    if (!empty($admin_emails)) {
                        $subject_admin = "Avís: Nou pacient s'ha auto-registrat";

                        // 2. Definir la imagen (con las nuevas reglas)
                        $logo_path_admin = __DIR__ . '/logos/img_defecte.png';
                        $embedded_logo_admin = [
                            ['path' => $logo_path_admin, 'cid' => 'logo_avant']
                        ];

                        // 3. Crear el cuerpo del email
                        //    !! IMPORTANT: URL CORREGIDA A $base_url . 'users.php'
                        $body_admin = "
                        <div style='font-family: Arial, sans-serif; line-height: 1.6; max-width: 600px; margin: auto; padding: 20px; border: 1px solid #ddd; border-radius: 8px;'>
                            <div style='text-align: center; margin-bottom: 20px;'>
                                <img src='cid:logo_avant' alt='Logo de la Clínica' style='width: 250px; height: auto;'>
                            </div>
                            <h1 style='color: #333; text-align: center; font-size: 24px;'>Alerta d'Administració</h1>
                            <p>Un nou pacient s'ha registrat a la plataforma i està pendent d'assignació.</p>
                            <ul style='list-style-type: none; padding-left: 0; background-color: #f9f9f9; border: 1px solid #eee; padding: 15px; border-radius: 5px;'>
                                <li><strong>Nom:</strong> " . htmlspecialchars($nombre) . " " . htmlspecialchars($apellido) . "</li>
                                <li><strong>Email:</strong> " . htmlspecialchars($email) . "</li>
                                <li><strong>Telèfon:</strong> " . htmlspecialchars($telefono ?: 'No especificat') . "</li>
                            </ul>
                            <p>Pots assignar-li un tractament o un fisioterapeuta des del panell d'usuaris (filtre 'Auto-registre').</p>
                            <p style='text-align: center; margin-top: 30px;'>
                                <a href='" . $base_url . "users.php' style='background-color: #0d6efd; color: white; padding: 12px 20px; text-decoration: none; border-radius: 5px; font-weight: bold;'>
                                    Anar al Panell d'Usuaris
                                </a>
                            </p>
                        </div>
                        ";

                        // 4. Enviar el email a cada admin
                        // (Asumiendo que send_platform_email puede manejar un array Bcc como quinto argumento)
                        $first_admin = array_shift($admin_emails);
                        $bcc_list = $admin_emails; // El resto de admins

                        send_platform_email(
                            $first_admin,
                            $subject_admin,
                            $body_admin,
                            true, // isHtml
                            $embedded_logo_admin,
                            $bcc_list // Array de emails en Bcc
                        );
                    }

                // --- ======================================================= ---
                // --- ★★★ FIN DE LA CORRECCIÓN 2 (CIERRE DEL IF) ★★★ ---
                // --- ======================================================= ---
                }

            } catch (Exception $e) {
                // Si la notificación al admin falla, no es crítico para el usuario.
                error_log("FALLO EN ENVÍO DE EMAIL (Notificación Admin Auto-Registro): " . $e->getMessage());
            }
            // --- ★★★ FIN: NOTIFICACIÓN AL SUPERADMIN ★★★ ---


            $_SESSION['success_message'] = 'Registre completat! Ja pots iniciar sessió.';
            header('Location: index.php');
            exit;
        } catch (Exception $e) {
            $error = $e->getMessage();
        }
    }
}
$page_title = "Registre - AVANT ONLINE";
?>
<!DOCTYPE html>
<html lang="ca">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= $page_title ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
    <link rel="stylesheet" href="style.css">

    <style>
        /* 1. Definimos la animación de zoom (usando 'transform') */
        @keyframes slowZoom {
            0% {
                transform: scale(1.0); /* Estado inicial */
            }
            100% {
                transform: scale(1.05); /* Zoom al 105% */
            }
        }

        /* 2. Estilo para el body (color de fondo de reserva) */
        body {
            background-color: #e9ecef; /* Color de fondo si la imagen falla */
            padding-top: 0;
            display: flex;
            flex-direction: column;
            min-height: 100vh;
            position: relative;
            overflow-x: hidden;
        }

        /* 3. El div de fondo animado */
        #animated-bg {
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            z-index: -1; /* Detrás de todo el contenido */

            /* 4. La imagen de fondo (front2.jpg) y opacidad (0.65) */
            background: linear-gradient(rgba(233, 236, 239, 0.80), rgba(233, 236, 239, 0.65)), url('logos/front2.jpg');
            background-size: cover;
            background-position: center center;
            background-repeat: no-repeat;

            /* 5. La animación (avanza y retrocede) con 8s */
            animation-name: slowZoom;
            animation-duration: 8s; /* <-- Tu velocidad de 8s */
            animation-timing-function: ease-in-out;
            animation-direction: alternate;
            animation-iteration-count: infinite;
        }

        /* 6. Desactiva la animación si el usuario lo prefiere */
        @media (prefers-reduced-motion: reduce) {
            #animated-bg {
                animation: none;
            }
        }

        main.container {
            flex: 1;
            position: relative; /* Añadido para z-index */
            z-index: 1; /* Añadido para estar sobre el fondo */
        }

        /* 7. Hacemos el footer transparente */
        footer {
            background-color: transparent;
            position: relative; /* Añadido para z-index */
            z-index: 1; /* Añadido para estar sobre el fondo */
        }

        /* Afegit de register.php original (conservado) */
        .password-group { position: relative; }
        .password-toggle-btn { position: absolute; right: 10px; top: 50%; transform: translateY(-50%); background: none; border: none; }
    </style>
    </head>
<body>

<div id="animated-bg"></div>
<main class="container py-5">
    <div class="row justify-content-center">
        <div class="col-md-7 col-lg-5">
             <div class="text-center mb-4">
                <img src="logos/logo2.jpg" alt="Logotip d'AVANT ONLINE" class="mb-2 logo-circle">
                <h1 class="h3 fw-bold" style="color: var(--custom-brand-purple);"><i class="bi bi-heart-pulse-fill me-2" style="color: #77b9af;"></i>Avant Online</h1>
            </div>
            <div class="card shadow">
                <div class="card-body p-4">
                    <h3 class="text-center mb-4">Registre de nou usuari</h3>
                    <?php if ($error): ?><div class="alert alert-danger py-2"><?= htmlspecialchars($error) ?></div><?php endif; ?>
                    <form method="POST" action="register.php">
                        <div class="row">
                            <div class="col-md-6 mb-3"><label for="apellido" class="form-label">Cognoms <span class="text-danger">*</span></label><input type="text" class="form-control" id="apellido" name="apellido" value="<?= htmlspecialchars($_POST['apellido'] ?? '') ?>" required></div>
                            <div class="col-md-6 mb-3"><label for="nombre" class="form-label">Nom <span class="text-danger">*</span></label><input type="text" class="form-control" id="nombre" name="nombre" value="<?= htmlspecialchars($_POST['nombre'] ?? '') ?>" required></div>
                        </div>
                        <div class="mb-3"><label for="email" class="form-label">Email <span class="text-danger">*</span></label><input type="email" class="form-control" id="email" name="email" value="<?= htmlspecialchars($_POST['email'] ?? '') ?>" required></div>
                        <div class="mb-3"><label for="telefono" class="form-label">Telèfon</label><input type="tel" class="form-control" id="telefono" name="telefono" value="<?= htmlspecialchars($_POST['telefono'] ?? '') ?>"></div>
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label for="password" class="form-label">Contrasenya <span class="text-danger">*</span></label>
                                <div class="password-group">
                                    <input type="password" class="form-control" id="password" name="password" required>
                                    <button type="button" class="password-toggle-btn"><i class="bi bi-eye-slash"></i></button>
                                </div>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label for="password_confirm" class="form-label">Confirmar Contrasenya <span class="text-danger">*</span></label>
                                <div class="password-group">
                                    <input type="password" class="form-control" id="password_confirm" name="password_confirm" required>
                                    <button type="button" class="password-toggle-btn"><i class="bi bi-eye-slash"></i></button>

                                </div>
                            </div>
                        </div>

                        <?php // --- ★ INICI MODIFICACIÓ (Checkbox Legal) --- ?>
                        <div class="form-check mb-3 mt-2">
                            <input type="checkbox" class="form-check-input" id="terms" name="terms" required>
                            <label class="form-check-label small text-muted" for="terms">
                                He llegit i accepto els <a href="legal/terminos-de-uso.php" target="_blank">Termes d'Ús</a> i la
                                <a href="legal/politica-privacidad.php" target="_blank">Política de Privacitat</a>.
                            </label>
                        </div>
                        <?php // --- ★ FI MODIFICACIÓ --- ?>

                        <button type="submit" class="btn btn-primary w-100 mt-3" id="createAccountBtn">Crear Compte</button>
                        </form>
                    <div class="text-center mt-4"><p class="mb-0 text-muted small">Ja tens un compte? <a href="index.php">Inicia sessió</a></p></div>
                </div>
            </div>
        </div>
    </div>
</main>

<?php // --- INICIO DE LA MODIFICACIÓN (Footer Legal) --- ?>
<footer class="py-4 text-center mt-auto">
    <div class="container">
        <span class="text-muted">&copy; <?= date('Y') ?> AVANT ONLINE. Tots els drets reservats.</span>
        <div class="mt-2">
            <a href="legal/politica-privacidad.php" class="small text-muted mx-2">Política de Privacitat</a>
            <span class="small text-muted">|</span>
            <a href="legal/terminos-de-uso.php" class="small text-muted mx-2">Termes d'Ús</a>
            <span class="small text-muted">|</span>
            <a href="legal/politica-cookies.php" class="small text-muted ms-2">Política de Cookies</a>
        </div>
    </div>
</footer>
<?php // --- FIN DE LA MODIFICACIÓN --- ?>

<script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
<script>
$(document).ready(function() {
    $(document).on('click', '.password-toggle-btn', function() {
        const passwordInput = $(this).closest('.password-group').find('input');
        const icon = $(this).find('i');
        if (passwordInput.attr('type') === 'password') {
            passwordInput.attr('type', 'text');
            icon.removeClass('bi-eye-slash').addClass('bi-eye');
        } else {
            passwordInput.attr('type', 'password');
            icon.removeClass('bi-eye').addClass('bi-eye-slash');
        }
    });

    // --- ▼▼▼ BLOQUE CORREGIDO ▼▼▼ ---
    $('#createAccountBtn').on('click', function(e) {
        const $btn = $(this);
        const form = this.form; // 'this' es el botón, 'this.form' es el formulario al que pertenece

        // 1. Prevenimos el envío inmediato para validarlo nosotros
        e.preventDefault();

        // 2. Comprobamos si el formulario es válido
        if (!form.checkValidity()) {
            // Si no es válido, le decimos al navegador que muestre los errores
            form.reportValidity();
        } else {
            // 3. Si ES VÁLIDO:
            // Desactivamos el botón y mostramos el spinner
            $btn.prop('disabled', true).html('<span class="spinner-border spinner-border-sm me-2" role="status" aria-hidden="true"></span>Creant compte...');

            // 4. ¡ESTA ES LA LÍNEA QUE FALTABA!
            // Le decimos al formulario que se envíe.
            form.submit();
        }
    });
    // --- ▲▲▲ FIN DEL BLOQUE ▲▲▲ ---

});
</script>
</body>
</html>
