<?php
// /reports/gallery_report.php

// --- 1. GESTIÓN DE SESIÓN Y DEPENDENCIAS ---
session_start();
// PERMISO: Permitir a fisios y superadmins ver este informe
if (!isset($_SESSION['user_id']) || !in_array($_SESSION['user_rol'], ['fisio', 'superadmin'])) {
    header('Location: ../index.php'); // Salir de la carpeta /reports/
    exit;
}
require '../db.php';
$page_title = "Informe de Medis"; // Título específico
$return_url = isset($_GET['return_to']) ? '../' . basename($_GET['return_to']) : '../dashboard.php'; // URL para "Tornar"

// --- 2. RECOPILACIÓN DE DATOS ---
// ... (Tu código PHP existente para obtener $videos y $images) ...
$stmt_videos = $db->prepare("SELECT id, title, filename FROM videos ORDER BY title, filename");
$stmt_videos->execute();
$videos = $stmt_videos->fetchAll(PDO::FETCH_ASSOC);
$stmt_images = $db->prepare("SELECT id, title, filename FROM images ORDER BY title, filename");
$stmt_images->execute();
$images = $stmt_images->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html lang="ca">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= $page_title ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
    <style>
        :root {
            --bs-body-font-family: "Segoe UI", "Helvetica Neue", Arial, sans-serif;
            --custom-brand-purple: #684A7A; /* Color corporativo */
        }
        body { background-color: #e9ecef; }
        .report-container { /* Contenedor principal */
            max-width: 900px; /* Ancho original para este informe */
            margin: 20px auto; padding: 40px;
            background-color: #ffffff; border: 1px solid #dee2e6;
            box-shadow: 0 0.125rem 0.25rem rgba(0, 0, 0, .075);
            position: relative; /* Para posicionar los botones */
        }
        /* NUEVA CABECERA */
        .report-brand-header { color: var(--custom-brand-purple); font-weight: bold; font-size: 1.5rem; margin-bottom: 0; }
        .report-title-header { font-size: 1.25rem; font-weight: 300; color: #495057; border-bottom: 1px solid #dee2e6; padding-bottom: 10px; margin-bottom: 30px; }
        /* NUEVOS BOTONES */
        .report-buttons { position: absolute; top: 35px; right: 40px; }
        /* TABLA (estilos existentes) */
        .section-title { font-weight: 600; border-bottom: 1px solid #dee2e6; padding-bottom: 8px; margin-top: 25px; margin-bottom: 15px; color: #31a3a3; }
        .media-table { font-size: 0.9rem; }
        .media-table th { background-color: #f8f9fa; }
        .media-table td { vertical-align: middle; }
        .report-thumbnail { max-width: 120px; max-height: 80px; object-fit: cover; border: 1px solid #dee2e6; border-radius: 4px; }
        .video-icon { font-size: 2rem; color: #6c757d; }

        /* ESTILOS DE IMPRESIÓN */
        @media print {
            body { background-color: #ffffff; margin: 0; font-size: 10pt; }
            .no-print { display: none !important; }
            .report-container { width: 100%; max-width: 100%; margin: 0; padding: 10mm; border: none; box-shadow: none; position: static; }
            /* Mostrar ambos títulos y centrarlos */
             .report-brand-header, .report-title-header { text-align: center; display: block !important; }
             .report-brand-header { margin-bottom: 5px; font-size: 1.2rem; color: var(--custom-brand-purple) !important; }
             .report-title-header { margin-bottom: 20px; border-bottom: 1px solid #ccc; padding-bottom: 10px; font-size: 1rem; color: #333 !important; }
            /* Asegurar colores de tabla */
            .media-table th { background-color: #f8f9fa !important; -webkit-print-color-adjust: exact; print-color-adjust: exact; }
            .media-table { font-size: 9pt; }
            .report-thumbnail { border: 1px solid #ccc !important; }
            a { text-decoration: none; color: #000 !important; }
        }
    </style>
</head>
<body>

    <div class="report-container" id="report-content">

        <header class="mb-4 no-print">
            <h4 class="report-brand-header">Avant Online</h4>
            <h1 class="report-title-header"><?= $page_title ?></h1>
        </header>

        <div class="report-buttons no-print">
            <a href="<?= htmlspecialchars($return_url) ?>" class="btn btn-secondary">
                <i class="bi bi-arrow-left me-1"></i>Tornar
            </a>
            <button id="print-btn" class="btn btn-primary">
                <i class="bi bi-printer me-1"></i>Imprimir
            </button>
        </div>

        <main>
             <header class="d-none d-print-block text-center">
                 <h4 class="report-brand-header">Avant Online</h4>
                 <h1 class="report-title-header"><?= $page_title ?></h1>
            </header>

            <section id="video-list">
                <h3 class="section-title">Vídeos Disponibles (<?= count($videos) ?>)</h3>
                <?php if (empty($videos)): ?>
                    <p class="text-muted">No s'han trobat vídeos registrats.</p>
                <?php else: ?>
                    <table class="table table-sm table-bordered table-striped media-table">
                        <thead class="table-light">
                            <tr>
                                <th style="width: 120px;">Media</th>
                                <th>Títol</th>
                                <th>Nom de l'Arxiu</th>
                            </tr>
                        </thead>
                        <tbody>
                        <?php foreach ($videos as $video): ?>
                            <tr>
                                <td class="text-center">
                                    <i class="bi bi-film video-icon"></i>
                                </td>
                                <td><?= htmlspecialchars($video['title'] ?? 'Sense títol') ?></td>
                                <td><?= htmlspecialchars($video['filename']) ?></td>
                            </tr>
                        <?php endforeach; ?>
                        </tbody>
                    </table>
                <?php endif; ?>
            </section>

            <section id="image-list">
                <h3 class="section-title">Imatges Disponibles (<?= count($images) ?>)</h3>
                <?php if (empty($images)): ?>
                    <p class="text-muted">No s'han trobat imatges registrades.</p>
                <?php else: ?>
                    <table class="table table-sm table-bordered table-striped media-table">
                         <thead class="table-light">
                             <tr>
                                <th style="width: 120px;">Miniatura</th>
                                <th>Títol</th>
                                <th>Nom de l'Arxiu</th>
                            </tr>
                        </thead>
                        <tbody>
                        <?php foreach ($images as $image): ?>
                            <tr>
                                <td>
                                    <img src="../images/<?= htmlspecialchars($image['filename']) ?>" alt="<?= htmlspecialchars($image['title'] ?? '') ?>" class="report-thumbnail">
                                </td>
                                <td><?= htmlspecialchars($image['title'] ?? 'Sense títol') ?></td>
                                <td><?= htmlspecialchars($image['filename']) ?></td>
                            </tr>
                        <?php endforeach; ?>
                        </tbody>
                    </table>
                <?php endif; ?>
            </section>
        </main>
    </div>

    <script>
        document.getElementById('print-btn').addEventListener('click', function() {
            window.print();
        });
    </script>
</body>
</html>
